/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;
import org.springframework.dao.DataIntegrityViolationException;
import reactor.test.StepVerifier;

public class CertPolicyRepository_addPolicyTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testAddPolicy_addPolicy_assertAdded() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.polRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)policies.size());
        CertPolicy addedPolicy = (CertPolicy)policies.iterator().next();
        Assertions.assertEquals((Object)policy.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assertions.assertEquals((int)policy.getLexicon(), (int)addedPolicy.getLexicon());
        Assertions.assertTrue((now.compareTo(addedPolicy.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), addedPolicy.getPolicyData()));
    }

    @Test
    public void testAddPolicy_addExistingPolicy_assertException() {
        Assertions.assertThrows(DataIntegrityViolationException.class, () -> {
            CertPolicy policy = new CertPolicy();
            policy.setPolicyName("Test PolicY");
            policy.setLexicon(PolicyLexicon.XML.ordinal());
            policy.setPolicyData(new byte[]{1, 2, 3});
            ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
            Collection policies = (Collection)this.polRepo.findAll().collectList().block();
            Assertions.assertEquals((int)1, (int)policies.size());
            policy = new CertPolicy();
            policy.setPolicyName("Test PolicY");
            policy.setLexicon(PolicyLexicon.XML.ordinal());
            policy.setPolicyData(new byte[]{1, 2, 3});
            this.polRepo.save((Object)policy).block();
        });
    }
}

