/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;
import reactor.test.StepVerifier;

public class CertPolicyRepository_deletePoliciesTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testDeletePolicies_singlePolicy_assertPolicyDeleted() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.polRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)policies.size());
        this.polRepo.deleteById((Object)((CertPolicy)policies.iterator().next()).getId()).block();
        policies = (Collection)this.polRepo.findAll().collectList().block();
        Assertions.assertEquals((int)0, (int)policies.size());
    }

    @Test
    public void testDeletePolicies_multiplePolicies_assertSinglePolicyDeleted() {
        CertPolicy policy1 = new CertPolicy();
        policy1.setPolicyName("Test Policy1");
        policy1.setLexicon(PolicyLexicon.XML.ordinal());
        policy1.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy policy2 = new CertPolicy();
        policy2.setPolicyName("Test Policy2");
        policy2.setLexicon(PolicyLexicon.JAVA_SER.ordinal());
        policy2.setPolicyData(new byte[]{4, 5, 6});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.polRepo.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)policies.size());
        this.polRepo.deleteByIdIn(Arrays.asList(((CertPolicy)policies.iterator().next()).getId())).block();
        policies = (Collection)this.polRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)policies.size());
    }

    @Test
    public void testDeletePolicies_multiplePolicyes_assertAllPoliciesDeleted() {
        CertPolicy policy1 = new CertPolicy();
        policy1.setPolicyName("Test Policy1");
        policy1.setLexicon(PolicyLexicon.XML.ordinal());
        policy1.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy1).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy policy2 = new CertPolicy();
        policy2.setPolicyName("Test Policy2");
        policy2.setLexicon(PolicyLexicon.JAVA_SER.ordinal());
        policy2.setPolicyData(new byte[]{4, 5, 6});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy2).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection policies = (Collection)this.polRepo.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)policies.size());
        Iterator iter = policies.iterator();
        this.polRepo.deleteByIdIn(Arrays.asList(((CertPolicy)iter.next()).getId(), ((CertPolicy)iter.next()).getId())).block();
        policies = (Collection)this.polRepo.findAll().collectList().block();
        Assertions.assertEquals((int)0, (int)policies.size());
    }
}

