/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;
import reactor.test.StepVerifier;

public class CertPolicyRepository_getPolicyByIdTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testGetPolicyById_emptyStore_assertNoPolicyReturned() {
        ((StepVerifier.FirstStep)this.polRepo.findById((Object)1234L).as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicyById_singlePolicyInStore_idNotInStore_assertNoPolicyReturned() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test Policy");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        ((StepVerifier.FirstStep)this.polRepo.findById((Object)1234L).as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testGetPolicyById_singlePolicyInStore_assertPolicyReturned() {
        LocalDateTime now = LocalDateTime.now();
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy addedPolicy = (CertPolicy)this.polRepo.findById((Object)policy.getId()).block();
        Assertions.assertEquals((Object)policy.getPolicyName(), (Object)addedPolicy.getPolicyName());
        Assertions.assertEquals((int)policy.getLexicon(), (int)addedPolicy.getLexicon());
        Assertions.assertTrue((now.compareTo(addedPolicy.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), addedPolicy.getPolicyData()));
    }
}

