/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.CertPolicyDaoBaseTest;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.policy.PolicyLexicon;
import reactor.test.StepVerifier;

public class CertPolicyRepository_updatePolicyAttributesTest
extends CertPolicyDaoBaseTest {
    @Test
    public void testUpdatePolicyAttributes_updateName_assertUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy addedPolicy = (CertPolicy)this.polRepo.findById((Object)policy.getId()).block();
        Assertions.assertNotNull((Object)addedPolicy);
        addedPolicy.setPolicyName("Test Pol");
        ((StepVerifier.FirstStep)this.polRepo.save((Object)addedPolicy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy updatedPolicy = (CertPolicy)this.polRepo.findById((Object)policy.getId()).block();
        Assertions.assertEquals((Object)"Test Pol", (Object)updatedPolicy.getPolicyName());
        Assertions.assertEquals((int)policy.getLexicon(), (int)updatedPolicy.getLexicon());
        Assertions.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_updateData_assertUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy addedPolicy = (CertPolicy)this.polRepo.findById((Object)policy.getId()).block();
        Assertions.assertNotNull((Object)addedPolicy);
        addedPolicy.setPolicyData(new byte[]{4, 5, 6});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)addedPolicy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy updatedPolicy = (CertPolicy)this.polRepo.findById((Object)policy.getId()).block();
        Assertions.assertEquals((Object)policy.getPolicyName(), (Object)updatedPolicy.getPolicyName());
        Assertions.assertEquals((int)policy.getLexicon(), (int)updatedPolicy.getLexicon());
        Assertions.assertTrue((boolean)Arrays.equals(new byte[]{4, 5, 6}, updatedPolicy.getPolicyData()));
    }

    @Test
    public void testUpdatePolicyAttributes_updateLexicon_assertUpdated() {
        CertPolicy policy = new CertPolicy();
        policy.setPolicyName("Test PolicY");
        policy.setLexicon(PolicyLexicon.XML.ordinal());
        policy.setPolicyData(new byte[]{1, 2, 3});
        ((StepVerifier.FirstStep)this.polRepo.save((Object)policy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy addedPolicy = (CertPolicy)this.polRepo.findById((Object)policy.getId()).block();
        Assertions.assertNotNull((Object)addedPolicy);
        addedPolicy.setLexicon(PolicyLexicon.JAVA_SER.ordinal());
        ((StepVerifier.FirstStep)this.polRepo.save((Object)addedPolicy).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        CertPolicy updatedPolicy = (CertPolicy)this.polRepo.findById((Object)policy.getId()).block();
        Assertions.assertEquals((Object)policy.getPolicyName(), (Object)updatedPolicy.getPolicyName());
        Assertions.assertEquals((int)PolicyLexicon.JAVA_SER.ordinal(), (int)updatedPolicy.getLexicon());
        Assertions.assertTrue((boolean)Arrays.equals(policy.getPolicyData(), updatedPolicy.getPolicyData()));
    }
}

