/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.File;
import java.security.cert.X509Certificate;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.repository.CertificateRepository;
import org.nhindirect.config.repository.CertificateRepositoryTest;
import org.nhindirect.config.store.Certificate;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.test.StepVerifier;

public class CertificateDao_stripP12ProtectionNoManagerTest
extends SpringBaseTest {
    private static final String certBasePath = "src/test/resources/certs/";
    @Autowired
    private CertificateRepository repo;

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @BeforeEach
    public void cleanDataBase() {
        this.repo.deleteAll().block();
    }

    protected Certificate populateCert(String certFile, String keyFile) throws Exception {
        byte[] certData = keyFile != null && !keyFile.isEmpty() ? CertificateRepositoryTest.loadPkcs12FromCertAndKey(certFile, keyFile) : CertificateDao_stripP12ProtectionNoManagerTest.loadCertificateData(certFile);
        Certificate cert = new Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        return cert;
    }

    @Test
    public void testStripP12ProtectionTest_NoP12ProtectionOrManager_assertP12Returned() throws Exception {
        this.populateCert("gm2552.der", "gm2552Key.der");
        Certificate cert = (Certificate)this.repo.findAll().blockFirst();
        Assertions.assertTrue((boolean)cert.isPrivateKey());
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assertions.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    @Test
    public void testStripP12ProtectionTest_X509CertAndNoManager_assertX509Returned() throws Exception {
        this.populateCert("gm2552.der", null);
        Certificate cert = (Certificate)this.repo.findAll().blockFirst();
        Assertions.assertFalse((boolean)cert.isPrivateKey());
        byte[] certData = CertificateDao_stripP12ProtectionNoManagerTest.loadCertificateData("gm2552.der");
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assertions.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    @Test
    public void testStripP12ProtectionTest_X509CertAndWrappedData_noMager_assertX509Returned() throws Exception {
        byte[] certData = CertificateDao_stripP12ProtectionNoManagerTest.loadCertificateData("gm2552.der");
        byte[] keyData = CertificateDao_stripP12ProtectionNoManagerTest.loadCertificateData("gm2552Key.der");
        Certificate addCert = new Certificate();
        addCert.setData(CertUtils.certAndWrappedKeyToRawByteFormat((byte[])keyData, (X509Certificate)CertUtils.toX509Certificate((byte[])certData)));
        addCert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)addCert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Certificate cert = (Certificate)this.repo.findAll().blockFirst();
        Assertions.assertTrue((boolean)cert.isPrivateKey());
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])certData);
        Assertions.assertEquals((Object)container.getCert(), (Object)CertUtils.toCertContainer((byte[])cert.getData()).getCert());
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

