/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.CertificateRepository;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.test.StepVerifier;

public class CertificateRepositoryTest
extends SpringBaseTest {
    private static final String certBasePath = "src/test/resources/certs/";
    @Autowired
    private CertificateRepository repo;

    @BeforeEach
    public void cleanDataBase() {
        this.repo.deleteAll().block();
    }

    private static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    public static byte[] loadPkcs12FromCertAndKey(String certFileName, String keyFileName) throws Exception {
        byte[] retVal = null;
        try {
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
            localKeyStore.load(null, null);
            byte[] certData = CertificateRepositoryTest.loadCertificateData(certFileName);
            byte[] keyData = CertificateRepositoryTest.loadCertificateData(keyFileName);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream inStr = new ByteArrayInputStream(certData);
            Certificate cert = cf.generateCertificate(inStr);
            ((InputStream)inStr).close();
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keysp = new PKCS8EncodedKeySpec(keyData);
            PrivateKey privKey = kf.generatePrivate(keysp);
            char[] array = "".toCharArray();
            localKeyStore.setKeyEntry("privCert", privKey, array, new Certificate[]{cert});
            ByteArrayOutputStream outStr = new ByteArrayOutputStream();
            localKeyStore.store(outStr, array);
            retVal = outStr.toByteArray();
            outStr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    @Test
    public void testCleanDatabase() throws Exception {
        ((StepVerifier.FirstStep)this.repo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testAddPublicCert() throws Exception {
        byte[] certData = CertificateRepositoryTest.loadCertificateData("gm2552.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        ((StepVerifier.FirstStep)this.repo.findAll().as(StepVerifier::create)).assertNext(s -> s.getOwner().equals("gm2552@cerner.com")).verifyComplete();
    }

    @Test
    public void testAddPKIXURL() throws Exception {
        this.testCleanDatabase();
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData("http://localhost/test.der".getBytes());
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        org.nhindirect.config.store.Certificate addedCert = (org.nhindirect.config.store.Certificate)this.repo.findAll().blockFirst();
        Assertions.assertEquals((Object)"", (Object)addedCert.getThumbprint());
        Assertions.assertEquals((Object)"http://localhost/test.der", (Object)new String(addedCert.getData()));
    }

    @Test
    public void testAddPrivateCert() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        ((StepVerifier.FirstStep)this.repo.findAll().as(StepVerifier::create)).assertNext(s -> s.getOwner().equals("gm2552@cerner.com")).verifyComplete();
    }

    @Test
    public void testGetByOwner() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        ((StepVerifier.FirstStep)this.repo.findByOwnerIgnoreCase("gm2552@cerner.com").as(StepVerifier::create)).assertNext(s -> s.getOwner().equals("gm2552@cerner.com")).verifyComplete();
        ((StepVerifier.FirstStep)this.repo.deleteAll().as(StepVerifier::create)).verifyComplete();
        certData = CertificateRepositoryTest.loadCertificateData("gm2552.der");
        cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        ((StepVerifier.FirstStep)this.repo.findByOwnerIgnoreCase("gm2552@cerner.com").as(StepVerifier::create)).assertNext(s -> s.getOwner().equals("gm2552@cerner.com")).verifyComplete();
    }

    @Test
    public void testGetById() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        cert = (org.nhindirect.config.store.Certificate)this.repo.findAll().blockFirst();
        ((StepVerifier.FirstStep)this.repo.findAllById(Arrays.asList(cert.getId())).as(StepVerifier::create)).assertNext(s -> s.getOwner().equals("gm2552@cerner.com")).verifyComplete();
    }

    @Test
    public void testDeleteByOwner() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        cert = (org.nhindirect.config.store.Certificate)this.repo.findByOwnerIgnoreCase("gm2552@cerner.com").blockFirst();
        Assertions.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
        ((StepVerifier.FirstStep)this.repo.deleteByOwnerIgnoreCase("gm2552@cerner.com").as(StepVerifier::create)).verifyComplete();
        ((StepVerifier.FirstStep)this.repo.findByOwnerIgnoreCase("gm2552@cerner.com").as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testDeleteById() throws Exception {
        this.testCleanDatabase();
        byte[] certData = CertificateRepositoryTest.loadPkcs12FromCertAndKey("gm2552.der", "gm2552Key.der");
        org.nhindirect.config.store.Certificate cert = new org.nhindirect.config.store.Certificate();
        cert.setData(certData);
        cert.setOwner("gm2552@cerner.com");
        ((StepVerifier.FirstStep)this.repo.save((Object)cert).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        cert = (org.nhindirect.config.store.Certificate)this.repo.findByOwnerIgnoreCase("gm2552@cerner.com").blockFirst();
        Assertions.assertEquals((Object)"gm2552@cerner.com", (Object)cert.getOwner());
        ((StepVerifier.FirstStep)this.repo.deleteById((Object)cert.getId()).as(StepVerifier::create)).verifyComplete();
        ((StepVerifier.FirstStep)this.repo.findByOwnerIgnoreCase("gm2552@cerner.com").as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

