/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.DNSRepository;
import org.nhindirect.config.store.DNSRecord;
import org.nhindirect.config.store.util.DNSRecordUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import reactor.test.StepVerifier;

public class DNSRepositoryTest
extends SpringBaseTest {
    private static final String certBasePath = "src/test/resources/certs/";
    @Autowired
    private DNSRepository dnsRepo;

    private byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.dnsRepo.deleteAll().block();
    }

    @Test
    public void testCleanDatabase() throws Exception {
        ((StepVerifier.FirstStep)this.dnsRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testAddCertRecord() throws Exception {
        byte[] certData = this.loadCertificateData("gm2552.der");
        Assertions.assertNotNull((Object)certData);
        ByteArrayInputStream bais = new ByteArrayInputStream(certData);
        X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
        DNSRecord record1 = DNSRecordUtils.createX509CERTRecord((String)"gm2552@securehealthemail.com", (long)86400L, (X509Certificate)cert);
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record1)).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List records = (List)this.dnsRepo.findByType(37).collectList().block();
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertEquals((Object)record1, records.iterator().next());
    }

    @Test
    public void testAddSingleARecords() throws Exception {
        DNSRecord record = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record)).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection records = (Collection)this.dnsRepo.findByNameIgnoreCase(record.getName()).collectList().block();
        Assertions.assertEquals((int)1, (int)records.size());
        DNSRecord compareRec = (DNSRecord)records.iterator().next();
        Assertions.assertEquals((Object)record.getName(), (Object)compareRec.getName());
        Assertions.assertEquals((int)1, (int)compareRec.getType());
    }

    @Test
    public void testMultipleARecords() throws Exception {
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"74.22.43.123");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"sample.domain.com", (long)86400L, (String)"81.142.48.20");
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3)).as(StepVerifier::create)).expectNextCount(3L).verifyComplete();
        Collection records = (Collection)this.dnsRepo.findByNameIgnoreCase(record1.getName().toUpperCase()).collectList().block();
        Assertions.assertEquals((int)1, (int)records.size());
        DNSRecord compareRec = (DNSRecord)records.iterator().next();
        Assertions.assertEquals((Object)record1.getName(), (Object)compareRec.getName());
        Assertions.assertEquals((int)1, (int)compareRec.getType());
        records = (Collection)this.dnsRepo.findAll().collectList().block();
        Assertions.assertEquals((int)3, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record1));
        Assertions.assertTrue((boolean)records.contains(record2));
        Assertions.assertTrue((boolean)records.contains(record3));
        records = (Collection)this.dnsRepo.findByType(1).collectList().block();
        Assertions.assertEquals((int)3, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record1));
        Assertions.assertTrue((boolean)records.contains(record2));
        Assertions.assertTrue((boolean)records.contains(record3));
        records = (Collection)this.dnsRepo.findByType(33).collectList().block();
        Assertions.assertEquals((int)0, (int)records.size());
    }

    @Test
    public void testAddRecord_invalidType() throws Exception {
    }

    @Test
    public void testAddRecord_recordAlreadyExistsWithRdata() throws Exception {
    }

    @Test
    public void testMultipleARecords_differentRdata() throws Exception {
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record1)).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record2)).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection records = (Collection)this.dnsRepo.findByNameIgnoreCase(record1.getName()).collectList().block();
        Assertions.assertEquals((int)2, (int)records.size());
        records.contains(record1);
        records.contains(record2);
    }

    @Test
    public void testGetByType() throws Exception {
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record3 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3)).as(StepVerifier::create)).expectNextCount(3L).verifyComplete();
        Collection records = (Collection)this.dnsRepo.findByType(1).collectList().block();
        Assertions.assertEquals((int)2, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record1));
        Assertions.assertTrue((boolean)records.contains(record2));
        records = (Collection)this.dnsRepo.findByType(33).collectList().block();
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record3));
        records = (Collection)this.dnsRepo.findAll().collectList().block();
        Assertions.assertEquals((int)3, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record1));
        Assertions.assertTrue((boolean)records.contains(record2));
        Assertions.assertTrue((boolean)records.contains(record3));
    }

    @Test
    public void testGetByName() throws Exception {
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3, record4, record5)).as(StepVerifier::create)).expectNextCount(5L).verifyComplete();
        Collection records = (Collection)this.dnsRepo.findByNameIgnoreCase(record1.getName().toUpperCase()).collectList().block();
        Assertions.assertEquals((int)2, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record1));
        Assertions.assertTrue((boolean)records.contains(record2));
        records = (Collection)this.dnsRepo.findByNameIgnoreCase(record3.getName()).collectList().block();
        Assertions.assertEquals((int)1, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record3));
        records = (Collection)this.dnsRepo.findByNameIgnoreCase(record4.getName()).collectList().block();
        Assertions.assertEquals((int)2, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record4));
        Assertions.assertTrue((boolean)records.contains(record5));
        records = (Collection)this.dnsRepo.findByNameIgnoreCase("bogus.com.").collectList().block();
        Assertions.assertEquals((int)0, (int)records.size());
    }

    @Test
    public void testGetByRecord() throws Exception {
        this.testCleanDatabase();
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3, record4, record5)).as(StepVerifier::create)).expectNextCount(5L).verifyComplete();
        Collection records = (Collection)this.dnsRepo.findByNameIgnoreCase(record3.getName()).collectList().block();
        Assertions.assertEquals((int)1, (int)records.size());
        DNSRecord checkRec = (DNSRecord)this.dnsRepo.findById((Object)((DNSRecord)records.iterator().next()).getId()).block();
        Assertions.assertNotNull((Object)checkRec);
        Assertions.assertEquals((Object)checkRec, (Object)record3);
        records = (Collection)this.dnsRepo.findAll().collectList().block();
        Assertions.assertEquals((int)5, (int)records.size());
        ArrayList<Long> ids = new ArrayList<Long>(records.size());
        for (DNSRecord record : records) {
            ids.add(record.getId());
        }
        records = (Collection)this.dnsRepo.findAllById(ids).collectList().block();
        Assertions.assertEquals((int)5, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record1));
        Assertions.assertTrue((boolean)records.contains(record2));
        Assertions.assertTrue((boolean)records.contains(record3));
        Assertions.assertTrue((boolean)records.contains(record4));
        Assertions.assertTrue((boolean)records.contains(record5));
    }

    @Test
    public void testGetCount() throws Exception {
        Assertions.assertEquals((int)0, (int)((Long)this.dnsRepo.count().block()).intValue());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3, record4, record5)).as(StepVerifier::create)).expectNextCount(5L).verifyComplete();
        Assertions.assertEquals((int)5, (int)((Long)this.dnsRepo.count().block()).intValue());
    }

    @Test
    public void testRemoveByRecords() throws Exception {
        Assertions.assertEquals((int)0, (int)((Long)this.dnsRepo.count().block()).intValue());
        DNSRecord record1 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.1");
        DNSRecord record2 = DNSRecordUtils.createARecord((String)"example.domain.com", (long)86400L, (String)"127.0.0.2");
        DNSRecord record3 = DNSRecordUtils.createARecord((String)"example2.domain.com", (long)86400L, (String)"127.0.0.3");
        DNSRecord record4 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        DNSRecord record5 = DNSRecordUtils.createSRVRecord((String)"_ldap_cerner._tcp.cerner.com", (String)"example2.domain.com", (long)86400L, (int)3506, (int)1, (int)1);
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record1, record2, record3, record4, record5)).as(StepVerifier::create)).expectNextCount(5L).verifyComplete();
        Assertions.assertEquals((int)5, (int)((Long)this.dnsRepo.count().block()).intValue());
        ((StepVerifier.FirstStep)this.dnsRepo.deleteAll(Arrays.asList(record1, record2, record3)).as(StepVerifier::create)).verifyComplete();
        Collection records = (Collection)this.dnsRepo.findAll().collectList().block();
        Assertions.assertEquals((int)2, (int)records.size());
        Assertions.assertTrue((boolean)records.contains(record4));
        Assertions.assertTrue((boolean)records.contains(record5));
        ((StepVerifier.FirstStep)this.dnsRepo.deleteAll(Arrays.asList(record4, record5)).as(StepVerifier::create)).verifyComplete();
        ((StepVerifier.FirstStep)this.dnsRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testRemoveByIds_noqualifying() throws Exception {
        Assertions.assertEquals((int)0, (int)((Long)this.dnsRepo.count().block()).intValue());
        try {
            ((StepVerifier.FirstStep)this.dnsRepo.deleteById((Object)876343L).as(StepVerifier::create)).verifyComplete();
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)((Long)this.dnsRepo.count().block()).intValue());
    }

    @Test
    public void testUpdateRecord() throws Exception {
        Assertions.assertEquals((int)0, (int)((Long)this.dnsRepo.count().block()).intValue());
        DNSRecord record1 = DNSRecordUtils.createMXRecord((String)"example.domain.com", (String)"127.0.0.1", (long)86400L, (int)1);
        ((StepVerifier.FirstStep)this.dnsRepo.saveAll(Arrays.asList(record1)).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection records = (Collection)this.dnsRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)records.size());
        DNSRecord checkRecord = (DNSRecord)records.iterator().next();
        Assertions.assertEquals((Object)record1, (Object)checkRecord);
        checkRecord.setName("example2.domain.com.");
        ((StepVerifier.FirstStep)this.dnsRepo.save((Object)checkRecord).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        records = (Collection)this.dnsRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)records.size());
        DNSRecord modRecord = (DNSRecord)records.iterator().next();
        Assertions.assertEquals((Object)checkRecord, (Object)modRecord);
    }

    @Test
    public void testUpdateRecord_recordDoesNotExist() throws Exception {
    }

    @Test
    public void testUpdateRecord_illegalAnyType() throws Exception {
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

