/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import reactor.test.StepVerifier;

public class DomainRepositoryTest
extends SpringBaseTest {
    private static final Logger log = LoggerFactory.getLogger(DomainRepositoryTest.class);
    @Autowired
    private DomainRepository domRepo;
    @Autowired
    private AddressRepository addRepo;

    @BeforeEach
    public void cleanDataBase() {
        ((StepVerifier.FirstStep)this.addRepo.deleteAll().as(StepVerifier::create)).verifyComplete();
        ((StepVerifier.FirstStep)this.domRepo.deleteAll().as(StepVerifier::create)).verifyComplete();
    }

    @Test
    public void testCleanDatabase() {
        ((StepVerifier.FirstStep)this.addRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
        ((StepVerifier.FirstStep)this.domRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testAddDomain() {
        Domain domain = new Domain();
        domain.setDomainName("health.testdomain.com");
        domain.setStatus(EntityStatus.ENABLED.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
    }

    @Test
    public void testGetByDomain() {
        Domain domain = new Domain();
        domain.setDomainName("health.testdomain.com");
        domain.setStatus(EntityStatus.ENABLED.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Domain testDomain = (Domain)this.domRepo.findByDomainNameIgnoreCase("health.testdomain.com").block();
        log.info("Newly added Domain ID is: {}", (Object)testDomain.getId());
        log.info("Newly added Domain Status is: {}", (Object)testDomain.getStatus());
        Assertions.assertTrue((boolean)testDomain.getDomainName().equals("health.testdomain.com"));
    }

    @Test
    public void testUpdateDomain() {
        Domain domain = new Domain();
        domain.setDomainName("health.testdomain.com");
        domain.setStatus(EntityStatus.ENABLED.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Domain testDomain = (Domain)this.domRepo.findByDomainNameIgnoreCase("health.testdomain.cOM").block();
        log.info("Newly added Domain ID is: {}", (Object)testDomain.getId());
        log.info("Newly added Domain Status is: {}", (Object)testDomain.getStatus());
        Assertions.assertTrue((boolean)testDomain.getDomainName().equals("health.testdomain.com"));
        testDomain.setStatus(EntityStatus.DISABLED.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)testDomain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        domain = (Domain)this.domRepo.findByDomainNameIgnoreCase("health.testdomain.com").block();
        log.info("Updated Domain ID is: {}", (Object)domain.getId());
        log.info("Updated Status is: {}", (Object)domain.getStatus());
        Assertions.assertTrue((domain.getStatus() == EntityStatus.DISABLED.ordinal() ? 1 : 0) != 0);
    }

    @Test
    public void testGetDomain() {
        Domain domain = new Domain();
        domain.setDomainName("health.testdomain.com");
        domain.setStatus(EntityStatus.NEW.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        domain = new Domain();
        domain.setDomainName("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        ArrayList<String> names = new ArrayList<String>();
        names.add("health.testdomain.com".toUpperCase());
        List findDoms = (List)this.domRepo.findByDomainNameInIgnoreCaseAndStatus(names, EntityStatus.NEW.ordinal()).collectList().block();
        Assertions.assertEquals((int)findDoms.size(), (int)1);
        findDoms = (List)this.domRepo.findByStatus(EntityStatus.NEW.ordinal()).collectList().block();
        Assertions.assertEquals((int)findDoms.size(), (int)2);
        findDoms = (List)this.domRepo.findByDomainNameInIgnoreCase(names).collectList().block();
        Assertions.assertEquals((int)findDoms.size(), (int)1);
        findDoms = (List)this.domRepo.findByDomainNameInIgnoreCaseAndStatus(names, EntityStatus.ENABLED.ordinal()).collectList().block();
        Assertions.assertEquals((int)findDoms.size(), (int)0);
        findDoms = (List)this.domRepo.findByDomainNameInIgnoreCaseAndStatus(names, EntityStatus.DISABLED.ordinal()).collectList().block();
        Assertions.assertEquals((int)findDoms.size(), (int)0);
        findDoms = (List)this.domRepo.findAll().collectList().block();
        Assertions.assertEquals((int)findDoms.size(), (int)2);
        names.clear();
        names.add("health.baddomain.com");
        ((StepVerifier.FirstStep)this.domRepo.findByDomainNameInIgnoreCase(names).as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public void testDeleteDomain() {
        Domain domain = new Domain();
        domain.setDomainName("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Assertions.assertEquals((Long)1L, (Long)((Long)this.domRepo.count().block()));
        ((StepVerifier.FirstStep)this.domRepo.deleteByDomainNameIgnoreCase("health.testdomain.cOM").as(StepVerifier::create)).verifyComplete();
        Assertions.assertEquals((Long)1L, (Long)((Long)this.domRepo.count().block()));
        ((StepVerifier.FirstStep)this.domRepo.deleteByDomainNameIgnoreCase("health.newdomain.com").as(StepVerifier::create)).verifyComplete();
        Assertions.assertEquals((Long)0L, (Long)((Long)this.domRepo.count().block()));
    }

    @Test
    public void testSearchDomain() {
        Domain domain = new Domain();
        domain.setDomainName("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        domain = new Domain();
        domain.setDomainName("healthy.domain.com");
        domain.setStatus(EntityStatus.NEW.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        String name = "heaL";
        List result = (List)this.domRepo.findByDomainNameContainingIgnoreCase("%" + name.toUpperCase() + "%").collectList().block();
        Assertions.assertEquals((int)2, (int)result.size());
        name = "coM";
        result = (List)this.domRepo.findByDomainNameContainingIgnoreCaseAndStatus("%" + name.toUpperCase() + "%", EntityStatus.NEW.ordinal()).collectList().block();
        Assertions.assertEquals((int)2, (int)result.size());
        name = "coM";
        result = (List)this.domRepo.findByDomainNameContainingIgnoreCaseAndStatus("%" + name.toUpperCase() + "%", EntityStatus.DISABLED.ordinal()).collectList().block();
        Assertions.assertEquals((int)0, (int)result.size());
        log.debug("Exit");
    }

    @Test
    public void testAddDomainsWithAddresses() {
        Domain domain = new Domain();
        domain.setDomainName("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Address addr = new Address(domain.getId(), "test1@health.newdomain.com", "Test1");
        ((StepVerifier.FirstStep)this.addRepo.save((Object)addr).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        addr = new Address(domain.getId(), "test2@health.newdomain.com", "Test2");
        ((StepVerifier.FirstStep)this.addRepo.save((Object)addr).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        addr = new Address(domain.getId(), "postmaster@health.newdomain.com", "Test3");
        ((StepVerifier.FirstStep)this.addRepo.save((Object)addr).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List getAddrs = (List)this.addRepo.findByDomainId(domain.getId()).collectList().block();
        Assertions.assertEquals((int)3, (int)getAddrs.size());
        Address postmasterAddr = (Address)this.addRepo.findByEmailAddressIgnoreCase("postmaster@health.newDOMAIN.com").block();
        Assertions.assertNotNull((Object)postmasterAddr);
        Domain getDomain = (Domain)this.domRepo.findByDomainNameIgnoreCase("health.newdomain.com").block();
        getDomain.setPostmasterAddressId(postmasterAddr.getId());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)getDomain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        getDomain = (Domain)this.domRepo.findByDomainNameIgnoreCase("health.newdomain.com").block();
        Assertions.assertEquals((Long)postmasterAddr.getId(), (Long)getDomain.getPostmasterAddressId());
    }

    @Test
    public void testDeleteDomainsWithAddresses() {
        Domain domain = new Domain();
        domain.setDomainName("health.newdomain.com");
        domain.setStatus(EntityStatus.NEW.ordinal());
        ((StepVerifier.FirstStep)this.domRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Address addr = new Address(domain.getId(), "test1@health.newdomain.com", "Test1");
        ((StepVerifier.FirstStep)this.addRepo.save((Object)addr).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        addr = new Address(domain.getId(), "test2@health.newdomain.com", "Test2");
        ((StepVerifier.FirstStep)this.addRepo.save((Object)addr).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List getAddrs = (List)this.addRepo.findByDomainId(domain.getId()).collectList().block();
        Assertions.assertEquals((int)2, (int)getAddrs.size());
        Domain addedDomain = (Domain)this.domRepo.findByDomainNameIgnoreCase("health.newdomain.com").block();
        boolean exceptionOccured = false;
        try {
            this.domRepo.deleteByDomainNameIgnoreCase("health.newdomain.COM").block();
        }
        catch (DataIntegrityViolationException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        addedDomain = (Domain)this.domRepo.findByDomainNameIgnoreCase("health.newdomain.com").block();
        Assertions.assertNotNull((Object)addedDomain);
        this.addRepo.deleteByDomainId(addedDomain.getId()).block();
        getAddrs = (List)this.addRepo.findByDomainId(domain.getId()).collectList().block();
        Assertions.assertEquals((int)0, (int)getAddrs.size());
        this.domRepo.deleteByDomainNameIgnoreCase("health.newdomain.COM").block();
        addedDomain = (Domain)this.domRepo.findByDomainNameIgnoreCase("health.newdomain.com").block();
        Assertions.assertNull((Object)addedDomain);
    }
}

