/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.SpringBaseTest;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.repository.TrustBundleAnchorRepository;
import org.nhindirect.config.repository.TrustBundleDomainReltnRepository;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.test.StepVerifier;

public abstract class TrustBundleDaoBaseTest
extends SpringBaseTest {
    @Autowired
    protected TrustBundleRepository tbRepo;
    @Autowired
    protected TrustBundleAnchorRepository tbAncRepo;
    @Autowired
    protected DomainRepository dmRepo;
    @Autowired
    protected TrustBundleDomainReltnRepository reltnRepo;
    protected static final String certBasePath = "src/test/resources/certs/";

    protected static byte[] loadCertificateData(String certFileName) throws Exception {
        File fl = new File(certBasePath + certFileName);
        return FileUtils.readFileToByteArray((File)fl);
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.clearRetlns();
        this.clearBundles();
        this.clearDomains();
    }

    @AfterEach
    public void tearDown() {
        this.clearRetlns();
        this.clearBundles();
        this.clearDomains();
    }

    protected void clearRetlns() {
        this.reltnRepo.deleteAll().block();
        ((StepVerifier.FirstStep)this.reltnRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    protected void clearBundles() {
        this.tbAncRepo.deleteAll().block();
        ((StepVerifier.FirstStep)this.tbAncRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
        this.tbRepo.deleteAll().block();
        ((StepVerifier.FirstStep)this.tbRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    protected void clearDomains() {
        this.dmRepo.deleteAll().block();
        ((StepVerifier.FirstStep)this.dmRepo.findAll().as(StepVerifier::create)).expectNextCount(0L).verifyComplete();
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

