/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.springframework.dao.DataIntegrityViolationException;
import reactor.test.StepVerifier;

public class TrustBundleRepository_addTrustBundleTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testAddTrustBundle_addBundle_noAnchors_assertAdded() {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.tbRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        Assertions.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assertions.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assertions.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assertions.assertEquals((int)5, (int)addedBundle.getRefreshInterval());
        Assertions.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assertions.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assertions.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assertions.assertEquals((int)0, (int)addedBundle.getLastRefreshError());
        Assertions.assertNull((Object)addedBundle.getSigningCertificateData());
    }

    @Test
    public void testAddTrustBundle_addBundle_withAnchors_assertAdded() throws Exception {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.tbRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)bundles.size());
        TrustBundle addedBundle = (TrustBundle)bundles.iterator().next();
        TrustBundleAnchor anchor = new TrustBundleAnchor();
        anchor.setData(TrustBundleRepository_addTrustBundleTest.loadCertificateData("secureHealthEmailCACert.der"));
        anchor.setTrustBundleId(addedBundle.getId());
        ((StepVerifier.FirstStep)this.tbAncRepo.save((Object)anchor).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Assertions.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assertions.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assertions.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assertions.assertEquals((int)5, (int)addedBundle.getRefreshInterval());
        Assertions.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assertions.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assertions.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assertions.assertEquals((int)0, (int)addedBundle.getLastRefreshError());
        Assertions.assertNull((Object)addedBundle.getSigningCertificateData());
        List addedAnchors = (List)this.tbAncRepo.findByTrustBundleId(addedBundle.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)addedAnchors.size());
        TrustBundleAnchor addedAnchor = (TrustBundleAnchor)addedAnchors.get(0);
        Assertions.assertNotNull((Object)addedAnchor.toCertificate());
        Assertions.assertEquals((Object)anchor.toCertificate(), (Object)addedAnchor.toCertificate());
        Assertions.assertEquals((Object)Thumbprint.toThumbprint((X509Certificate)anchor.toCertificate()).toString(), (Object)addedAnchor.getThumbprint());
        Assertions.assertEquals((long)anchor.toCertificate().getNotAfter().getTime(), (long)Timestamp.valueOf(addedAnchor.getValidEndDate()).getTime());
        Assertions.assertEquals((long)anchor.toCertificate().getNotBefore().getTime(), (long)Timestamp.valueOf(addedAnchor.getValidStartDate()).getTime());
        Assertions.assertEquals((Long)anchor.getTrustBundleId(), (Long)addedBundle.getId());
    }

    @Test
    public void testAddTrustBundle_addExistingBundle_assertException() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List bundles = (List)this.tbRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)bundles.size());
        boolean exceptionOccured = false;
        try {
            bundle = new TrustBundle();
            bundle.setBundleName("Test Bundle");
            bundle.setBundleURL("http://testBundle/bundle.p7b");
            bundle.setRefreshInterval(5);
            bundle.setCheckSum("12345");
            bundle.setCreateTime(LocalDateTime.now());
            this.tbRepo.save((Object)bundle).block();
        }
        catch (DataIntegrityViolationException ex) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        bundles = (List)this.tbRepo.findAll().collectList().block();
        Assertions.assertEquals((int)1, (int)bundles.size());
    }
}

