/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.springframework.dao.DataIntegrityViolationException;
import reactor.test.StepVerifier;

public class TrustBundleRepository_associateTrustBundleToDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testAssociateTrustBundleToDomain_associateDomainAndBundle_assertAssociationAdded() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain.getId());
        reltn.setTrustBundleId(bundle.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(false);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        List bundleReltn = (List)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)bundleReltn.size());
        reltn = (TrustBundleDomainReltn)bundleReltn.get(0);
        Assertions.assertTrue((boolean)reltn.isIncoming());
        Assertions.assertFalse((boolean)reltn.isOutgoing());
    }

    @Test
    public void testAssociateTrustBundleToDomain_unknownDomain_assertException() {
        Assertions.assertThrows(DataIntegrityViolationException.class, () -> {
            Domain domain = new Domain();
            domain.setDomainName("Test Domain");
            domain.setId(Long.valueOf(12345L));
            TrustBundle bundle = new TrustBundle();
            bundle.setBundleName("Test Bundle");
            bundle.setBundleURL("http://test/url/bundle");
            bundle.setCheckSum("1234");
            ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
            TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
            reltn.setDomainId(domain.getId());
            reltn.setTrustBundleId(bundle.getId());
            reltn.setIncoming(true);
            reltn.setOutgoing(false);
            this.reltnRepo.save((Object)reltn).block();
        });
    }

    @Test
    public void testAssociateTrustBundleToDomain_unknownTrustBundle_assertException() {
        Assertions.assertThrows(DataIntegrityViolationException.class, () -> {
            Domain domain = new Domain();
            domain.setDomainName("Test Domain");
            ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
            TrustBundle bundle = new TrustBundle();
            bundle.setBundleName("Test Bundle");
            bundle.setBundleURL("http://test/url/bundle");
            bundle.setCheckSum("1234");
            bundle.setId(Long.valueOf(12345L));
            TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
            reltn.setDomainId(domain.getId());
            reltn.setTrustBundleId(bundle.getId());
            reltn.setIncoming(true);
            reltn.setOutgoing(false);
            this.reltnRepo.save((Object)reltn).block();
        });
    }
}

