/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import reactor.test.StepVerifier;

public class TrustBundleRepository_disassociateTrustBundlesFromDomainTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testDisassociateTrustBundlesFromDomain_associateDomainAndBundle_assertAssociationRemoved() {
        Domain domain = new Domain();
        domain.setDomainName("Test Domain");
        ((StepVerifier.FirstStep)this.dmRepo.save((Object)domain).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://test/url/bundle");
        bundle.setCheckSum("1234");
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
        reltn.setDomainId(domain.getId());
        reltn.setTrustBundleId(bundle.getId());
        reltn.setIncoming(true);
        reltn.setOutgoing(true);
        ((StepVerifier.FirstStep)this.reltnRepo.save((Object)reltn).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Collection bundles = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assertions.assertEquals((int)1, (int)bundles.size());
        this.reltnRepo.deleteByDomainId(domain.getId()).block();
        bundles = (Collection)this.reltnRepo.findByDomainId(domain.getId()).collectList().block();
        Assertions.assertEquals((int)0, (int)bundles.size());
    }
}

