/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.repository;

import java.time.LocalDateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.repository.TrustBundleDaoBaseTest;
import org.nhindirect.config.store.TrustBundle;
import reactor.test.StepVerifier;

public class TrustBundleRepository_getTrustBundleByIdTest
extends TrustBundleDaoBaseTest {
    @Test
    public void testTetTrustBundleById_emptyStore_assertNoBundleReturned() {
        Assertions.assertEquals(null, (Object)this.tbRepo.findById((Object)1234L).block());
    }

    @Test
    public void testTetTrustBundleById_singleBundleInStore_idNotInStore_assertNoBundleReturned() {
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setRefreshInterval(5);
        bundle.setCheckSum("12345");
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        Assertions.assertEquals(null, (Object)this.tbRepo.findById((Object)1234L).block());
    }

    @Test
    public void testTetTrustBundleById_singleBundleInStore_assertBundleReturned() {
        LocalDateTime now = LocalDateTime.now();
        TrustBundle bundle = new TrustBundle();
        bundle.setBundleName("Test Bundle");
        bundle.setBundleURL("http://testBundle/bundle.p7b");
        bundle.setCheckSum("12345");
        bundle.setRefreshInterval(5);
        bundle.setCreateTime(LocalDateTime.now());
        ((StepVerifier.FirstStep)this.tbRepo.save((Object)bundle).as(StepVerifier::create)).expectNextCount(1L).verifyComplete();
        TrustBundle addedBundle = (TrustBundle)this.tbRepo.findById((Object)bundle.getId()).block();
        Assertions.assertEquals((Object)"Test Bundle", (Object)addedBundle.getBundleName());
        Assertions.assertEquals((Object)"http://testBundle/bundle.p7b", (Object)addedBundle.getBundleURL());
        Assertions.assertEquals((Object)"12345", (Object)addedBundle.getCheckSum());
        Assertions.assertEquals((int)5, (int)addedBundle.getRefreshInterval());
        Assertions.assertTrue((now.compareTo(addedBundle.getCreateTime()) <= 0 ? 1 : 0) != 0);
        Assertions.assertNull((Object)addedBundle.getLastRefreshAttempt());
        Assertions.assertNull((Object)addedBundle.getLastSuccessfulRefresh());
        Assertions.assertEquals((int)0, (int)addedBundle.getLastRefreshError());
        Assertions.assertNull((Object)addedBundle.getSigningCertificateData());
    }
}

