/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateException;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table
public class Anchor {
    private String owner;
    private String thumbprint;
    @Column(value="certificateId")
    private long certificateId;
    @Column(value="certificateData")
    private byte[] certificateData;
    @Id
    private Long id;
    @Column(value="createTime")
    private LocalDateTime createTime;
    @Column(value="validStartDate")
    private LocalDateTime validStartDate;
    @Column(value="validEndDate")
    private LocalDateTime validEndDate;
    private int status;
    @Column(value="forIncoming")
    private boolean incoming;
    @Column(value="forOutgoing")
    private boolean outgoing;

    public void setCertificateData(byte[] data) throws CertificateException {
        this.setData(data);
    }

    public void setData(byte[] data) throws CertificateException {
        this.certificateData = data;
        if (data == Certificate.NULL_CERT) {
            this.setThumbprint("");
        } else {
            this.loadCertFromData();
        }
    }

    private X509Certificate loadCertFromData() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.certificateData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            this.setThumbprint(Thumbprint.toThumbprint((X509Certificate)cert).toString());
            bais.close();
        }
        catch (Exception e) {
            this.setData(Certificate.NULL_CERT);
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    public X509Certificate toCertificate() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.certificateData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    private boolean hasData() {
        return this.certificateData != null && !this.certificateData.equals(Certificate.NULL_CERT);
    }

    public void validate() throws CertificateException {
        if (!this.hasData()) {
            throw new CertificateException("Invalid Certificate: no certificate data exists");
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public long getCertificateId() {
        return this.certificateId;
    }

    public byte[] getCertificateData() {
        return this.certificateData;
    }

    public Long getId() {
        return this.id;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDateTime getValidStartDate() {
        return this.validStartDate;
    }

    public LocalDateTime getValidEndDate() {
        return this.validEndDate;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    public void setCertificateId(long certificateId) {
        this.certificateId = certificateId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setValidStartDate(LocalDateTime validStartDate) {
        this.validStartDate = validStartDate;
    }

    public void setValidEndDate(LocalDateTime validEndDate) {
        this.validEndDate = validEndDate;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setIncoming(boolean incoming) {
        this.incoming = incoming;
    }

    public void setOutgoing(boolean outgoing) {
        this.outgoing = outgoing;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Anchor)) {
            return false;
        }
        Anchor other = (Anchor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCertificateId() != other.getCertificateId()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        if (this.isIncoming() != other.isIncoming()) {
            return false;
        }
        if (this.isOutgoing() != other.isOutgoing()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$thumbprint = this.getThumbprint();
        String other$thumbprint = other.getThumbprint();
        if (this$thumbprint == null ? other$thumbprint != null : !this$thumbprint.equals(other$thumbprint)) {
            return false;
        }
        if (!Arrays.equals(this.getCertificateData(), other.getCertificateData())) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDateTime this$validStartDate = this.getValidStartDate();
        LocalDateTime other$validStartDate = other.getValidStartDate();
        if (this$validStartDate == null ? other$validStartDate != null : !((Object)this$validStartDate).equals(other$validStartDate)) {
            return false;
        }
        LocalDateTime this$validEndDate = this.getValidEndDate();
        LocalDateTime other$validEndDate = other.getValidEndDate();
        return !(this$validEndDate == null ? other$validEndDate != null : !((Object)this$validEndDate).equals(other$validEndDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Anchor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $certificateId = this.getCertificateId();
        result = result * 59 + (int)($certificateId >>> 32 ^ $certificateId);
        result = result * 59 + this.getStatus();
        result = result * 59 + (this.isIncoming() ? 79 : 97);
        result = result * 59 + (this.isOutgoing() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $thumbprint = this.getThumbprint();
        result = result * 59 + ($thumbprint == null ? 43 : $thumbprint.hashCode());
        result = result * 59 + Arrays.hashCode(this.getCertificateData());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDateTime $validStartDate = this.getValidStartDate();
        result = result * 59 + ($validStartDate == null ? 43 : ((Object)$validStartDate).hashCode());
        LocalDateTime $validEndDate = this.getValidEndDate();
        result = result * 59 + ($validEndDate == null ? 43 : ((Object)$validEndDate).hashCode());
        return result;
    }

    public String toString() {
        return "Anchor(owner=" + this.getOwner() + ", thumbprint=" + this.getThumbprint() + ", certificateId=" + this.getCertificateId() + ", certificateData=" + Arrays.toString(this.getCertificateData()) + ", id=" + this.getId() + ", createTime=" + this.getCreateTime() + ", validStartDate=" + this.getValidStartDate() + ", validEndDate=" + this.getValidEndDate() + ", status=" + this.getStatus() + ", incoming=" + this.isIncoming() + ", outgoing=" + this.isOutgoing() + ")";
    }
}

