/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Enumeration;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.CertificateException;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table
public class Certificate {
    public static final byte[] NULL_CERT;
    private String owner;
    private String thumbprint;
    @Id
    private Long id;
    @Column(value="certificateData")
    private byte[] data;
    @Column(value="createTime")
    private LocalDateTime createTime = LocalDateTime.now();
    @Column(value="validStartDate")
    private LocalDateTime validStartDate;
    @Column(value="validEndDate")
    private LocalDateTime validEndDate;
    private int status;
    @Column(value="privateKey")
    private boolean privateKey;

    public void setData(byte[] data) throws CertificateException {
        this.data = data;
        if (data == NULL_CERT) {
            this.setThumbprint("");
        } else {
            this.loadCertFromEmptyProtectedData();
        }
    }

    public void setRawData(byte[] data) {
        this.data = data;
    }

    public void validate() throws CertificateException {
        if (!this.hasData()) {
            throw new CertificateException("Invalid Certificate: no certificate data exists");
        }
    }

    private boolean hasData() {
        return this.data != null && !this.data.equals(NULL_CERT);
    }

    public void clearData() {
        try {
            this.setData(NULL_CERT);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
    }

    private void loadCertFromEmptyProtectedData() throws CertificateException {
        this.loadCertFromData("".toCharArray(), "".toCharArray());
    }

    private void loadCertFromData(char[] keyStorePassPhrase, char[] privateKeyPassPhrase) throws CertificateException {
        block7: {
            X509Certificate cert = null;
            CertUtils.CertContainer container = null;
            try {
                this.validate();
                try {
                    container = CertUtils.toCertContainer((byte[])this.data, (char[])keyStorePassPhrase, (char[])keyStorePassPhrase);
                    cert = container.getCert();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cert == null) {
                    try {
                        URL uRL = new URL(new String(this.data, "ASCII"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setThumbprint("");
                    break block7;
                }
                this.setThumbprint(Thumbprint.toThumbprint(cert).toString());
                this.setPrivateKey(container != null && (container.getKey() != null || container.getWrappedKeyData() != null));
            }
            catch (Exception e) {
                this.setData(NULL_CERT);
                throw new CertificateException("Data cannot be converted to a valid X.509 Certificate or IPKIX URL", e);
            }
        }
    }

    public CertContainer toCredential() throws CertificateException {
        return this.toCredential("".toCharArray(), "".toCharArray());
    }

    public CertContainer toCredential(char[] keyStorePass, char[] privateKeyPass) throws CertificateException {
        CertContainer certContainer = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CryptoExtensions.getJCEProviderName());
                localKeyStore.load(bais, keyStorePass);
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, privateKeyPass);
                    if (key != null && key instanceof PrivateKey) {
                        certContainer = new CertContainer(cert, key);
                    }
                }
            }
            catch (Exception localKeyStore) {
                // empty catch block
            }
            if (certContainer == null) {
                bais.reset();
                bais = new ByteArrayInputStream(this.data);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, null);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return certContainer;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public Long getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDateTime getValidStartDate() {
        return this.validStartDate;
    }

    public LocalDateTime getValidEndDate() {
        return this.validEndDate;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPrivateKey() {
        return this.privateKey;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setValidStartDate(LocalDateTime validStartDate) {
        this.validStartDate = validStartDate;
    }

    public void setValidEndDate(LocalDateTime validEndDate) {
        this.validEndDate = validEndDate;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setPrivateKey(boolean privateKey) {
        this.privateKey = privateKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        if (this.isPrivateKey() != other.isPrivateKey()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$thumbprint = this.getThumbprint();
        String other$thumbprint = other.getThumbprint();
        if (this$thumbprint == null ? other$thumbprint != null : !this$thumbprint.equals(other$thumbprint)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDateTime this$validStartDate = this.getValidStartDate();
        LocalDateTime other$validStartDate = other.getValidStartDate();
        if (this$validStartDate == null ? other$validStartDate != null : !((Object)this$validStartDate).equals(other$validStartDate)) {
            return false;
        }
        LocalDateTime this$validEndDate = this.getValidEndDate();
        LocalDateTime other$validEndDate = other.getValidEndDate();
        return !(this$validEndDate == null ? other$validEndDate != null : !((Object)this$validEndDate).equals(other$validEndDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Certificate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        result = result * 59 + (this.isPrivateKey() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $thumbprint = this.getThumbprint();
        result = result * 59 + ($thumbprint == null ? 43 : $thumbprint.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDateTime $validStartDate = this.getValidStartDate();
        result = result * 59 + ($validStartDate == null ? 43 : ((Object)$validStartDate).hashCode());
        LocalDateTime $validEndDate = this.getValidEndDate();
        result = result * 59 + ($validEndDate == null ? 43 : ((Object)$validEndDate).hashCode());
        return result;
    }

    public String toString() {
        return "Certificate(owner=" + this.getOwner() + ", thumbprint=" + this.getThumbprint() + ", id=" + this.getId() + ", data=" + Arrays.toString(this.getData()) + ", createTime=" + this.getCreateTime() + ", validStartDate=" + this.getValidStartDate() + ", validEndDate=" + this.getValidEndDate() + ", status=" + this.getStatus() + ", privateKey=" + this.isPrivateKey() + ")";
    }

    static {
        CryptoExtensions.registerJCEProviders();
        NULL_CERT = new byte[0];
    }

    public static class CertContainer {
        private final X509Certificate cert;
        private final Key key;

        public CertContainer(X509Certificate cert, Key key) {
            this.cert = cert;
            this.key = key;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public Key getKey() {
            return this.key;
        }
    }
}

