/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.nhindirect.config.store.util.DNSRecordUtils;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table(value="dnsrecord")
public class DNSRecord {
    @Id
    private Long id;
    private String name;
    private int type;
    private int dclass;
    private long ttl;
    private byte[] data;
    @Column(value="createTime")
    private LocalDateTime createTime = LocalDateTime.now();

    public static DNSRecord fromWire(byte[] data) throws IOException {
        return DNSRecordUtils.fromWire(data);
    }

    public static byte[] toWire(DNSRecord rec) throws IOException {
        return DNSRecordUtils.toWire(rec);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getDclass() {
        return this.dclass;
    }

    public long getTtl() {
        return this.ttl;
    }

    public byte[] getData() {
        return this.data;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setDclass(int dclass) {
        this.dclass = dclass;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DNSRecord)) {
            return false;
        }
        DNSRecord other = (DNSRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getDclass() != other.getDclass()) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DNSRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        result = result * 59 + this.getDclass();
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "DNSRecord(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", dclass=" + this.getDclass() + ", ttl=" + this.getTtl() + ", data=" + Arrays.toString(this.getData()) + ", createTime=" + this.getCreateTime() + ")";
    }
}

