/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.time.LocalDateTime;
import org.nhindirect.config.store.EntityStatus;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table
public class Domain {
    public static long MAGIC_POSTMASTER_ID = -2L;
    @Column(value="domainName")
    private String domainName;
    @Column(value="createTime")
    private LocalDateTime createTime = LocalDateTime.now();
    @Column(value="updateTime")
    private LocalDateTime updateTime = LocalDateTime.now();
    @Column(value="postmasterAddressId")
    private Long postmasterAddressId;
    @Id
    private Long id;
    private int status = EntityStatus.NEW.ordinal();

    public boolean isValid() {
        boolean result = false;
        if (this.getDomainName() != null && this.getDomainName().length() > 0 && this.getStatus() == EntityStatus.ENABLED.ordinal() || this.getStatus() == EntityStatus.DISABLED.ordinal() || this.getStatus() == EntityStatus.NEW.ordinal() && this.getId() == 0L) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return "[ID: " + this.getId() + " | Domain: " + this.getDomainName() + " | Status: " + EntityStatus.values()[this.getStatus()].toString() + "]";
    }

    public String getDomainName() {
        return this.domainName;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public Long getPostmasterAddressId() {
        return this.postmasterAddressId;
    }

    public Long getId() {
        return this.id;
    }

    public int getStatus() {
        return this.status;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public void setPostmasterAddressId(Long postmasterAddressId) {
        this.postmasterAddressId = postmasterAddressId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Domain)) {
            return false;
        }
        Domain other = (Domain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        Long this$postmasterAddressId = this.getPostmasterAddressId();
        Long other$postmasterAddressId = other.getPostmasterAddressId();
        if (this$postmasterAddressId == null ? other$postmasterAddressId != null : !((Object)this$postmasterAddressId).equals(other$postmasterAddressId)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$domainName = this.getDomainName();
        String other$domainName = other.getDomainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        LocalDateTime this$updateTime = this.getUpdateTime();
        LocalDateTime other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Domain;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        Long $postmasterAddressId = this.getPostmasterAddressId();
        result = result * 59 + ($postmasterAddressId == null ? 43 : ((Object)$postmasterAddressId).hashCode());
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $domainName = this.getDomainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        LocalDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }
}

