/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateException;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table(value="trustbundle")
public class TrustBundle {
    @Id
    private Long id;
    @Column(value="bundleName")
    private String bundleName;
    @Column(value="bundleURL")
    private String bundleURL;
    @Column(value="signingCertificateData")
    private byte[] signingCertificateData;
    @Column(value="refreshInterval")
    private int refreshInterval = 0;
    @Column(value="lastRefreshAttempt")
    private LocalDateTime lastRefreshAttempt;
    @Column(value="lastRefreshError")
    private int lastRefreshError;
    @Column(value="lastSuccessfulRefresh")
    private LocalDateTime lastSuccessfulRefresh;
    @Column(value="createTime")
    private LocalDateTime createTime = LocalDateTime.now();
    @Column(value="getCheckSum")
    private String checkSum = "";

    public X509Certificate toSigningCertificate() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.signingCertificateData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    public void validate() throws CertificateException {
        if (!this.hasData()) {
            throw new CertificateException("Invalid Certificate: no certificate data exists");
        }
    }

    private boolean hasData() {
        return this.signingCertificateData != null && !this.signingCertificateData.equals(Certificate.NULL_CERT);
    }

    public Long getId() {
        return this.id;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getBundleURL() {
        return this.bundleURL;
    }

    public byte[] getSigningCertificateData() {
        return this.signingCertificateData;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public LocalDateTime getLastRefreshAttempt() {
        return this.lastRefreshAttempt;
    }

    public int getLastRefreshError() {
        return this.lastRefreshError;
    }

    public LocalDateTime getLastSuccessfulRefresh() {
        return this.lastSuccessfulRefresh;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setBundleURL(String bundleURL) {
        this.bundleURL = bundleURL;
    }

    public void setSigningCertificateData(byte[] signingCertificateData) {
        this.signingCertificateData = signingCertificateData;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void setLastRefreshAttempt(LocalDateTime lastRefreshAttempt) {
        this.lastRefreshAttempt = lastRefreshAttempt;
    }

    public void setLastRefreshError(int lastRefreshError) {
        this.lastRefreshError = lastRefreshError;
    }

    public void setLastSuccessfulRefresh(LocalDateTime lastSuccessfulRefresh) {
        this.lastSuccessfulRefresh = lastSuccessfulRefresh;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setCheckSum(String checkSum) {
        this.checkSum = checkSum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustBundle)) {
            return false;
        }
        TrustBundle other = (TrustBundle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRefreshInterval() != other.getRefreshInterval()) {
            return false;
        }
        if (this.getLastRefreshError() != other.getLastRefreshError()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$bundleName = this.getBundleName();
        String other$bundleName = other.getBundleName();
        if (this$bundleName == null ? other$bundleName != null : !this$bundleName.equals(other$bundleName)) {
            return false;
        }
        String this$bundleURL = this.getBundleURL();
        String other$bundleURL = other.getBundleURL();
        if (this$bundleURL == null ? other$bundleURL != null : !this$bundleURL.equals(other$bundleURL)) {
            return false;
        }
        if (!Arrays.equals(this.getSigningCertificateData(), other.getSigningCertificateData())) {
            return false;
        }
        LocalDateTime this$lastRefreshAttempt = this.getLastRefreshAttempt();
        LocalDateTime other$lastRefreshAttempt = other.getLastRefreshAttempt();
        if (this$lastRefreshAttempt == null ? other$lastRefreshAttempt != null : !((Object)this$lastRefreshAttempt).equals(other$lastRefreshAttempt)) {
            return false;
        }
        LocalDateTime this$lastSuccessfulRefresh = this.getLastSuccessfulRefresh();
        LocalDateTime other$lastSuccessfulRefresh = other.getLastSuccessfulRefresh();
        if (this$lastSuccessfulRefresh == null ? other$lastSuccessfulRefresh != null : !((Object)this$lastSuccessfulRefresh).equals(other$lastSuccessfulRefresh)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$checkSum = this.getCheckSum();
        String other$checkSum = other.getCheckSum();
        return !(this$checkSum == null ? other$checkSum != null : !this$checkSum.equals(other$checkSum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrustBundle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRefreshInterval();
        result = result * 59 + this.getLastRefreshError();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $bundleName = this.getBundleName();
        result = result * 59 + ($bundleName == null ? 43 : $bundleName.hashCode());
        String $bundleURL = this.getBundleURL();
        result = result * 59 + ($bundleURL == null ? 43 : $bundleURL.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSigningCertificateData());
        LocalDateTime $lastRefreshAttempt = this.getLastRefreshAttempt();
        result = result * 59 + ($lastRefreshAttempt == null ? 43 : ((Object)$lastRefreshAttempt).hashCode());
        LocalDateTime $lastSuccessfulRefresh = this.getLastSuccessfulRefresh();
        result = result * 59 + ($lastSuccessfulRefresh == null ? 43 : ((Object)$lastSuccessfulRefresh).hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $checkSum = this.getCheckSum();
        result = result * 59 + ($checkSum == null ? 43 : $checkSum.hashCode());
        return result;
    }

    public String toString() {
        return "TrustBundle(id=" + this.getId() + ", bundleName=" + this.getBundleName() + ", bundleURL=" + this.getBundleURL() + ", signingCertificateData=" + Arrays.toString(this.getSigningCertificateData()) + ", refreshInterval=" + this.getRefreshInterval() + ", lastRefreshAttempt=" + this.getLastRefreshAttempt() + ", lastRefreshError=" + this.getLastRefreshError() + ", lastSuccessfulRefresh=" + this.getLastSuccessfulRefresh() + ", createTime=" + this.getCreateTime() + ", checkSum=" + this.getCheckSum() + ")";
    }
}

