/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateException;
import org.springframework.data.annotation.Id;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table(value="trustbundleanchor")
public class TrustBundleAnchor {
    @Id
    private Long id;
    @Column(value="trustBundleId")
    private Long trustBundleId;
    @Column(value="anchorData")
    private byte[] anchorData;
    private String thumbprint;
    @Column(value="validStartDate")
    private LocalDateTime validStartDate;
    @Column(value="validEndDate")
    private LocalDateTime validEndDate;

    public void setAnchorData(byte[] data) throws CertificateException {
        this.setData(data);
    }

    public void setData(byte[] data) throws CertificateException {
        this.anchorData = data;
        if (data == Certificate.NULL_CERT) {
            this.setThumbprint("");
        } else {
            this.loadCertFromData();
        }
    }

    private X509Certificate loadCertFromData() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.anchorData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            this.setThumbprint(Thumbprint.toThumbprint((X509Certificate)cert).toString());
            LocalDateTime calEndTime = new Timestamp(cert.getNotAfter().getTime()).toLocalDateTime();
            LocalDateTime calStartTime = new Timestamp(cert.getNotBefore().getTime()).toLocalDateTime();
            this.setValidEndDate(calEndTime);
            this.setValidStartDate(calStartTime);
            bais.close();
        }
        catch (Exception e) {
            this.setData(Certificate.NULL_CERT);
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    public X509Certificate toCertificate() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.anchorData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    private boolean hasData() {
        return this.anchorData != null && !this.anchorData.equals(Certificate.NULL_CERT);
    }

    public void validate() throws CertificateException {
        if (!this.hasData()) {
            throw new CertificateException("Invalid Certificate: no certificate data exists");
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getTrustBundleId() {
        return this.trustBundleId;
    }

    public byte[] getAnchorData() {
        return this.anchorData;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public LocalDateTime getValidStartDate() {
        return this.validStartDate;
    }

    public LocalDateTime getValidEndDate() {
        return this.validEndDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTrustBundleId(Long trustBundleId) {
        this.trustBundleId = trustBundleId;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    public void setValidStartDate(LocalDateTime validStartDate) {
        this.validStartDate = validStartDate;
    }

    public void setValidEndDate(LocalDateTime validEndDate) {
        this.validEndDate = validEndDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustBundleAnchor)) {
            return false;
        }
        TrustBundleAnchor other = (TrustBundleAnchor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$trustBundleId = this.getTrustBundleId();
        Long other$trustBundleId = other.getTrustBundleId();
        if (this$trustBundleId == null ? other$trustBundleId != null : !((Object)this$trustBundleId).equals(other$trustBundleId)) {
            return false;
        }
        if (!Arrays.equals(this.getAnchorData(), other.getAnchorData())) {
            return false;
        }
        String this$thumbprint = this.getThumbprint();
        String other$thumbprint = other.getThumbprint();
        if (this$thumbprint == null ? other$thumbprint != null : !this$thumbprint.equals(other$thumbprint)) {
            return false;
        }
        LocalDateTime this$validStartDate = this.getValidStartDate();
        LocalDateTime other$validStartDate = other.getValidStartDate();
        if (this$validStartDate == null ? other$validStartDate != null : !((Object)this$validStartDate).equals(other$validStartDate)) {
            return false;
        }
        LocalDateTime this$validEndDate = this.getValidEndDate();
        LocalDateTime other$validEndDate = other.getValidEndDate();
        return !(this$validEndDate == null ? other$validEndDate != null : !((Object)this$validEndDate).equals(other$validEndDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrustBundleAnchor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $trustBundleId = this.getTrustBundleId();
        result = result * 59 + ($trustBundleId == null ? 43 : ((Object)$trustBundleId).hashCode());
        result = result * 59 + Arrays.hashCode(this.getAnchorData());
        String $thumbprint = this.getThumbprint();
        result = result * 59 + ($thumbprint == null ? 43 : $thumbprint.hashCode());
        LocalDateTime $validStartDate = this.getValidStartDate();
        result = result * 59 + ($validStartDate == null ? 43 : ((Object)$validStartDate).hashCode());
        LocalDateTime $validEndDate = this.getValidEndDate();
        result = result * 59 + ($validEndDate == null ? 43 : ((Object)$validEndDate).hashCode());
        return result;
    }

    public String toString() {
        return "TrustBundleAnchor(id=" + this.getId() + ", trustBundleId=" + this.getTrustBundleId() + ", anchorData=" + Arrays.toString(this.getAnchorData()) + ", thumbprint=" + this.getThumbprint() + ", validStartDate=" + this.getValidStartDate() + ", validEndDate=" + this.getValidEndDate() + ")";
    }
}

