/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.util;

import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.EntityStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateUtils {
    private static final Logger log = LoggerFactory.getLogger(CertificateUtils.class);

    public static Certificate stripP12Protection(Certificate cert, KeyStoreProtectionManager kspMgr) {
        log.debug("Attempting to strip p12 protection for certificate with id {}", (Object)cert.getId());
        if (cert.isPrivateKey() && kspMgr != null) {
            log.debug("isPrivateKey = true ");
            char[] emptyProtection = "".toCharArray();
            try {
                log.debug("Attempting to convert to a container that is wrapped");
                if (CertUtils.toCertContainer((byte[])cert.getData()) != null) {
                    return cert;
                }
            }
            catch (CertificateConversionException e) {
                log.trace("CertificateConversionException error when converting wrapped data.", (Throwable)e);
            }
            catch (Throwable t) {
                log.debug("Throwable error when converting wrapped data.", t);
            }
            log.debug("Appears to not be wrapped.  Attempting to convert by changing p12 protection.");
            try {
                String oldKeystorePassPhrase = new String(kspMgr.getKeyStoreProtectionKey().getEncoded());
                String oldPrivateKeyPassPhrase = new String(kspMgr.getKeyStoreProtectionKey().getEncoded());
                byte[] data = CertUtils.changePkcs12Protection((byte[])cert.getData(), (char[])oldKeystorePassPhrase.toCharArray(), (char[])oldPrivateKeyPassPhrase.toCharArray(), (char[])emptyProtection, (char[])emptyProtection);
                cert.setData(data);
            }
            catch (Exception e) {
                throw new RuntimeException("Error stripping P12 protection data", e);
            }
        }
        return cert;
    }

    public static Certificate applyCertRepositoryAttributes(Certificate cert, KeyStoreProtectionManager kspMgr) {
        CertUtils.CertContainer container = null;
        X509Certificate xcert = null;
        try {
            container = CertUtils.toCertContainer((byte[])cert.getData());
            xcert = container.getCert();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cert.getValidStartDate() == null && xcert != null) {
            LocalDateTime startDate = new Timestamp(xcert.getNotBefore().getTime()).toLocalDateTime();
            cert.setValidStartDate(startDate);
        }
        if (cert.getValidEndDate() == null && xcert != null) {
            LocalDateTime endDate = new Timestamp(xcert.getNotAfter().getTime()).toLocalDateTime();
            cert.setValidEndDate(endDate);
        }
        if (cert.getStatus() < 0) {
            cert.setStatus(EntityStatus.NEW.ordinal());
        }
        cert.setPrivateKey(container != null && (container.getKey() != null || container.getWrappedKeyData() != null));
        if (cert.isPrivateKey() && kspMgr != null && container.getKey() != null) {
            try {
                String newKeystorePassPhrase = new String(kspMgr.getKeyStoreProtectionKey().getEncoded());
                String newPrivateKeyPassPhrase = new String(kspMgr.getPrivateKeyProtectionKey().getEncoded());
                cert.setRawData(CertUtils.changePkcs12Protection((byte[])cert.getData(), (char[])"".toCharArray(), (char[])"".toCharArray(), (char[])newKeystorePassPhrase.toCharArray(), (char[])newPrivateKeyPassPhrase.toCharArray()));
            }
            catch (Exception e) {
                throw new RuntimeException("Error converting P12 to encrypted/protected format", e);
            }
        }
        return cert;
    }
}

