/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.CertificateService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.DomainService;
import org.nhindirect.config.service.SettingService;
import org.nhindirect.config.service.impl.CertificateGetOptions;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.ui.flash.FlashMap;
import org.nhindirect.config.ui.form.AddressForm;
import org.nhindirect.config.ui.form.AnchorForm;
import org.nhindirect.config.ui.form.CertificateForm;
import org.nhindirect.config.ui.form.DomainForm;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SettingsForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/main"})
public class MainController {
    private final Log log = LogFactory.getLog(this.getClass());
    @Inject
    private DomainService dService;
    @Inject
    private SettingService settingsService;
    @Inject
    private CertificateService certificatesService;

    public MainController() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"MainController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public ModelAndView search(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute SimpleForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter search");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter search");
        }
        String message = "Search complete";
        ModelAndView mav = new ModelAndView();
        if (actionPath.equalsIgnoreCase("gotosettings")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to go to the settings page");
            }
            String action = "add";
            model.addAttribute("action", (Object)action);
            mav.setViewName("settings");
            mav.addObject("actionPath", (Object)actionPath);
            SettingsForm form = (SettingsForm)session.getAttribute("settingsForm");
            if (form == null) {
                form = new SettingsForm();
            }
            model.addAttribute("settingsForm", (Object)form);
            ArrayList results = null;
            if (this.settingsService != null) {
                try {
                    results = new ArrayList(this.settingsService.getAllSettings());
                }
                catch (ConfigurationServiceException e) {
                    e.printStackTrace();
                }
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            model.addAttribute("settingsResults", results);
            return mav;
        }
        if (actionPath.equalsIgnoreCase("gotocertificates")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to go to the certificates page");
            }
            String action = "Update";
            model.addAttribute("action", (Object)action);
            mav.setViewName("certificates");
            mav.addObject("actionPath", (Object)actionPath);
            CertificateForm form = (CertificateForm)session.getAttribute("certificateForm");
            if (form == null) {
                form = new CertificateForm();
            }
            model.addAttribute("certificateForm", (Object)form);
            ArrayList results = null;
            if (this.certificatesService != null) {
                try {
                    results = new ArrayList(this.certificatesService.listCertificates(1L, 1000, CertificateGetOptions.DEFAULT));
                }
                catch (ConfigurationServiceException e) {
                    e.printStackTrace();
                }
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            model.addAttribute("certificatesResults", results);
            return mav;
        }
        if (actionPath.equalsIgnoreCase("newdomain")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to go to the new domain page");
            }
            HashMap msgs = new HashMap();
            mav.addObject("msgs", msgs);
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            AddressForm addrform = new AddressForm();
            addrform.setId(Long.valueOf(0L));
            model.addAttribute("addressForm", (Object)addrform);
            CertificateForm cform = new CertificateForm();
            cform.setId(0L);
            AnchorForm aform = new AnchorForm();
            aform.setId(0L);
            model.addAttribute("certificateForm", (Object)cform);
            model.addAttribute("anchorForm", (Object)aform);
            String action = "Add";
            DomainForm form = (DomainForm)session.getAttribute("domainForm");
            if (form == null) {
                form = new DomainForm();
            }
            model.addAttribute("domainForm", (Object)form);
            model.addAttribute("action", (Object)action);
            mav.setViewName("domain");
            mav.addObject("actionPath", (Object)actionPath);
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
            return mav;
        }
        SearchDomainForm form = (SearchDomainForm)session.getAttribute("searchDomainForm");
        if (form == null) {
            form = new SearchDomainForm();
        }
        model.addAttribute((Object)form);
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        String domain = form.getDomainName();
        EntityStatus status = form.getStatus();
        ArrayList results = null;
        if (this.dService != null) {
            results = new ArrayList(this.dService.searchDomain(domain, status));
        }
        if (AjaxUtils.isAjaxRequest((String)requestedWith)) {
            model.addAttribute("message", (Object)new FlashMap.Message(FlashMap.MessageType.success, message));
            model.addAttribute("ajaxRequest", (Object)true);
            model.addAttribute("searchResults", results);
            return null;
        }
        mav.setViewName("main");
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        mav.addObject("searchResults", results);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    private String buildResponse(List<Domain> domains) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        StringBuffer result = new StringBuffer("{  \"Echo\":");
        result.append(domains.size()).append(",  \"iTotalRecords\": ").append(domains.size()).append(",  \"iTotalDisplayRecords\": ").append(domains.size()).append("  \"aaData\": [");
        boolean first = true;
        for (Domain domain : domains) {
            if (!first) {
                result.append(", ");
                first = false;
            }
            result.append("[").append(this.xformToJSON(String.valueOf(domain.getId()), false)).append(this.xformToJSON(domain.getDomainName(), false)).append(this.xformToJSON(String.valueOf(domain.getPostMasterEmail()), false)).append(this.xformToJSON(domain.getStatus().toString(), true)).append("] ");
        }
        result.append("] }");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Exit: " + result.toString()));
        }
        return result.toString();
    }

    private String xformToJSON(String item, boolean lastOne) {
        String result = "\"" + item + "\"";
        if (!lastOne) {
            result = result + ",";
        }
        return result;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView display(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, Model model) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        ModelAndView mav = new ModelAndView();
        SearchDomainForm form = (SearchDomainForm)session.getAttribute("searchDomainForm");
        model.addAttribute((Object)(form != null ? form : new SearchDomainForm()));
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.setViewName("main");
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public ModelAndView newDomain(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, Model model) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("domain");
        model.addAttribute((Object)new DomainForm());
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }

    public void setdService(DomainService service) {
        this.dService = service;
    }
}

