/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.SettingService;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SettingsForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/settings"})
public class SettingsController {
    private final Log log = LogFactory.getLog(this.getClass());
    @Inject
    private SettingService setService;

    public SettingsController() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ConfigurationController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addsetting"}, method={RequestMethod.POST})
    public ModelAndView addSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute SettingsForm settingsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav = new ModelAndView();
        String strid = "";
        String key = "";
        String value = "";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter domain/addsetting");
        }
        if (actionPath.equalsIgnoreCase("cancel")) {
            SearchDomainForm form2;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to cancel from saveupdate");
            }
            model.addAttribute((Object)((form2 = (SearchDomainForm)session.getAttribute("searchDomainForm")) != null ? form2 : new SearchDomainForm()));
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("main");
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
            return mav;
        }
        if (actionPath.equalsIgnoreCase("newsetting")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to get/set settings");
            }
            strid = "" + settingsForm.getId();
            key = "" + settingsForm.getKey();
            value = "" + settingsForm.getValue();
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"trying set settings services");
                }
                this.setService.addSetting(key, value);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"PAST trying set settings services");
                }
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            SimpleForm simple = new SimpleForm();
            simple.setId(Long.parseLong(strid));
            model.addAttribute("simpleForm", (Object)simple);
            try {
                model.addAttribute("settingsResults", (Object)this.setService.getAllSettings());
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
            mav.setViewName("settings");
            String action = "Update";
            model.addAttribute("settingsForm", (Object)settingsForm);
            model.addAttribute("action", (Object)action);
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removesettings"}, method={RequestMethod.POST})
    public ModelAndView removeAnchors(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute SimpleForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        String strid;
        ModelAndView mav;
        block9: {
            mav = new ModelAndView();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Enter domain/removesettings");
            }
            if (simpleForm.getRemove() != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("the list of checkboxes checked or not is: " + simpleForm.getRemove().toString()));
            }
            strid = "" + simpleForm.getId();
            if (this.setService != null && simpleForm != null && actionPath != null && actionPath.equalsIgnoreCase("delete") && simpleForm.getRemove() != null) {
                int cnt = simpleForm.getRemove().size();
                try {
                    List settingstoberemovedlist = simpleForm.getRemove();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" Trying to remove settings from database");
                    }
                    this.setService.deleteSetting((Collection)settingstoberemovedlist);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" SUCCESS Trying to remove settings");
                    }
                }
                catch (ConfigurationServiceException e) {
                    if (!this.log.isDebugEnabled()) break block9;
                    this.log.error((Object)e);
                }
            }
        }
        try {
            model.addAttribute("settingsResults", (Object)this.setService.getAllSettings());
        }
        catch (ConfigurationServiceException e) {
            e.printStackTrace();
        }
        mav.setViewName("settings");
        String action = "Update";
        model.addAttribute("settingsForm", (Object)new SettingsForm());
        model.addAttribute("action", (Object)action);
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        model.addAttribute("simpleForm", (Object)simpleForm);
        strid = "" + simpleForm.getId();
        return mav;
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }
}

