/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.inject.Inject;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.CertificateEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.ConfigurationService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.impl.CertificateGetOptions;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.DNSRecord;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.util.DNSRecordUtils;
import org.nhindirect.config.ui.DNSController;
import org.nhindirect.config.ui.SrvRecord;
import org.nhindirect.config.ui.form.CertificateForm;
import org.nhindirect.config.ui.form.DNSEntryForm;
import org.nhindirect.config.ui.form.DNSType;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SettingsForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/dns"})
public class DNSController {
    private final Log log = LogFactory.getLog(this.getClass());
    private ConfigurationService configSvc;

    @Inject
    public void setConfigurationService(ConfigurationService service) {
        this.configSvc = service;
    }

    public DNSController() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ConfigurationController initialized");
        }
    }

    private Collection<DNSEntryForm> convertDNSRecords(Collection<DNSRecord> entries) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        ArrayList<DNSEntryForm> forms = new ArrayList<DNSEntryForm>();
        if (entries != null) {
            Iterator<DNSRecord> iter = entries.iterator();
            while (iter.hasNext()) {
                DNSEntryForm form = new DNSEntryForm(iter.next());
                forms.add(form);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return forms;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/navigate"}, method={RequestMethod.GET})
    public ModelAndView navigate(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute DNSEntryForm entryForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Enter: " + actionPath));
        }
        ModelAndView mav = new ModelAndView();
        if ("gotodomains".equalsIgnoreCase(actionPath)) {
            SearchDomainForm form2 = (SearchDomainForm)session.getAttribute("searchDomainForm");
            model.addAttribute((Object)(form2 != null ? form2 : new SearchDomainForm()));
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("main");
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        } else if ("gotosettings".equalsIgnoreCase(actionPath)) {
            String action = "add";
            model.addAttribute("action", (Object)action);
            mav.setViewName("settings");
            mav.addObject("actionPath", (Object)actionPath);
            SettingsForm form = (SettingsForm)session.getAttribute("settingsForm");
            if (form == null) {
                form = new SettingsForm();
            }
            model.addAttribute("settingsForm", (Object)form);
            ArrayList results = null;
            if (this.configSvc != null) {
                try {
                    Collection settings = this.configSvc.getAllSettings();
                    results = settings != null ? new ArrayList(settings) : new ArrayList();
                }
                catch (ConfigurationServiceException e) {
                    e.printStackTrace();
                }
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            model.addAttribute("settingsResults", results);
        } else if (actionPath.equalsIgnoreCase("gotocertificates")) {
            String action = "Update";
            model.addAttribute("action", (Object)action);
            mav.setViewName("certificates");
            mav.addObject("actionPath", (Object)actionPath);
            CertificateForm form = (CertificateForm)session.getAttribute("certificateForm");
            if (form == null) {
                form = new CertificateForm();
            }
            model.addAttribute("certificateForm", (Object)form);
            ArrayList results = null;
            if (this.configSvc != null) {
                try {
                    Collection certs = this.configSvc.listCertificates(1L, 10000, CertificateGetOptions.DEFAULT);
                    results = certs != null ? new ArrayList(certs) : new ArrayList();
                }
                catch (ConfigurationServiceException e) {
                    e.printStackTrace();
                }
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            model.addAttribute("certificatesResults", results);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showDNSEntries(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute DNSEntryForm entryForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        ModelAndView mav = new ModelAndView("dns");
        model.addAttribute("dnsEntryForm", (Object)new DNSEntryForm());
        boolean serviceError = false;
        String errorDetails = "";
        if (this.configSvc != null) {
            this.refreshModelFromService(model);
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="AdnsForm") DNSEntryForm AdnsForm, @ModelAttribute(value="AAdnsForm") DNSEntryForm AAdnsForm, @ModelAttribute(value="CdnsForm") DNSEntryForm CdnsForm, @ModelAttribute(value="CertdnsForm") DNSEntryForm CertdnsForm, @ModelAttribute(value="SrvdnsForm") DNSEntryForm SrvdnsForm, @ModelAttribute(value="MXdnsForm") DNSEntryForm MXdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (AdnsForm != null && !AdnsForm.getName().equalsIgnoreCase("") && AdnsForm.getTtl() != 0L && !AdnsForm.getDest().equalsIgnoreCase("")) {
            AdnsForm.setType("A");
            DNSEntryForm.toDNSRecord((DNSEntryForm)AdnsForm);
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        if (AAdnsForm != null && !AAdnsForm.getName().equalsIgnoreCase("") && AAdnsForm.getTtl() != 0L && !AAdnsForm.getDest().equalsIgnoreCase("")) {
            AAdnsForm.setType("AAAA");
            DNSEntryForm.toDNSRecord((DNSEntryForm)AAdnsForm);
        }
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        if (CdnsForm != null && !CdnsForm.getName().equalsIgnoreCase("") && CdnsForm.getTtl() != 0L && !CdnsForm.getDest().equalsIgnoreCase("")) {
            CdnsForm.setType("CNAME");
            DNSEntryForm.toDNSRecord((DNSEntryForm)CdnsForm);
        }
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        if (MXdnsForm != null && !MXdnsForm.getName().equalsIgnoreCase("") && MXdnsForm.getTtl() != 0L && !MXdnsForm.getDest().equalsIgnoreCase("")) {
            MXdnsForm.setType("MX");
            DNSEntryForm.toDNSRecord((DNSEntryForm)MXdnsForm);
        }
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        if (CertdnsForm != null && !CertdnsForm.getName().equalsIgnoreCase("") && CertdnsForm.getTtl() != 0L && !CertdnsForm.getDest().equalsIgnoreCase("")) {
            CertdnsForm.setType("CERT");
            DNSEntryForm.toDNSRecord((DNSEntryForm)CertdnsForm);
        }
        if (SrvdnsForm != null && !SrvdnsForm.getName().equalsIgnoreCase("") && SrvdnsForm.getTtl() != 0L && !SrvdnsForm.getDest().equalsIgnoreCase("")) {
            SrvdnsForm.setType("SRV");
            DNSEntryForm.toDNSRecord((DNSEntryForm)SrvdnsForm);
        }
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addADNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="AdnsForm") DNSEntryForm AdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (AdnsForm != null && !AdnsForm.getName().equalsIgnoreCase("") && AdnsForm.getTtl() != 0L && !AdnsForm.getDest().equalsIgnoreCase("")) {
            ArrayList<DNSRecord> records = new ArrayList<DNSRecord>();
            records.add(DNSRecordUtils.createARecord((String)AdnsForm.getName(), (long)AdnsForm.getTtl(), (String)AdnsForm.getDest()));
            try {
                this.configSvc.addDNS(records);
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addNSDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addNSSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="NSdnsForm") DNSEntryForm NSdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (NSdnsForm != null && !NSdnsForm.getName().equalsIgnoreCase("") && NSdnsForm.getTtl() != 0L && !NSdnsForm.getDest().equalsIgnoreCase("")) {
            ArrayList<DNSRecord> records = new ArrayList<DNSRecord>();
            records.add(DNSEntryForm.createNSRecord((String)NSdnsForm.getName(), (long)NSdnsForm.getTtl(), (String)NSdnsForm.getDest()));
            try {
                this.configSvc.addDNS(records);
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
        }
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addA4DNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addA4Setting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="AAdnsForm") DNSEntryForm AAdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (AAdnsForm != null && !AAdnsForm.getName().equalsIgnoreCase("") && AAdnsForm.getTtl() != 0L && !AAdnsForm.getDest().equalsIgnoreCase("")) {
            ArrayList<DNSRecord> records = new ArrayList<DNSRecord>();
            records.add(DNSEntryForm.createA4Record((String)AAdnsForm.getName(), (long)AAdnsForm.getTtl(), (String)AAdnsForm.getDest()));
            try {
                this.configSvc.addDNS(records);
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addMXDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addMXSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="MXdnsForm") DNSEntryForm MXdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (MXdnsForm != null && !MXdnsForm.getName().equalsIgnoreCase("") && MXdnsForm.getTtl() != 0L && !MXdnsForm.getDest().equalsIgnoreCase("")) {
            ArrayList<DNSRecord> records = new ArrayList<DNSRecord>();
            records.add(DNSRecordUtils.createMXRecord((String)MXdnsForm.getName(), (String)MXdnsForm.getDest(), (long)MXdnsForm.getTtl(), (int)MXdnsForm.getPriority()));
            try {
                this.configSvc.addDNS(records);
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addCNAMEDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addCNAMESetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="CdnsForm") DNSEntryForm CdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (CdnsForm != null && !CdnsForm.getName().equalsIgnoreCase("") && CdnsForm.getTtl() != 0L && !CdnsForm.getDest().equalsIgnoreCase("")) {
            ArrayList<DNSRecord> records = new ArrayList<DNSRecord>();
            records.add(DNSEntryForm.toDNSRecord((DNSEntryForm)CdnsForm));
            try {
                this.configSvc.addDNS(records);
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addSRVDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addSRVSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="SrvdnsForm") DNSEntryForm SrvdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (SrvdnsForm != null && !SrvdnsForm.getName().equalsIgnoreCase("") && SrvdnsForm.getTtl() != 0L && !SrvdnsForm.getDest().equalsIgnoreCase("")) {
            ArrayList<DNSRecord> records = new ArrayList<DNSRecord>();
            records.add(DNSRecordUtils.createSRVRecord((String)("_" + SrvdnsForm.getService() + "._" + SrvdnsForm.getProtocol() + "." + SrvdnsForm.getName()), (String)SrvdnsForm.getDest(), (long)SrvdnsForm.getTtl(), (int)SrvdnsForm.getPort(), (int)SrvdnsForm.getPriority(), (int)SrvdnsForm.getWeight()));
            try {
                this.configSvc.addDNS(records);
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        mav.setViewName("dns");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addCertDNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addCertSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="CertdnsForm") DNSEntryForm CertdnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (CertdnsForm != null && !CertdnsForm.getName().equalsIgnoreCase("") && CertdnsForm.getTtl() != 0L) {
            boolean certtype = false;
            boolean keytag = false;
            boolean alg = false;
            X509Certificate tcert = null;
            byte[] certbytes = null;
            try {
                if (!CertdnsForm.getFileData().isEmpty()) {
                    CertContainer cont;
                    byte[] bytes;
                    certbytes = bytes = CertdnsForm.getFileData().getBytes();
                    String theUser = "";
                    if (bytes != null && (cont = this.toCertContainer(bytes)) != null && cont.getCert() != null) {
                        Certificate cert2 = new Certificate();
                        cert2.setData(bytes);
                        tcert = cont.getCert();
                    }
                }
            }
            catch (ConfigurationServiceException ed) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)ed);
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)e.getMessage());
                }
                e.printStackTrace();
            }
            ArrayList<DNSRecord> records = new ArrayList<DNSRecord>();
            CertdnsForm.setType("CERT");
            CertdnsForm.setCertificate(tcert);
            CertdnsForm.setCertificateData(certbytes);
            records.add(DNSEntryForm.createCertRecord((DNSEntryForm)CertdnsForm));
            try {
                this.configSvc.addDNS(records);
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addSOADNSRecord"}, method={RequestMethod.POST})
    public ModelAndView addSOASetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute(value="SoadnsForm") DNSEntryForm SoadnsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (SoadnsForm != null && !SoadnsForm.getName().equalsIgnoreCase("") && SoadnsForm.getTtl() != 0L) {
            ArrayList<DNSRecord> records = new ArrayList<DNSRecord>();
            records.add(DNSRecordUtils.createSOARecord((String)SoadnsForm.getName(), (long)SoadnsForm.getTtl(), (String)SoadnsForm.getDomain(), (String)SoadnsForm.getAdmin(), (int)((int)SoadnsForm.getSerial()), (long)SoadnsForm.getRefresh(), (long)SoadnsForm.getRetry(), (long)SoadnsForm.getExpire(), (long)SoadnsForm.getMinimum()));
            try {
                this.configSvc.addDNS(records);
            }
            catch (ConfigurationServiceException e) {
                e.printStackTrace();
            }
        }
        ModelAndView mav = new ModelAndView("dns");
        this.refreshModelFromService(model);
        mav.setViewName("dns");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removesettings"}, method={RequestMethod.POST})
    public ModelAndView removeAnchors(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, @ModelAttribute(value="AdnsForm") DNSEntryForm AdnsForm, @ModelAttribute(value="NSdnsForm") DNSEntryForm NSdnsForm, @ModelAttribute(value="AAdnsForm") DNSEntryForm AAdnsForm, @ModelAttribute(value="CdnsForm") DNSEntryForm CdnsForm, @ModelAttribute(value="CertdnsForm") DNSEntryForm CertdnsForm, @ModelAttribute(value="SrvdnsForm") DNSEntryForm SrvdnsForm, @ModelAttribute(value="SoadnsForm") DNSEntryForm SoadnsForm, @ModelAttribute(value="MXdnsForm") DNSEntryForm MXdnsForm, HttpSession session, Model model, @RequestParam(value="submitType") String actionPath) {
        Collection a4records;
        Long remid;
        String removeid;
        int x;
        int cnt;
        String strid;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter domain/removesettings");
        }
        try {
            strid = "" + AdnsForm.getId();
            Collection arecords = null;
            if (this.configSvc != null && AdnsForm != null && actionPath != null && actionPath.equalsIgnoreCase("deleteADnsEntries") && AdnsForm.getRemove() != null) {
                cnt = AdnsForm.getRemove().size();
                arecords = this.configSvc.getDNSByType(DNSType.A.getValue());
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)AdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : arecords) {
                        if (t.getId() != remid.longValue()) continue;
                        this.configSvc.removeDNSByRecordId(remid.longValue());
                    }
                }
            }
        }
        catch (ConfigurationServiceException e1) {
            // empty catch block
        }
        try {
            strid = "" + AAdnsForm.getId();
            a4records = null;
            if (this.configSvc != null && AAdnsForm != null && actionPath != null && actionPath.equalsIgnoreCase("deleteA4DnsEntries") && AAdnsForm.getRemove() != null) {
                cnt = AAdnsForm.getRemove().size();
                a4records = this.configSvc.getDNSByType(DNSType.AAAA.getValue());
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)AAdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records) {
                        if (t.getId() != remid.longValue()) continue;
                        this.configSvc.removeDNSByRecordId(remid.longValue());
                    }
                }
            }
        }
        catch (ConfigurationServiceException e1) {
            // empty catch block
        }
        try {
            strid = "" + CdnsForm.getId();
            a4records = null;
            if (this.configSvc != null && CdnsForm != null && actionPath != null && actionPath.equalsIgnoreCase("deleteCNAMEDnsEntries") && CdnsForm.getRemove() != null) {
                cnt = AAdnsForm.getRemove().size();
                a4records = this.configSvc.getDNSByType(DNSType.CNAME.getValue());
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)CdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records) {
                        if (t.getId() != remid.longValue()) continue;
                        this.configSvc.removeDNSByRecordId(remid.longValue());
                    }
                }
            }
        }
        catch (ConfigurationServiceException e1) {
            // empty catch block
        }
        try {
            strid = "" + MXdnsForm.getId();
            a4records = null;
            if (this.configSvc != null && MXdnsForm != null && actionPath != null && actionPath.equalsIgnoreCase("deleteMXDnsEntries") && MXdnsForm.getRemove() != null) {
                cnt = MXdnsForm.getRemove().size();
                a4records = this.configSvc.getDNSByType(DNSType.MX.getValue());
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)MXdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records) {
                        if (t.getId() != remid.longValue()) continue;
                        this.configSvc.removeDNSByRecordId(remid.longValue());
                    }
                }
            }
        }
        catch (ConfigurationServiceException e1) {
            // empty catch block
        }
        try {
            strid = "" + CertdnsForm.getId();
            a4records = null;
            if (this.configSvc != null && CertdnsForm != null && actionPath != null && actionPath.equalsIgnoreCase("deleteCERTDnsEntries") && CertdnsForm.getRemove() != null) {
                cnt = CertdnsForm.getRemove().size();
                a4records = this.configSvc.getDNSByType(DNSType.CERT.getValue());
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)CertdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records) {
                        if (t.getId() != remid.longValue()) continue;
                        this.configSvc.removeDNSByRecordId(remid.longValue());
                    }
                }
            }
        }
        catch (ConfigurationServiceException e1) {
            // empty catch block
        }
        try {
            strid = "" + SrvdnsForm.getId();
            a4records = null;
            if (this.configSvc != null && SrvdnsForm != null && actionPath != null && actionPath.equalsIgnoreCase("deleteSRVDnsEntries") && SrvdnsForm.getRemove() != null) {
                cnt = SrvdnsForm.getRemove().size();
                a4records = this.configSvc.getDNSByType(DNSType.SRV.getValue());
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)SrvdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : a4records) {
                        if (t.getId() != remid.longValue()) continue;
                        this.configSvc.removeDNSByRecordId(remid.longValue());
                    }
                }
            }
        }
        catch (ConfigurationServiceException e1) {
            // empty catch block
        }
        try {
            strid = "" + SoadnsForm.getId();
            Collection soarecords = null;
            if (this.configSvc != null && SoadnsForm != null && actionPath != null && actionPath.equalsIgnoreCase("deleteSOADnsEntries") && SoadnsForm.getRemove() != null) {
                cnt = SoadnsForm.getRemove().size();
                soarecords = this.configSvc.getDNSByType(DNSType.SOA.getValue());
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)SoadnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : soarecords) {
                        if (t.getId() != remid.longValue()) continue;
                        this.configSvc.removeDNSByRecordId(remid.longValue());
                    }
                }
            }
        }
        catch (ConfigurationServiceException e1) {
            // empty catch block
        }
        try {
            strid = "" + NSdnsForm.getId();
            Collection nsrecords = null;
            if (this.configSvc != null && NSdnsForm != null && actionPath != null && actionPath.equalsIgnoreCase("deleteNSDnsEntries") && NSdnsForm.getRemove() != null) {
                cnt = NSdnsForm.getRemove().size();
                nsrecords = this.configSvc.getDNSByType(DNSType.NS.getValue());
                for (x = 0; x < cnt; ++x) {
                    removeid = (String)NSdnsForm.getRemove().get(x);
                    remid = Long.parseLong(removeid);
                    for (DNSRecord t : nsrecords) {
                        if (t.getId() != remid.longValue()) continue;
                        this.configSvc.removeDNSByRecordId(remid.longValue());
                    }
                }
            }
        }
        catch (ConfigurationServiceException e1) {
            // empty catch block
        }
        ModelAndView mav = new ModelAndView("dns");
        if (AdnsForm.getRemove() != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("the list of checkboxes checked or not is: " + AdnsForm.getRemove().toString()));
        }
        this.refreshModelFromService(model);
        model.addAttribute("dnsEntryForm", (Object)new DNSEntryForm());
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
        return mav;
    }

    private Collection<SrvRecord> getSrvRecords(int type) {
        Collection<SrvRecord> arecords = null;
        try {
            Collection srvrecords = this.configSvc.getDNSByType(type);
        }
        catch (ConfigurationServiceException e) {
            e.printStackTrace();
        }
        return arecords;
    }

    private Collection<DNSRecord> getDnsRecords(int type) {
        Collection arecords = null;
        try {
            arecords = this.configSvc.getDNSByType(type);
        }
        catch (ConfigurationServiceException e) {
            e.printStackTrace();
        }
        return arecords;
    }

    public void refreshModelFromService(Model model) {
        Collection arecords = null;
        arecords = this.getDnsRecords(DNSType.A.getValue());
        ArrayList<DNSEntryForm> aform = new ArrayList<DNSEntryForm>();
        if (arecords != null) {
            for (DNSRecord t : arecords) {
                try {
                    ARecord newrec = (ARecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getAddress());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    aform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsARecordResults", aform);
        Collection a4records = null;
        a4records = this.getDnsRecords(DNSType.AAAA.getValue());
        ArrayList<DNSEntryForm> a4form = new ArrayList<DNSEntryForm>();
        if (a4records != null) {
            for (DNSRecord t : a4records) {
                try {
                    AAAARecord newrec = (AAAARecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getAddress());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    a4form.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsA4RecordResults", a4form);
        Collection crecords = null;
        crecords = this.getDnsRecords(DNSType.CNAME.getValue());
        ArrayList<DNSEntryForm> cform = new ArrayList<DNSEntryForm>();
        if (crecords != null) {
            for (DNSRecord t : crecords) {
                try {
                    CNAMERecord newrec = (CNAMERecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getTarget());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    cform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsCnameRecordResults", cform);
        Collection mxrecords = null;
        mxrecords = this.getDnsRecords(DNSType.MX.getValue());
        ArrayList<DNSEntryForm> mxform = new ArrayList<DNSEntryForm>();
        if (mxrecords != null) {
            for (DNSRecord t : mxrecords) {
                try {
                    MXRecord newrec = (MXRecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setPriority(newrec.getPriority());
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getTarget());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    mxform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsMxRecordResults", mxform);
        Collection certrecords = null;
        certrecords = this.getDnsRecords(DNSType.CERT.getValue());
        ArrayList<SrvRecord> form = new ArrayList<SrvRecord>();
        if (certrecords != null) {
            for (DNSRecord t : certrecords) {
                SrvRecord srv = new SrvRecord();
                srv.setCreateTime(t.getCreateTime());
                srv.setData(t.getData());
                srv.setDclass(t.getDclass());
                srv.setId(t.getId());
                srv.setName(t.getName());
                srv.setTtl(t.getTtl());
                srv.setType(t.getType());
                srv.setThumb("");
                byte[] bytes = t.getData();
                try {
                    CertContainer cont;
                    CERTRecord newrec = (CERTRecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    String thumb = "";
                    byte[] certData = newrec.getCert();
                    if (certData != null && (cont = this.toCertContainer(certData)) != null && cont.getCert() != null) {
                        Certificate cert2 = new Certificate();
                        cert2.setData(certData);
                        thumb = DNSController.getThumbPrint((X509Certificate)cont.getCert());
                        srv.setThumb(thumb);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                form.add(srv);
            }
        }
        model.addAttribute("dnsCertRecordResults", form);
        Collection srvrecords = null;
        srvrecords = this.getDnsRecords(DNSType.SRV.getValue());
        ArrayList<SrvRecord> form2 = new ArrayList<SrvRecord>();
        if (srvrecords != null) {
            for (DNSRecord t : srvrecords) {
                SrvRecord srv = new SrvRecord();
                try {
                    SRVRecord srv4 = (SRVRecord)SRVRecord.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    srv.setCreateTime(t.getCreateTime());
                    srv.setData(t.getData());
                    srv.setDclass(t.getDclass());
                    srv.setId(t.getId());
                    srv.setName(t.getName());
                    String name = t.getName();
                    int firstpos = name.indexOf("_");
                    if (firstpos == 0) {
                        int secondpos = name.indexOf("._");
                        int thirdpos = name.indexOf(".", secondpos + 2);
                        String service_ = name.substring(firstpos + 1, secondpos);
                        srv.setService(service_);
                        String protocol_ = name.substring(secondpos + 2, thirdpos);
                        srv.setProtocol(protocol_);
                        int last2pos = name.indexOf(".", thirdpos);
                        String name_ = name.substring(last2pos + 1, name.length());
                        srv.setName(name_);
                    }
                    srv.setTtl(t.getTtl());
                    srv.setType(t.getType());
                    srv.setPort(srv4.getPort());
                    srv.setWeight(srv4.getWeight());
                    srv.setPriority("" + srv4.getPriority());
                    srv.setTarget("" + srv4.getTarget().toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                form2.add(srv);
            }
        }
        model.addAttribute("dnsSrvRecordResults", form2);
        Collection soarecords = null;
        soarecords = this.getDnsRecords(DNSType.SOA.getValue());
        ArrayList<DNSEntryForm> soaform = new ArrayList<DNSEntryForm>();
        if (soarecords != null) {
            for (DNSRecord t : soarecords) {
                try {
                    SOARecord newrec = (SOARecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setAdmin("" + newrec.getAdmin());
                    tmp.setExpire(newrec.getExpire());
                    tmp.setMinimum(newrec.getMinimum());
                    tmp.setRefresh(newrec.getRefresh());
                    tmp.setRetry(newrec.getRetry());
                    tmp.setSerial(newrec.getSerial());
                    tmp.setDest("" + newrec.getHost());
                    tmp.setDomain("" + newrec.getHost());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    soaform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsSOARecordResults", soaform);
        Collection nsrecords = null;
        nsrecords = this.getDnsRecords(DNSType.NS.getValue());
        ArrayList<DNSEntryForm> nsform = new ArrayList<DNSEntryForm>();
        if (nsrecords != null) {
            for (DNSRecord t : nsrecords) {
                try {
                    NSRecord newrec = (NSRecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getTarget());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    nsform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsNSRecordResults", nsform);
        model.addAttribute("NSdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SoadnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }

    public CertContainer toCertContainer(byte[] data) throws Exception {
        CertContainer certContainer = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", Certificate.getJCEProviderName());
                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, "".toCharArray());
                    if (key != null && key instanceof PrivateKey) {
                        certContainer = new CertContainer(cert, key);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (certContainer == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, null);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new ConfigurationServiceException("Data cannot be converted to a valid X.509 Certificate", (Throwable)e);
        }
        return certContainer;
    }

    private String getEmailAddress(X500Principal prin) {
        HashMap<String, String> oidMap = new HashMap<String, String>();
        oidMap.put("1.2.840.113549.1.9.1", "EMAILADDRESS");
        String prinName = prin.getName("RFC1779", oidMap);
        String searchString = "EMAILADDRESS=";
        int index = prinName.indexOf(searchString);
        if (index == -1 && (index = prinName.indexOf(searchString = "CN=")) == -1) {
            return "";
        }
        int endIndex = prinName.indexOf(",", index);
        String address = endIndex > -1 ? prinName.substring(index + searchString.length(), endIndex) : prinName.substring(index + searchString.length());
        return address;
    }

    public static String getThumbPrint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = null;
        byte[] digest = null;
        try {
            der = cert.getEncoded();
            md.update(der);
            digest = md.digest();
        }
        catch (java.security.cert.CertificateEncodingException e) {
            e.printStackTrace();
        }
        return DNSController.hexify(digest);
    }

    public static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }
}

