/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui.form;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import org.nhindirect.config.store.ConfigurationStoreException;
import org.nhindirect.config.store.DNSRecord;
import org.nhindirect.config.store.util.DNSRecordUtils;
import org.nhindirect.config.ui.form.DNSEntryForm;
import org.nhindirect.config.ui.form.DNSType;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.SRVRecord;

/*
 * Exception performing whole class analysis ignored.
 */
public class DNSEntryForm {
    private String admin = "";
    private long expire = 0L;
    private long minimum = 0L;
    private long refresh = 0L;
    private long retry = 0L;
    private long serial = 0L;
    private String thumbprint;
    private String trusteddomainoruser;
    private Long id = 0L;
    private String name = "";
    private String type = "";
    private String dest = "";
    private String service = null;
    private String protocol = null;
    private String domain = null;
    private X509Certificate certificate = null;
    private byte[] certificateData;
    private CommonsMultipartFile fileData;
    private long ttl = 86400L;
    private int weight = 0;
    private int priority = 0;
    private int port = 0;
    private Calendar createTime;
    private List<String> remove;

    public static DNSRecord createA4Record(String name, long ttl, String ip) throws ConfigurationStoreException {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        try {
            AAAARecord rec = new AAAARecord(Name.fromString((String)name), 1, ttl, InetAddress.getByName(ip));
            return DNSRecord.fromWire((byte[])rec.toWireCanonical());
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to create DNS A record: " + e.getMessage(), (Throwable)e);
        }
    }

    public static DNSRecord createNSRecord(String name, long ttl, String target) throws ConfigurationStoreException {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!target.endsWith(".")) {
            target = target + ".";
        }
        try {
            NSRecord rec = new NSRecord(Name.fromString((String)name), 1, ttl, Name.fromString((String)target));
            return DNSRecord.fromWire((byte[])rec.toWireCanonical());
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to create DNS NS record: " + e.getMessage(), (Throwable)e);
        }
    }

    public static DNSRecord createCNAMERecord(String name, long ttl, String dest) throws ConfigurationStoreException {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!dest.endsWith(".")) {
            dest = dest + ".";
        }
        try {
            CNAMERecord rec = new CNAMERecord(Name.fromString((String)name), 1, ttl, Name.fromString((String)dest));
            return DNSRecord.fromWire((byte[])rec.toWireCanonical());
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to create DNS CNAME record: " + e.getMessage(), (Throwable)e);
        }
    }

    public static DNSRecord createCertRecord(String name, long ttl, int certtype, int keytag, int alg, X509Certificate cert) throws ConfigurationStoreException {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        try {
            int keyTag = 0;
            if (cert.getPublicKey() instanceof RSAKey) {
                RSAKey key = (RSAKey)((Object)cert.getPublicKey());
                byte[] modulus = key.getModulus().toByteArray();
                keyTag = modulus[modulus.length - 2] << 8 & 0xFF00;
                keyTag |= modulus[modulus.length - 1] & 0xFF;
            }
            CERTRecord rec = new CERTRecord(Name.fromString((String)name), 1, ttl, 1, keyTag, 5, cert.getEncoded());
            return DNSRecord.fromWire((byte[])rec.toWireCanonical());
        }
        catch (Exception e) {
            throw new ConfigurationStoreException("Failed to create DNS CERT record: " + e.getMessage(), (Throwable)e);
        }
    }

    public static DNSRecord createCertRecord(DNSEntryForm form) {
        DNSRecord result = new DNSRecord();
        if (form.getName() == null || form.getCertificate() == null) {
            return result;
        }
        result = DNSRecordUtils.createX509CERTRecord((String)form.getName(), (long)form.getTtl(), (X509Certificate)form.getCertificate());
        return result;
    }

    public static DNSRecord toDNSRecord(DNSEntryForm form) {
        DNSRecord result = new DNSRecord();
        if (form == null) {
            return result;
        }
        switch (1.$SwitchMap$org$nhindirect$config$ui$form$DNSType[DNSType.get((String)form.getType()).ordinal()]) {
            case 1: {
                result = DNSRecordUtils.createARecord((String)form.getName(), (long)form.getTtl(), (String)form.getDest());
                break;
            }
            case 2: {
                result = DNSEntryForm.createA4Record((String)form.getName(), (long)form.getTtl(), (String)form.getDest());
                break;
            }
            case 3: {
                result = DNSEntryForm.createCNAMERecord((String)form.getName(), (long)form.getTtl(), (String)form.getDest());
                break;
            }
            case 4: {
                result = DNSRecordUtils.createMXRecord((String)form.getName(), (String)form.getDest(), (long)form.getTtl(), (int)form.getPriority());
                break;
            }
            case 5: {
                if (form.getName() == null || form.getCertificate() == null) break;
                result = DNSRecordUtils.createX509CERTRecord((String)form.getName(), (long)form.getTtl(), (X509Certificate)form.getCertificate());
                break;
            }
            case 6: {
                if (form.getDest() == null || form.getName() == null || form.getCertificate() == null) break;
                result = DNSRecordUtils.createSRVRecord((String)form.getName(), (String)form.getDest(), (long)form.getTtl(), (int)form.getPort(), (int)form.getPriority(), (int)form.getWeight());
            }
        }
        return result;
    }

    public DNSEntryForm() {
    }

    public DNSEntryForm(DNSRecord r) {
        this.setName(r.getName());
        this.setType(DNSType.get((int)r.getType()).toString());
        this.setTtl(r.getTtl());
        this.setCreateTime(r.getCreateTime());
        switch (1.$SwitchMap$org$nhindirect$config$ui$form$DNSType[DNSType.get((int)r.getType()).ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.setDest(new String(r.getData()));
                break;
            }
            case 5: {
                try {
                    ByteArrayInputStream str = new ByteArrayInputStream(r.getData());
                    this.setCertificate((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(str));
                    ((InputStream)str).close();
                }
                catch (CertificateException e) {
                }
                catch (IOException e) {}
                break;
            }
            case 6: {
                try {
                    SRVRecord record = (SRVRecord)SRVRecord.fromWire((byte[])DNSRecord.toWire((DNSRecord)r), (int)1);
                    this.setPort(record.getPort());
                    this.setPriority(record.getPriority());
                    this.setWeight(record.getWeight());
                    this.setDest(record.getTarget().toString());
                    StringTokenizer stok = new StringTokenizer(record.getName().toString(), ".");
                    if (stok.countTokens() <= 2) break;
                    this.setService(stok.nextToken());
                    this.setProtocol(stok.nextToken());
                    StringBuffer dName = new StringBuffer(stok.nextToken());
                    while (stok.hasMoreTokens()) {
                        dName.append(".").append(stok.nextToken());
                    }
                    this.setDomain(dName.toString());
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        if (this.name.length() == 0 && this.getType().equals(DNSType.SRV.toString())) {
            this.name = "_" + this.getService() + "._" + this.getProtocol() + "." + this.getDomain();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public DNSType getDNSType() {
        return DNSType.get((String)this.getType());
    }

    public void setType(String type) {
        DNSType dType = DNSType.get((String)type);
        if (dType != null) {
            this.type = type;
        }
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String name) {
        this.domain = name;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Calendar getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Calendar createTime) {
        this.createTime = createTime;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public void setRemove(List<String> remove) {
        this.remove = remove;
    }

    public List<String> getRemove() {
        return this.remove;
    }

    public void setCertificateData(byte[] certificateData) {
        this.certificateData = certificateData;
    }

    public byte[] getCertificateData() {
        return this.certificateData;
    }

    public void setFileData(CommonsMultipartFile fileData) {
        this.fileData = fileData;
    }

    public CommonsMultipartFile getFileData() {
        return this.fileData;
    }

    public void setTrusteddomainoruser(String trusteddomainoruser) {
        this.trusteddomainoruser = trusteddomainoruser;
    }

    public String getTrusteddomainoruser() {
        return this.trusteddomainoruser;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public String getAdmin() {
        return this.admin;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setMinimum(long minimum) {
        this.minimum = minimum;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public void setRefresh(long refresh) {
        this.refresh = refresh;
    }

    public long getRefresh() {
        return this.refresh;
    }

    public void setRetry(long retry) {
        this.retry = retry;
    }

    public long getRetry() {
        return this.retry;
    }

    public void setSerial(long serial) {
        this.serial = serial;
    }

    public long getSerial() {
        return this.serial;
    }
}

