/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.ConfigurationService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.impl.CertificateGetOptions;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.ui.form.CertificateForm;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/certificates"})
public class CertificatesController {
    private final Log log = LogFactory.getLog(this.getClass());
    private ConfigurationService configSvc;

    @Inject
    public void setConfigurationService(ConfigurationService certService) {
        this.configSvc = certService;
    }

    public CertificatesController() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ConfigurationController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addcertificate"}, method={RequestMethod.POST})
    public ModelAndView addCertificate(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute CertificateForm certificateForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav = new ModelAndView();
        String strid = "";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter domain/addcertificate");
        }
        if (actionPath.equalsIgnoreCase("cancel")) {
            SearchDomainForm form2;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to cancel from saveupdate");
            }
            model.addAttribute((Object)((form2 = (SearchDomainForm)session.getAttribute("searchDomainForm")) != null ? form2 : new SearchDomainForm()));
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("main");
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
            return mav;
        }
        if (actionPath.equalsIgnoreCase("newcertificate") || actionPath.equalsIgnoreCase("add certificate")) {
            strid = "" + certificateForm.getId();
            EntityStatus estatus = certificateForm.getStatus();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"beginning to evaluate filedata");
            }
            try {
                model.addAttribute("certerror", (Object)false);
                if (!certificateForm.getFileData().isEmpty()) {
                    byte[] bytes = certificateForm.getFileData().getBytes();
                    String owner = "";
                    String fileType = certificateForm.getFileData().getContentType();
                    if (!(fileType.matches("application/x-x509-ca-cert") || fileType.matches("application/octet-stream") || fileType.matches("application/x-pkcs12"))) {
                        model.addAttribute("certerror", (Object)true);
                    } else {
                        Certificate cert = new Certificate();
                        cert.setData(bytes);
                        cert.setOwner(owner);
                        cert.setStatus(certificateForm.getStatus());
                        ArrayList<Certificate> certlist = new ArrayList<Certificate>();
                        certlist.add(cert);
                        this.configSvc.addCertificates(certlist);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"store the certificate into database");
                        }
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"DO NOT store the certificate into database BECAUSE THERE IS NO FILE");
                }
            }
            catch (ConfigurationServiceException ed) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)ed);
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)e);
                }
                e.printStackTrace();
            }
            try {
                Collection certs = this.configSvc.listCertificates(1L, 1000, CertificateGetOptions.DEFAULT);
                model.addAttribute("certificatesResults", (Object)certs);
                CertificateForm cform = new CertificateForm();
                cform.setId(0L);
                model.addAttribute("certificateForm", (Object)cform);
            }
            catch (ConfigurationServiceException e1) {
                e1.printStackTrace();
            }
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            SimpleForm simple = new SimpleForm();
            simple.setId(Long.parseLong(strid));
            model.addAttribute("simpleForm", (Object)simple);
            mav.setViewName("certificates");
            String action = "Update";
            model.addAttribute("action", (Object)action);
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removecertifcates"}, method={RequestMethod.POST})
    public ModelAndView removeCertificates(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute CertificateForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav;
        block14: {
            mav = new ModelAndView();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Enter domain/removecertificates");
            }
            if (simpleForm.getRemove() != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("the list of checkboxes checked or not is: " + simpleForm.getRemove().toString()));
            }
            if (this.configSvc != null && simpleForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deletecertificate") || actionPath.equalsIgnoreCase("Remove Selected")) && simpleForm.getRemove() != null) {
                int cnt = simpleForm.getRemove().size();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"removing certificates");
                }
                try {
                    Collection certs = this.configSvc.listCertificates(1L, 1000, CertificateGetOptions.DEFAULT);
                    ArrayList<Long> certtoberemovedlist = new ArrayList<Long>();
                    block4: for (int x = 0; x < cnt; ++x) {
                        String removeid = (String)simpleForm.getRemove().get(x);
                        for (Certificate t : certs) {
                            if (t.getId() != Long.parseLong(removeid)) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)" ");
                                this.log.debug((Object)("domain address id: " + t.getId()));
                                this.log.debug((Object)" ");
                            }
                            certtoberemovedlist.add(t.getId());
                            continue block4;
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" Trying to remove certificates from database");
                    }
                    this.configSvc.removeCertificates(certtoberemovedlist);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" SUCCESS Trying to update certificates");
                    }
                }
                catch (ConfigurationServiceException e) {
                    if (!this.log.isDebugEnabled()) break block14;
                    this.log.error((Object)e);
                }
            }
        }
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        CertificateForm cform = new CertificateForm();
        cform.setId(0L);
        model.addAttribute("certificateForm", (Object)cform);
        mav.setViewName("certificates");
        String action = "Update";
        model.addAttribute("action", (Object)action);
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.addObject("action", (Object)action);
        Collection certlist = null;
        try {
            certlist = this.configSvc.listCertificates(1L, 1000, CertificateGetOptions.DEFAULT);
        }
        catch (ConfigurationServiceException e) {
            e.printStackTrace();
        }
        model.addAttribute("certificatesResults", (Object)certlist);
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        model.addAttribute("simpleForm", (Object)simpleForm);
        String strid = "" + simpleForm.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" the value of id of simpleform is: " + strid));
        }
        return mav;
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }
}

