/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.ConfigurationService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.impl.CertificateGetOptions;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Anchor;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.nhindirect.config.ui.DomainController;
import org.nhindirect.config.ui.form.AddressForm;
import org.nhindirect.config.ui.form.AnchorForm;
import org.nhindirect.config.ui.form.CertificateForm;
import org.nhindirect.config.ui.form.DomainForm;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/domain"})
public class DomainController {
    private final Log log = LogFactory.getLog(this.getClass());
    private ConfigurationService configSvc;

    @Inject
    public void setConfigurationService(ConfigurationService service) {
        this.configSvc = service;
    }

    public DomainController() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"DomainController initialized");
        }
    }

    private Collection<AnchorForm> convertAnchors(Collection<Anchor> anchors) {
        ArrayList<AnchorForm> form = new ArrayList<AnchorForm>();
        if (anchors != null) {
            for (Anchor t : anchors) {
                AnchorForm e = new AnchorForm();
                e.setCertificateData(t.getData());
                e.setCertificateId(t.getCertificateId());
                e.setCreateTime(t.getCreateTime());
                e.setId(t.getId());
                e.setIncoming(t.isIncoming());
                e.setOutgoing(t.isOutgoing());
                e.setOwner(t.getOwner());
                e.setStatus(t.getStatus());
                e.setThumbprint(t.getThumbprint());
                e.setValidEndDate(t.getValidEndDate());
                e.setValidStartDate(t.getValidStartDate());
                String theUser = "";
                if (t.getData() != null) {
                    try {
                        CertContainer cont = this.toCertContainer(t.getData());
                        if (cont != null && cont.getCert() != null) {
                            theUser = this.getTrustedEntityName(cont.getCert().getSubjectX500Principal());
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                e.setTrusteddomainoruser(theUser);
                form.add(e);
            }
        }
        return form;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addBundle"}, method={RequestMethod.POST})
    public ModelAndView addBundle(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute AnchorForm anchorForm, Model model, @RequestParam(value="domainId") String domainId, @RequestParam(value="bundles") String bundles) {
        String[] bundleIds;
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter domain/addBundle");
        }
        for (String bundle : bundleIds = bundles.split(":")) {
            String[] bundleArray = bundle.split("_");
            try {
                if (bundleArray[1].equals("both")) {
                    this.configSvc.associateTrustBundleToDomain(Long.parseLong(domainId), (long)Integer.parseInt(bundleArray[0]), true, true);
                    continue;
                }
                if (bundleArray[1].equals("in")) {
                    this.configSvc.associateTrustBundleToDomain(Long.parseLong(domainId), (long)Integer.parseInt(bundleArray[0]), true, false);
                    continue;
                }
                if (bundleArray[1].equals("out")) {
                    this.configSvc.associateTrustBundleToDomain(Long.parseLong(domainId), (long)Integer.parseInt(bundleArray[0]), false, true);
                    continue;
                }
                this.configSvc.associateTrustBundleToDomain(Long.parseLong(domainId), (long)Integer.parseInt(bundleArray[0]), false, false);
            }
            catch (ConfigurationServiceException cse) {
                // empty catch block
            }
        }
        return new ModelAndView("redirect:/config/domain?id=" + domainId + "&action=update#tab3");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removeBundles"}, method={RequestMethod.POST})
    public ModelAndView removeBundles(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute AnchorForm anchorForm, Model model, @RequestParam(value="domainId") String domainId, @RequestParam(value="bundles") String bundles) {
        String[] bundleIds;
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter domain/removeBundles");
        }
        for (String bundle : bundleIds = bundles.split(":")) {
            try {
                this.configSvc.disassociateTrustBundleFromDomain(Long.parseLong(domainId), Long.parseLong(bundle));
            }
            catch (ConfigurationServiceException cse) {
                // empty catch block
            }
        }
        return new ModelAndView("redirect:/config/domain?id=" + domainId + "&action=update#tab3");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addanchor"}, method={RequestMethod.POST})
    public ModelAndView addAnchor(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute AnchorForm anchorForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav = new ModelAndView();
        String strid = "";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter domain/addanchor");
        }
        if (actionPath.equalsIgnoreCase("newanchor") || actionPath.equalsIgnoreCase("add anchor")) {
            strid = "" + anchorForm.getId();
            Domain dom = this.configSvc.getDomain(Long.valueOf(Long.parseLong(strid)));
            String owner = "";
            if (dom != null) {
                owner = dom.getDomainName();
            }
            EntityStatus estatus = anchorForm.getStatus();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"beginning to evaluate filedata");
            }
            try {
                if (!anchorForm.getFileData().isEmpty()) {
                    CertContainer cont;
                    byte[] bytes = anchorForm.getFileData().getBytes();
                    String theUser = "";
                    if (bytes != null && (cont = this.toCertContainer(bytes)) != null && cont.getCert() != null) {
                        theUser = this.getTrustedEntityName(cont.getCert().getSubjectX500Principal());
                        anchorForm.setTrusteddomainoruser(theUser);
                    }
                    Anchor ank = new Anchor();
                    ank.setData(bytes);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("incoming is: " + anchorForm.isIncoming() + " and outgoing is: " + anchorForm.isOutgoing()));
                    }
                    ank.setIncoming(anchorForm.isIncoming());
                    ank.setOutgoing(anchorForm.isOutgoing());
                    ank.setOwner(owner);
                    ank.setStatus(anchorForm.getStatus());
                    ArrayList<Anchor> anchorlist = new ArrayList<Anchor>();
                    anchorlist.add(ank);
                    this.configSvc.addAnchors(anchorlist);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"store the anchor certificate into database");
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"DO NOT store the anchor certificate into database BECAUSE THERE IS NO FILE");
                }
            }
            catch (ConfigurationServiceException ed) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)ed);
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)e.getMessage());
                }
                e.printStackTrace();
            }
            try {
                Collection certs = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                model.addAttribute("certificatesResults", (Object)certs);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                Collection anchors = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                Collection convertedanchors = this.convertAnchors(anchors);
                model.addAttribute("anchorsResults", (Object)convertedanchors);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                CertificateForm cform = new CertificateForm();
                cform.setId(dom.getId().longValue());
                model.addAttribute("certificateForm", (Object)cform);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                AnchorForm aform = new AnchorForm();
                aform.setId(dom.getId().longValue());
                model.addAttribute("anchorForm", (Object)aform);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            SimpleForm simple = new SimpleForm();
            simple.setId(Long.parseLong(strid));
            model.addAttribute("simpleForm", (Object)simple);
            model.addAttribute("addressesResults", (Object)dom.getAddresses());
            mav.setViewName("domain");
            String action = "Update";
            DomainForm form = (DomainForm)session.getAttribute("domainForm");
            if (form == null) {
                form = new DomainForm();
                form.populate(dom);
            }
            model.addAttribute("domainForm", (Object)form);
            model.addAttribute("action", (Object)action);
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        }
        AddressForm addressForm2 = new AddressForm();
        addressForm2.setDisplayName("");
        addressForm2.setEndpoint("");
        addressForm2.setEmailAddress("");
        addressForm2.setType("");
        addressForm2.setId(Long.valueOf(Long.parseLong(strid)));
        model.addAttribute("addressForm", (Object)addressForm2);
        return new ModelAndView("redirect:/config/domain?id=" + anchorForm.getId() + "#tab2");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removeanchors"}, method={RequestMethod.POST})
    public ModelAndView removeAnchors(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute AnchorForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        String owner;
        Domain dom;
        String strid;
        ModelAndView mav;
        block18: {
            mav = new ModelAndView();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Enter domain/removeanchor");
            }
            if (simpleForm.getRemove() != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("the list of checkboxes checked or not is: " + simpleForm.getRemove().toString()));
            }
            strid = "" + simpleForm.getId();
            dom = this.configSvc.getDomain(Long.valueOf(Long.parseLong(strid)));
            owner = "";
            String domname = "";
            if (dom != null) {
                owner = domname = dom.getDomainName();
            }
            if (this.configSvc != null && simpleForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deleteanchors") || actionPath.equalsIgnoreCase("Remove Selected Anchors")) && simpleForm.getRemove() != null) {
                int cnt = simpleForm.getRemove().size();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("removing anchors for domain with name: " + domname));
                }
                try {
                    Collection certs = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                    ArrayList<Long> certtoberemovedlist = new ArrayList<Long>();
                    block6: for (int x = 0; x < cnt; ++x) {
                        String removeid = (String)simpleForm.getRemove().get(x);
                        for (Anchor t : certs) {
                            if (t.getId() != Long.parseLong(removeid)) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)" ");
                                this.log.debug((Object)("domain address id: " + t.getId()));
                                this.log.debug((Object)" ");
                            }
                            certtoberemovedlist.add(t.getId());
                            continue block6;
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" Trying to remove anchors from database");
                    }
                    this.configSvc.removeAnchors(certtoberemovedlist);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" SUCCESS Trying to update the domain with removed anchors");
                    }
                    AddressForm addrform = new AddressForm();
                    addrform.setId(dom.getId());
                    model.addAttribute("addressForm", (Object)addrform);
                }
                catch (ConfigurationServiceException e) {
                    if (!this.log.isDebugEnabled()) break block18;
                    this.log.error((Object)e);
                }
            }
        }
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        CertificateForm cform = new CertificateForm();
        cform.setId(dom.getId().longValue());
        model.addAttribute("certificateForm", (Object)cform);
        AnchorForm aform = new AnchorForm();
        aform.setId(dom.getId().longValue());
        model.addAttribute("anchorForm", (Object)aform);
        model.addAttribute("addressesResults", (Object)dom.getAddresses());
        mav.setViewName("domain");
        String action = "Update";
        DomainForm form = (DomainForm)session.getAttribute("domainForm");
        if (form == null) {
            form = new DomainForm();
            form.populate(dom);
        }
        model.addAttribute("domainForm", (Object)form);
        model.addAttribute("action", (Object)action);
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.addObject("action", (Object)action);
        model.addAttribute("addressesResults", (Object)form.getAddresses());
        Collection certlist = null;
        try {
            certlist = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
        }
        catch (ConfigurationServiceException e) {
            e.printStackTrace();
        }
        Collection anchorlist = null;
        try {
            anchorlist = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        model.addAttribute("certificatesResults", (Object)certlist);
        Collection convertedanchors = this.convertAnchors(anchorlist);
        model.addAttribute("anchorsResults", (Object)convertedanchors);
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        model.addAttribute("simpleForm", (Object)simpleForm);
        strid = "" + simpleForm.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" the value of id of simpleform is: " + strid));
        }
        return new ModelAndView("redirect:/config/domain?id=" + simpleForm.getId() + "#tab2");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addcertificate"}, method={RequestMethod.POST})
    public ModelAndView addCertificate(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute CertificateForm certificateForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav = new ModelAndView();
        String strid = "";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter domain/addcertificate");
        }
        if (actionPath.equalsIgnoreCase("newcertificate") || actionPath.equalsIgnoreCase("add certificate")) {
            strid = "" + certificateForm.getId();
            Domain dom = this.configSvc.getDomain(Long.valueOf(Long.parseLong(strid)));
            String owner = "";
            if (dom != null) {
                owner = dom.getPostMasterEmail();
            }
            EntityStatus estatus = certificateForm.getStatus();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"beginning to evaluate filedata");
            }
            try {
                if (!certificateForm.getFileData().isEmpty()) {
                    byte[] bytes = certificateForm.getFileData().getBytes();
                    owner = certificateForm.getOwner();
                    Certificate cert = new Certificate();
                    cert.setData(bytes);
                    cert.setOwner(owner);
                    cert.setStatus(certificateForm.getStatus());
                    ArrayList<Certificate> certlist = new ArrayList<Certificate>();
                    certlist.add(cert);
                    this.configSvc.addCertificates(certlist);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"store the certificate into database");
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"DO NOT store the certificate into database BECAUSE THERE IS NO FILE");
                }
            }
            catch (ConfigurationServiceException ed) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)ed);
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error((Object)e);
                }
                e.printStackTrace();
            }
            try {
                Collection certs = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                model.addAttribute("certificatesResults", (Object)certs);
                Collection anchors = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                Collection convertedanchors = this.convertAnchors(anchors);
                model.addAttribute("anchorsResults", (Object)convertedanchors);
                CertificateForm cform = new CertificateForm();
                cform.setId(dom.getId().longValue());
                model.addAttribute("certificateForm", (Object)cform);
                AnchorForm aform = new AnchorForm();
                aform.setId(dom.getId().longValue());
                model.addAttribute("anchorForm", (Object)aform);
            }
            catch (ConfigurationServiceException e1) {
                e1.printStackTrace();
            }
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            SimpleForm simple = new SimpleForm();
            simple.setId(Long.parseLong(strid));
            model.addAttribute("simpleForm", (Object)simple);
            model.addAttribute("addressesResults", (Object)dom.getAddresses());
            mav.setViewName("domain");
            String action = "Update";
            DomainForm form = (DomainForm)session.getAttribute("domainForm");
            if (form == null) {
                form = new DomainForm();
                form.populate(dom);
            }
            model.addAttribute("domainForm", (Object)form);
            model.addAttribute("action", (Object)action);
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        }
        AddressForm addressForm2 = new AddressForm();
        addressForm2.setDisplayName("");
        addressForm2.setEndpoint("");
        addressForm2.setEmailAddress("");
        addressForm2.setType("");
        addressForm2.setId(Long.valueOf(Long.parseLong(strid)));
        model.addAttribute("addressForm", (Object)addressForm2);
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removecertifcates"}, method={RequestMethod.POST})
    public ModelAndView removeCertificates(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute CertificateForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        String owner;
        Domain dom;
        String strid;
        ModelAndView mav;
        block18: {
            mav = new ModelAndView();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Enter domain/removecertificates");
            }
            if (simpleForm.getRemove() != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("the list of checkboxes checked or not is: " + simpleForm.getRemove().toString()));
            }
            strid = "" + simpleForm.getId();
            dom = this.configSvc.getDomain(Long.valueOf(Long.parseLong(strid)));
            owner = "";
            String domname = "";
            if (dom != null) {
                owner = domname = dom.getPostMasterEmail();
            }
            if (this.configSvc != null && simpleForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deletecertificate") || actionPath.equalsIgnoreCase("remove selected")) && simpleForm.getRemove() != null) {
                int cnt = simpleForm.getRemove().size();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("removing certificates for domain with name: " + domname));
                }
                try {
                    Collection certs = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                    ArrayList<Long> certtoberemovedlist = new ArrayList<Long>();
                    block6: for (int x = 0; x < cnt; ++x) {
                        String removeid = (String)simpleForm.getRemove().get(x);
                        for (Certificate t : certs) {
                            if (t.getId() != Long.parseLong(removeid)) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)" ");
                                this.log.debug((Object)("domain address id: " + t.getId()));
                                this.log.debug((Object)" ");
                            }
                            certtoberemovedlist.add(t.getId());
                            continue block6;
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" Trying to remove certificates from database");
                    }
                    this.configSvc.removeCertificates(certtoberemovedlist);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" SUCCESS Trying to update the domain with removed certificates");
                    }
                    AddressForm addrform = new AddressForm();
                    addrform.setId(dom.getId());
                    model.addAttribute("addressForm", (Object)addrform);
                }
                catch (ConfigurationServiceException e) {
                    if (!this.log.isDebugEnabled()) break block18;
                    this.log.error((Object)e);
                }
            }
        }
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        CertificateForm cform = new CertificateForm();
        cform.setId(dom.getId().longValue());
        model.addAttribute("certificateForm", (Object)cform);
        AnchorForm aform = new AnchorForm();
        aform.setId(dom.getId().longValue());
        model.addAttribute("anchorForm", (Object)aform);
        model.addAttribute("addressesResults", (Object)dom.getAddresses());
        mav.setViewName("domain");
        String action = "Update";
        DomainForm form = (DomainForm)session.getAttribute("domainForm");
        if (form == null) {
            form = new DomainForm();
            form.populate(dom);
        }
        model.addAttribute("domainForm", (Object)form);
        model.addAttribute("action", (Object)action);
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.addObject("action", (Object)action);
        model.addAttribute("addressesResults", (Object)form.getAddresses());
        Collection certlist = null;
        try {
            certlist = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
        }
        catch (ConfigurationServiceException e) {
            e.printStackTrace();
        }
        Collection anchorlist = null;
        try {
            anchorlist = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        model.addAttribute("certificatesResults", (Object)certlist);
        Collection convertedanchors = this.convertAnchors(anchorlist);
        model.addAttribute("anchorsResults", (Object)convertedanchors);
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        model.addAttribute("simpleForm", (Object)simpleForm);
        strid = "" + simpleForm.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" the value of id of simpleform is: " + strid));
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addaddress"}, method={RequestMethod.POST})
    public ModelAndView addAddress(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute AddressForm addressForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav = new ModelAndView();
        String strid = "";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter domain/addaddress");
        }
        if (actionPath.equalsIgnoreCase("newaddress") || actionPath.equalsIgnoreCase("add address")) {
            String owner;
            Domain dom;
            block13: {
                strid = "" + addressForm.getId();
                dom = this.configSvc.getDomain(Long.valueOf(Long.parseLong(strid)));
                owner = dom.getPostMasterEmail();
                String anEmail = addressForm.getEmailAddress();
                String displayname = addressForm.getDisplayName();
                String endpoint = addressForm.getEndpoint();
                EntityStatus estatus = addressForm.getaStatus();
                String etype = addressForm.getType();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(" Trying to add address: " + anEmail));
                }
                Address e = new Address();
                e.setEmailAddress(anEmail);
                e.setDisplayName(displayname);
                e.setEndpoint(endpoint);
                e.setStatus(estatus);
                e.setType(etype);
                dom.getAddresses().add(e);
                try {
                    this.configSvc.updateDomain(dom);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" After attempt to insert new email address ");
                    }
                }
                catch (ConfigurationServiceException ed) {
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.error((Object)ed);
                }
            }
            try {
                Collection certs = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                model.addAttribute("certificatesResults", (Object)certs);
            }
            catch (ConfigurationServiceException e1) {
                // empty catch block
            }
            try {
                Collection anchors = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                Collection convertedanchors = this.convertAnchors(anchors);
                model.addAttribute("anchorsResults", (Object)convertedanchors);
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                CertificateForm cform = new CertificateForm();
                cform.setId(dom.getId().longValue());
                model.addAttribute("certificateForm", (Object)cform);
                AnchorForm aform = new AnchorForm();
                aform.setId(dom.getId().longValue());
                model.addAttribute("anchorForm", (Object)aform);
            }
            catch (Exception e1x) {
                // empty catch block
            }
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            SimpleForm simple = new SimpleForm();
            simple.setId(Long.parseLong(strid));
            model.addAttribute("simpleForm", (Object)simple);
            model.addAttribute("addressesResults", (Object)dom.getAddresses());
            mav.setViewName("domain");
            String action = "Update";
            DomainForm form = (DomainForm)session.getAttribute("domainForm");
            if (form == null) {
                form = new DomainForm();
                form.populate(dom);
            }
            model.addAttribute("domainForm", (Object)form);
            model.addAttribute("action", (Object)action);
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        }
        AddressForm addressForm2 = new AddressForm();
        addressForm2.setDisplayName("");
        addressForm2.setEndpoint("");
        addressForm2.setEmailAddress("");
        addressForm2.setType("");
        addressForm2.setId(Long.valueOf(Long.parseLong(strid)));
        model.addAttribute("addressForm", (Object)addressForm2);
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removeaddresses"}, method={RequestMethod.POST})
    public ModelAndView removeAddresses(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute SimpleForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        Collection convertedanchors;
        String owner;
        Domain dom;
        String strid;
        ModelAndView mav;
        block26: {
            mav = new ModelAndView();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Enter domain/removeaddresses");
            }
            if (simpleForm.getRemove() != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("the list of checkboxes checked or not is: " + simpleForm.getRemove().toString()));
            }
            strid = "" + simpleForm.getId();
            dom = this.configSvc.getDomain(Long.valueOf(Long.parseLong(strid)));
            String domname = "";
            if (dom != null) {
                domname = dom.getDomainName();
                if (this.configSvc != null && simpleForm != null && actionPath != null && (actionPath.equalsIgnoreCase("delete") || actionPath.equalsIgnoreCase("remove selected Addresses")) && simpleForm.getRemove() != null) {
                    int cnt = simpleForm.getRemove().size();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("removing addresses for domain with name: " + domname));
                    }
                    try {
                        block10: for (int x = 0; x < cnt; ++x) {
                            String removeid = (String)simpleForm.getRemove().get(x);
                            System.out.println("TRYING TO REMOVE ID: " + removeid);
                            Collection t = dom.getAddresses();
                            for (Address ts : t) {
                                if (ts.getId() != Long.parseLong(removeid)) continue;
                                dom.getAddresses().remove(ts);
                                if (this.configSvc == null) continue;
                                this.configSvc.removeAddress(ts.getEmailAddress());
                                dom = this.configSvc.getDomain(Long.valueOf(Long.parseLong(strid)));
                                continue block10;
                            }
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)" Trying to update the domain with removed addresses");
                        }
                        this.configSvc.updateDomain(dom);
                        dom = this.configSvc.getDomain(Long.valueOf(Long.parseLong(strid)));
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)" SUCCESS Trying to update the domain with removed addresses");
                        }
                        AddressForm addrform = new AddressForm();
                        addrform.setId(dom.getId());
                        model.addAttribute("addressForm", (Object)addrform);
                        owner = "";
                        owner = dom.getPostMasterEmail();
                        model.addAttribute("addressesResults", (Object)dom.getAddresses());
                        Collection certlist = null;
                        try {
                            certlist = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                        }
                        catch (ConfigurationServiceException e) {
                            e.printStackTrace();
                        }
                        Collection anchorlist = null;
                        try {
                            anchorlist = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        model.addAttribute("certificatesResults", (Object)certlist);
                        convertedanchors = this.convertAnchors(anchorlist);
                        model.addAttribute("anchorsResults", (Object)convertedanchors);
                    }
                    catch (ConfigurationServiceException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.error((Object)e);
                        }
                        break block26;
                    }
                }
                if (this.configSvc != null && (actionPath.equalsIgnoreCase("newaddress") || actionPath.equalsIgnoreCase("add address"))) {
                    String anEmail = simpleForm.getPostmasterEmail();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)(" Trying to add address: " + anEmail));
                    }
                    Address e = new Address();
                    e.setEmailAddress(anEmail);
                    dom.getAddresses().add(e);
                    simpleForm.setPostmasterEmail("");
                    try {
                        this.configSvc.updateDomain(dom);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)" After attempt to insert new email address ");
                        }
                    }
                    catch (ConfigurationServiceException ed) {
                        if (!this.log.isDebugEnabled()) break block26;
                        this.log.error((Object)ed);
                    }
                }
            }
        }
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        String action = "Update";
        model.addAttribute("action", (Object)action);
        DomainForm form = (DomainForm)session.getAttribute("domainForm");
        if (form == null) {
            form = new DomainForm();
            form.populate(dom);
        }
        model.addAttribute("domainForm", (Object)form);
        mav.setViewName("domain");
        owner = dom.getPostMasterEmail();
        try {
            if (owner != null && !owner.equalsIgnoreCase("")) {
                Collection certs = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                model.addAttribute("certificatesResults", (Object)certs);
                Collection anchors = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                convertedanchors = this.convertAnchors(anchors);
                model.addAttribute("anchorsResults", (Object)convertedanchors);
            }
            CertificateForm cform = new CertificateForm();
            cform.setId(dom.getId().longValue());
            model.addAttribute("certificateForm", (Object)cform);
            AnchorForm aform = new AnchorForm();
            aform.setId(dom.getId().longValue());
            model.addAttribute("anchorForm", (Object)aform);
        }
        catch (ConfigurationServiceException e1) {
            e1.printStackTrace();
        }
        model.addAttribute("simpleForm", (Object)simpleForm);
        strid = "" + simpleForm.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" the value of id of simpleform is: " + strid));
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/remove"}, method={RequestMethod.POST})
    public ModelAndView removeDomain(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute SimpleForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        SearchDomainForm form2;
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter domain/remove");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("the list of checkboxes checked or not is: " + simpleForm.getRemove().toString()));
        }
        if (this.configSvc != null) {
            int cnt = simpleForm.getRemove().size();
            for (int x = 0; x < cnt; ++x) {
                try {
                    String strid = (String)simpleForm.getRemove().get(x);
                    Long domainId = Long.parseLong(strid);
                    Domain dom = this.configSvc.getDomain(domainId);
                    if (dom == null) continue;
                    String owner = dom.getDomainName();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("removing domain with id: " + domainId));
                    }
                    this.configSvc.removeDomainById(domainId);
                    try {
                        Collection certs = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                        if (certs == null) continue;
                        ArrayList<Long> certtoberemovedlist = new ArrayList<Long>();
                        for (Anchor t : certs) {
                            certtoberemovedlist.add(t.getId());
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)" Trying to remove anchors from database");
                        }
                        this.configSvc.removeAnchors(certtoberemovedlist);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)" SUCCESS Trying to remove anchors");
                    }
                    catch (ConfigurationServiceException e) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.error((Object)e);
                    }
                    continue;
                }
                catch (ConfigurationServiceException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.error((Object)e);
                }
            }
        }
        model.addAttribute((Object)((form2 = (SearchDomainForm)session.getAttribute("searchDomainForm")) != null ? form2 : new SearchDomainForm()));
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        String domain = "%";
        ArrayList results = null;
        if (this.configSvc != null) {
            ArrayList domains = new ArrayList();
            Collection enabledDomains = this.configSvc.searchDomain(domain, EntityStatus.ENABLED);
            Collection disabledDomains = this.configSvc.searchDomain(domain, EntityStatus.DISABLED);
            Collection newDomains = this.configSvc.searchDomain(domain, EntityStatus.NEW);
            if (enabledDomains != null) {
                domains.addAll(enabledDomains);
            }
            if (disabledDomains != null) {
                domains.addAll(disabledDomains);
            }
            if (newDomains != null) {
                domains.addAll(newDomains);
            }
            results = domains;
        }
        model.addAttribute("searchResults", results);
        mav.setViewName("main");
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        mav.addObject("searchResults", results);
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView onSubmitAndView(Object command) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter onSubmit");
        }
        return new ModelAndView((View)new RedirectView("main"));
    }

    @RequestMapping(value={"/simpleForm"}, method={RequestMethod.GET})
    public void simpleForm(Model model) {
        model.addAttribute((Object)new SimpleForm());
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/updateBundleDirection"}, method={RequestMethod.POST})
    public ModelAndView updateBundleDirection(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, @RequestParam(required=true) String domainId, @RequestParam(required=true) String bundle, @RequestParam(required=true) String direction, @RequestParam(required=true) String directionValue, HttpSession session, Model model) {
        Long id = Long.parseLong(domainId);
        Collection bundles = null;
        try {
            bundles = this.configSvc.getTrustBundlesByDomain(id.longValue(), false);
        }
        catch (ConfigurationServiceException ex) {
            Logger.getLogger(DomainController.class.getName()).log(Level.SEVERE, null, ex);
        }
        for (TrustBundleDomainReltn bundleReltn : bundles) {
            if (bundleReltn.getId() != Long.parseLong(bundle)) continue;
            if (direction.toLowerCase().equals("incoming")) {
                if (Integer.parseInt(directionValue) == 1) {
                    bundleReltn.setIncoming(true);
                    continue;
                }
                bundleReltn.setIncoming(false);
                continue;
            }
            if (Integer.parseInt(directionValue) == 1) {
                bundleReltn.setOutgoing(true);
                continue;
            }
            bundleReltn.setOutgoing(false);
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("updateBundleDirection");
        return mav;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView viewDomain(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, @RequestParam(required=false) String id, HttpSession session, Model model) throws java.security.cert.CertificateException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter View Domain");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("domain");
        String action = "Add";
        DomainForm form = (DomainForm)session.getAttribute("domainForm");
        if (form == null) {
            form = new DomainForm();
        }
        model.addAttribute("domainForm", (Object)form);
        model.addAttribute("action", (Object)action);
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.addObject("action", (Object)action);
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        if (id != null && id.length() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Need to search for Domain ID: " + id));
            }
            Domain results = null;
            Long dId = Long.decode(id);
            model.addAttribute("domainId", (Object)dId);
            AddressForm addrform = new AddressForm();
            addrform.setId(dId);
            model.addAttribute("addressForm", (Object)addrform);
            CertificateForm cform = new CertificateForm();
            cform.setId(dId.longValue());
            AnchorForm aform = new AnchorForm();
            aform.setId(dId.longValue());
            model.addAttribute("certificateForm", (Object)cform);
            model.addAttribute("anchorForm", (Object)aform);
            if (this.configSvc != null) {
                results = this.configSvc.getDomain(dId);
                if (results != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Found a valid domain" + results.toString()));
                    }
                    Collection bundles = null;
                    try {
                        bundles = this.configSvc.getTrustBundlesByDomain(dId.longValue(), true);
                    }
                    catch (ConfigurationServiceException cse) {
                        // empty catch block
                    }
                    if (bundles != null) {
                        model.addAttribute("trustBundles", (Object)bundles);
                        HashMap bundleMap = new HashMap(bundles.size());
                        for (TrustBundleDomainReltn bundle : bundles) {
                            Collection tbAnchors = bundle.getTrustBundle().getTrustBundleAnchors();
                            HashMap<TrustBundleAnchor, String> anchorMap = new HashMap<TrustBundleAnchor, String>(tbAnchors.size());
                            int curAnchor = 0;
                            for (TrustBundleAnchor anchor : tbAnchors) {
                                try {
                                    X509Certificate cert = anchor.toCertificate();
                                    String subjectDN = ((Object)cert.getSubjectDN()).toString();
                                    anchorMap.put(anchor, subjectDN);
                                }
                                catch (CertificateException ex) {
                                    // empty catch block
                                }
                                ++curAnchor;
                            }
                            bundleMap.put(bundle.getTrustBundle().getBundleName(), anchorMap);
                        }
                        model.addAttribute("bundleMap", bundleMap);
                    }
                    form.populate(results);
                    action = "Update";
                    model.addAttribute("action", (Object)action);
                    model.addAttribute("addressesResults", (Object)results.getAddresses());
                    String owner = "";
                    owner = results.getDomainName();
                    model.addAttribute("addressesResults", (Object)results.getAddresses());
                    Collection certlist = null;
                    try {
                        certlist = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                    }
                    catch (ConfigurationServiceException e) {
                        e.printStackTrace();
                    }
                    Collection anchorlist = null;
                    try {
                        anchorlist = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                    }
                    catch (ConfigurationServiceException e) {
                        e.printStackTrace();
                    }
                    model.addAttribute("certificatesResults", (Object)certlist);
                    Collection convertedanchors = this.convertAnchors(anchorlist);
                    model.addAttribute("anchorsResults", (Object)convertedanchors);
                    SimpleForm simple = new SimpleForm();
                    simple.setId(dId.longValue());
                    model.addAttribute("simpleForm", (Object)simple);
                    mav.addObject("action", (Object)action);
                } else {
                    this.log.warn((Object)("Service returned a null Domain for a known key: " + dId));
                }
            } else {
                this.log.error((Object)"Web Service bean is null.  Configuration error detected.");
            }
            if (AjaxUtils.isAjaxRequest((String)requestedWith)) {
                model.addAttribute("message", (Object)"");
                model.addAttribute("ajaxRequest", (Object)true);
                model.addAttribute("action", (Object)action);
                return null;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/saveupdate"}, method={RequestMethod.POST})
    public ModelAndView saveDomain(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @RequestParam(value="submitType") String actionPath, @ModelAttribute(value="domainForm") DomainForm form, Model model) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entered saveDomain");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("The value of actionPath: " + actionPath));
        }
        ModelAndView mav = new ModelAndView();
        if (actionPath.equalsIgnoreCase("cancel")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to cancel from saveupdate");
            }
            return new ModelAndView("redirect:/config/main");
        }
        if (actionPath.equalsIgnoreCase("update") || actionPath.equalsIgnoreCase("add")) {
            HashMap<String, String> msgs = new HashMap<String, String>();
            mav.addObject("msgs", msgs);
            mav.setViewName("domain");
            try {
                block28: {
                    ArrayList result;
                    if (actionPath.equalsIgnoreCase("add")) {
                        this.configSvc.addDomain(form.getDomainFromForm());
                        result = new ArrayList(this.configSvc.searchDomain(form.getDomainName(), form.getStatus()));
                        if (form.getSelectedBundles() != "") {
                            String selBundle = form.getSelectedBundles();
                            String[] bundles = selBundle.split(",");
                            int bundleCount = bundles.length;
                            this.log.debug((Object)("# of bundles associated: " + bundleCount));
                            for (int i = 0; i < bundleCount; ++i) {
                                String[] bundleString = bundles[i].split("_");
                                if (bundleString[1].equals("both")) {
                                    this.configSvc.associateTrustBundleToDomain(((Domain)result.get(0)).getId().longValue(), (long)Integer.parseInt(bundleString[0]), true, true);
                                } else if (bundleString[1].equals("in")) {
                                    this.configSvc.associateTrustBundleToDomain(((Domain)result.get(0)).getId().longValue(), (long)Integer.parseInt(bundleString[0]), true, false);
                                } else if (bundleString[1].equals("out")) {
                                    this.configSvc.associateTrustBundleToDomain(((Domain)result.get(0)).getId().longValue(), (long)Integer.parseInt(bundleString[0]), false, true);
                                } else {
                                    this.configSvc.associateTrustBundleToDomain(((Domain)result.get(0)).getId().longValue(), (long)Integer.parseInt(bundleString[0]), false, false);
                                }
                                this.log.error((Object)("Added Bundle ID #" + bundles[i]));
                            }
                        }
                        if (result.size() > 0) {
                            form = new DomainForm();
                            form.populate((Domain)result.get(0));
                            msgs.put("msg", "domain.add.success");
                        }
                    } else if (actionPath.equalsIgnoreCase("update")) {
                        this.configSvc.updateDomain(form.getDomainFromForm());
                        result = new ArrayList(this.configSvc.searchDomain(form.getDomainName(), form.getStatus()));
                        if (result.size() > 0) {
                            form = new DomainForm();
                            form.populate((Domain)result.get(0));
                        }
                        msgs.put("msg", "domain.update.success");
                    }
                    AddressForm addrform = new AddressForm();
                    addrform.setId(form.getDomainFromForm().getId());
                    model.addAttribute("domainForm", (Object)form);
                    model.addAttribute("addressForm", (Object)addrform);
                    CertificateForm cform = new CertificateForm();
                    cform.setId(form.getDomainFromForm().getId().longValue());
                    AnchorForm aform = new AnchorForm();
                    aform.setId(form.getDomainFromForm().getId().longValue());
                    model.addAttribute("certificateForm", (Object)cform);
                    model.addAttribute("anchorForm", (Object)aform);
                    SimpleForm simple = new SimpleForm();
                    simple.setId(form.getDomainFromForm().getId().longValue());
                    model.addAttribute("simpleForm", (Object)simple);
                    String owner = form.getDomainFromForm().getPostMasterEmail();
                    try {
                        if (owner == null || owner.equalsIgnoreCase("")) break block28;
                        Collection certlist = null;
                        try {
                            certlist = this.configSvc.getCertificatesForOwner(owner, CertificateGetOptions.DEFAULT);
                            model.addAttribute("certificatesResults", (Object)certlist);
                        }
                        catch (ConfigurationServiceException e) {
                            e.printStackTrace();
                        }
                        Collection anchorlist = null;
                        anchorlist = this.configSvc.getAnchorsForOwner(owner, CertificateGetOptions.DEFAULT);
                        Collection convertedanchors = this.convertAnchors(anchorlist);
                        model.addAttribute("anchorsResults", (Object)convertedanchors);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                model.addAttribute("addressesResults", (Object)form.getDomainFromForm().getAddresses());
                model.addAttribute("action", (Object)"update");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Stored domain: " + form.getDomainFromForm().toString()));
                }
            }
            catch (ConfigurationServiceException e) {
                this.log.error((Object)e);
                msgs.put("domainService", "domainService.add.error");
            }
            catch (Exception ed) {
                this.log.error((Object)ed);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return new ModelAndView("redirect:/config/domain?id=" + form.getId());
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }

    public void setConfigSvc(ConfigurationService service) {
        this.configSvc = service;
    }

    public CertContainer toCertContainer(byte[] data) throws Exception {
        CertContainer certContainer = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", Certificate.getJCEProviderName());
                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, "".toCharArray());
                    if (key != null && key instanceof PrivateKey) {
                        certContainer = new CertContainer(cert, key);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (certContainer == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, null);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new ConfigurationServiceException("Data cannot be converted to a valid X.509 Certificate", (Throwable)e);
        }
        return certContainer;
    }

    private String getTrustedEntityName(X500Principal prin) {
        HashMap<String, String> oidMap = new HashMap<String, String>();
        oidMap.put("1.2.840.113549.1.9.1", "EMAILADDRESS");
        String prinName = prin.getName("RFC1779", oidMap);
        String searchString = "CN=";
        int index = prinName.indexOf(searchString);
        if (index == -1 && (index = prinName.indexOf(searchString = "EMAILADDRESS=")) == -1) {
            return "";
        }
        int endIndex = prinName.indexOf(",", index);
        String address = endIndex > -1 ? prinName.substring(index + searchString.length(), endIndex) : prinName.substring(index + searchString.length());
        return address;
    }
}

