/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.IOException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.security.cert.CertificateEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.common.util.StringUtils;
import org.nhind.config.rest.CertPolicyService;
import org.nhind.config.rest.CertificateService;
import org.nhind.config.rest.DNSService;
import org.nhind.config.rest.DomainService;
import org.nhind.config.rest.SettingService;
import org.nhind.config.rest.TrustBundleService;
import org.nhindirect.common.crypto.MutableKeyStoreProtectionManager;
import org.nhindirect.common.crypto.WrappableKeyProtectionManager;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.Certificate;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.config.model.EntityStatus;
import org.nhindirect.config.model.TrustBundle;
import org.nhindirect.config.model.TrustBundleAnchor;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.ui.SrvRecord;
import org.nhindirect.config.ui.flash.FlashMap;
import org.nhindirect.config.ui.form.AddressForm;
import org.nhindirect.config.ui.form.AnchorForm;
import org.nhindirect.config.ui.form.BundleForm;
import org.nhindirect.config.ui.form.CertificateForm;
import org.nhindirect.config.ui.form.DNSEntryForm;
import org.nhindirect.config.ui.form.DNSType;
import org.nhindirect.config.ui.form.DomainForm;
import org.nhindirect.config.ui.form.PolicyForm;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SettingsForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.nhindirect.config.ui.util.PrivateKeyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/main"})
public class MainController {
    private final Log log = LogFactory.getLog(this.getClass());
    private TrustBundleService bundleService;
    private CertificateService certService;
    private DNSService dnsService;
    private SettingService settingsService;
    private CertPolicyService policyService;
    private DomainService domainService;
    @Autowired(required=false)
    private WrappableKeyProtectionManager keyManager;

    @Inject
    public void setTrustBundleService(TrustBundleService bundleService) {
        this.bundleService = bundleService;
    }

    @Inject
    public void setCertificateService(CertificateService certService) {
        this.certService = certService;
    }

    @Inject
    public void setDNSService(DNSService dnsService) {
        this.dnsService = dnsService;
    }

    @Inject
    public void setSettingsService(SettingService settingsService) {
        this.settingsService = settingsService;
    }

    @Inject
    public void setCertPolicyService(CertPolicyService policyService) {
        this.policyService = policyService;
    }

    @Inject
    public void setDomainService(DomainService domainService) {
        this.domainService = domainService;
    }

    public MainController() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"MainController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public ModelAndView search(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute SimpleForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath, @RequestParam(value="domainName", required=false) String searchDomainName, @RequestParam(value="status", required=false) org.nhindirect.config.store.EntityStatus searchStatus) {
        this.log.error((Object)"Hit Search Controller");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter search");
        }
        String message = "Search complete";
        ModelAndView mav = new ModelAndView();
        if (actionPath.equalsIgnoreCase("gotosettings") || actionPath.equalsIgnoreCase("settings")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to go to the settings page");
            }
            String action = "add";
            model.addAttribute("action", (Object)action);
            mav.setViewName("settings");
            mav.addObject("actionPath", (Object)"gotosettings");
            SettingsForm form = (SettingsForm)session.getAttribute("settingsForm");
            if (form == null) {
                form = new SettingsForm();
            }
            model.addAttribute("settingsForm", (Object)form);
            ArrayList results = null;
            if (this.settingsService != null) {
                try {
                    Collection settings = this.settingsService.getSettings();
                    results = settings != null ? new ArrayList(settings) : new ArrayList();
                }
                catch (ServiceException e) {
                    // empty catch block
                }
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            model.addAttribute("settingsResults", results);
        } else if (actionPath.equalsIgnoreCase("gotocertificates") || actionPath.equalsIgnoreCase("certificates")) {
            this.log.error((Object)"trying to go to the certificates page");
            String action = "Update";
            model.addAttribute("action", (Object)"Update");
            mav.setViewName("certificates");
            mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
            mav.addObject("actionPath", (Object)"gotocertificates");
            CertificateForm form = (CertificateForm)session.getAttribute("certificateForm");
            if (form == null) {
                form = new CertificateForm();
            }
            model.addAttribute("certificateForm", (Object)form);
            ArrayList results = null;
            if (this.certService != null) {
                try {
                    Collection certs = this.certService.getAllCertificates();
                    if (certs != null) {
                        if (this.keyManager != null && this.keyManager instanceof MutableKeyStoreProtectionManager) {
                            KeyStore keyStore = ((MutableKeyStoreProtectionManager)this.keyManager).getKS();
                            for (Certificate cert : certs) {
                                if (cert.isPrivateKey()) continue;
                                try {
                                    PrivateKey privKey;
                                    X509Certificate checkCert = CertUtils.toX509Certificate((byte[])cert.getData());
                                    String alias = keyStore.getCertificateAlias(checkCert);
                                    if (StringUtils.isEmpty((String)alias) || (privKey = (PrivateKey)keyStore.getKey(alias, "".toCharArray())) == null) continue;
                                    cert.setPrivateKey(true);
                                }
                                catch (Exception e) {}
                            }
                        }
                        results = new ArrayList(certs);
                    } else {
                        results = new ArrayList();
                    }
                }
                catch (ServiceException e) {
                    // empty catch block
                }
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            model.addAttribute("certificatesResults", results);
        } else if (actionPath.equalsIgnoreCase("newdomain") || actionPath.equalsIgnoreCase("new domain")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to go to the new domain page");
            }
            HashMap msgs = new HashMap();
            mav.addObject("msgs", msgs);
            model.addAttribute("simpleForm", (Object)new SimpleForm());
            AddressForm addrform = new AddressForm();
            addrform.setId(Long.valueOf(0L));
            model.addAttribute("addressForm", (Object)addrform);
            CertificateForm cform = new CertificateForm();
            AnchorForm aform = new AnchorForm();
            aform.setId(0L);
            model.addAttribute("certificateForm", (Object)cform);
            model.addAttribute("anchorForm", (Object)aform);
            String action = "Add";
            DomainForm form = (DomainForm)session.getAttribute("domainForm");
            if (form == null) {
                form = new DomainForm();
            }
            model.addAttribute("domainForm", (Object)form);
            model.addAttribute("action", (Object)"Add");
            mav.setViewName("domain");
            mav.addObject("actionPath", (Object)"newdomain");
            mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
            mav.addObject("statusList", (Object)org.nhindirect.config.store.EntityStatus.getEntityStatusList());
        } else if (actionPath.equalsIgnoreCase("gotodns") || actionPath.equalsIgnoreCase("DNS Entries")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Entering DNS Management page");
            }
            HashMap msgs = new HashMap();
            mav.addObject("msgs", msgs);
            String action = "Update";
            model.addAttribute("action", (Object)"Update");
            Collection arecords = null;
            arecords = this.getDnsRecords(DNSType.A.getValue());
            model.addAttribute("dnsARecordResults", (Object)arecords);
            Collection a4records = null;
            a4records = this.getDnsRecords(DNSType.AAAA.getValue());
            model.addAttribute("dnsA4RecordResults", (Object)a4records);
            Collection crecords = null;
            crecords = this.getDnsRecords(DNSType.CNAME.getValue());
            model.addAttribute("dnsCnameRecordResults", (Object)crecords);
            Collection certrecords = null;
            certrecords = this.getDnsRecords(DNSType.CERT.getValue());
            model.addAttribute("dnsCertRecordResults", (Object)certrecords);
            Collection mxrecords = null;
            mxrecords = this.getDnsRecords(DNSType.MX.getValue());
            model.addAttribute("dnsMxRecordResults", (Object)mxrecords);
            Collection srvrecords = null;
            srvrecords = this.getDnsRecords(DNSType.SRV.getValue());
            model.addAttribute("dnsSrvRecordResults", (Object)srvrecords);
            mav.setViewName("dns");
            mav.addObject("actionPath", (Object)"gotodns");
            model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
            model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
            model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
            model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
            model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
            model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
            this.refreshModelFromService(model);
            model.addAttribute("simpleForm", (Object)new SimpleForm());
        } else if (actionPath.equalsIgnoreCase("ManagePolicies") || actionPath.equalsIgnoreCase("Policies")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to go to the Policies page");
            }
            String action = "Update";
            model.addAttribute("action", (Object)"Update");
            mav.setViewName("policies");
            mav.addObject("actionPath", (Object)"gotopolicies");
            PolicyForm form = (PolicyForm)session.getAttribute("policyForm");
            if (form == null) {
                form = new PolicyForm();
            }
            model.addAttribute("policyForm", (Object)form);
            Collection policies = null;
            try {
                policies = this.policyService.getPolicies();
            }
            catch (Exception e) {
                System.out.println("Failed to lookup policies: " + e.getMessage());
            }
            if (policies != null) {
                model.addAttribute("policies", (Object)policies);
            } else {
                model.addAttribute("policies", (Object)"");
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
        } else if (actionPath.equalsIgnoreCase("ManageTrustBundles") || actionPath.equalsIgnoreCase("Bundles")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to go to the Bundles page");
            }
            String action = "Update";
            model.addAttribute("action", (Object)"Update");
            mav.setViewName("bundles");
            mav.addObject("actionPath", (Object)"gotobundles");
            BundleForm form = (BundleForm)session.getAttribute("BundleForm");
            if (form == null) {
                form = new BundleForm();
            }
            model.addAttribute("bundleForm", (Object)form);
            if (this.bundleService != null) {
                try {
                    List<TrustBundle> trustBundles = this.bundleService.getTrustBundles(true);
                    if (trustBundles == null) {
                        trustBundles = Collections.emptyList();
                    }
                    HashMap bundleMap = new HashMap(trustBundles.size());
                    for (TrustBundle bundle : trustBundles) {
                        Collection tbAnchors = bundle.getTrustBundleAnchors();
                        HashMap<TrustBundleAnchor, String> anchorMap = new HashMap<TrustBundleAnchor, String>(tbAnchors.size());
                        for (TrustBundleAnchor anchor : tbAnchors) {
                            X509Certificate cert = anchor.getAsX509Certificate();
                            String subjectDN = cert.getSubjectDN().toString();
                            anchorMap.put(anchor, subjectDN);
                        }
                        bundleMap.put(bundle.getBundleName(), anchorMap);
                    }
                    model.addAttribute("bundleMap", bundleMap);
                    model.addAttribute("trustBundles", trustBundles);
                }
                catch (ServiceException e1) {
                    e1.printStackTrace();
                }
            }
            model.addAttribute("simpleForm", (Object)new SimpleForm());
        } else {
            SearchDomainForm form = (SearchDomainForm)session.getAttribute("searchDomainForm");
            if (form == null) {
                form = new SearchDomainForm();
            }
            model.addAttribute((Object)form);
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            String domain = !searchDomainName.isEmpty() ? searchDomainName : "%";
            mav.addObject("searchTerm", (Object)searchDomainName);
            org.nhindirect.config.store.EntityStatus status = searchStatus;
            ArrayList results = null;
            if (this.domainService != null) {
                try {
                    Collection domains = this.domainService.searchDomains(domain, EntityStatus.valueOf((String)status.toString()));
                    results = domains != null ? new ArrayList(domains) : new ArrayList();
                }
                catch (ServiceException e1) {
                    e1.printStackTrace();
                }
            }
            if (AjaxUtils.isAjaxRequest((String)requestedWith)) {
                model.addAttribute("message", (Object)new FlashMap.Message(FlashMap.MessageType.success, message));
                model.addAttribute("ajaxRequest", (Object)true);
                model.addAttribute("searchResults", results);
                return null;
            }
            mav.setViewName("main");
            mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
            mav.addObject("statusList", (Object)org.nhindirect.config.store.EntityStatus.getEntityStatusList());
            mav.addObject("searchResults", results);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    private Collection<DNSRecord> getDnsRecords(int type) {
        Collection arecords = null;
        try {
            arecords = this.dnsService.getDNSRecord(type, "");
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return arecords;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView display(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute SimpleForm simpleForm, Model model) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        ModelAndView mav = new ModelAndView();
        SearchDomainForm form = (SearchDomainForm)session.getAttribute("searchDomainForm");
        model.addAttribute((Object)(form != null ? form : new SearchDomainForm()));
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.setViewName("main");
        mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
        mav.addObject("statusList", (Object)org.nhindirect.config.store.EntityStatus.getEntityStatusList());
        mav.addObject("searchTerm", (Object)"");
        String domain = "%";
        ArrayList results = null;
        if (this.domainService != null) {
            try {
                Collection enabledDomains = this.domainService.searchDomains(domain, EntityStatus.ENABLED);
                Collection disabledDomains = this.domainService.searchDomains(domain, EntityStatus.DISABLED);
                Collection domains = this.domainService.searchDomains(domain, EntityStatus.NEW);
                if (domains.isEmpty()) {
                    domains = new ArrayList();
                }
                if (enabledDomains != null && !enabledDomains.isEmpty()) {
                    this.log.error((Object)enabledDomains);
                    if (domains.isEmpty()) {
                        domains = enabledDomains;
                    } else {
                        domains.addAll(enabledDomains);
                    }
                }
                if (disabledDomains != null && !disabledDomains.isEmpty()) {
                    if (domains.isEmpty()) {
                        domains = disabledDomains;
                    } else {
                        domains.addAll(disabledDomains);
                    }
                }
                results = !domains.isEmpty() ? new ArrayList(domains) : new ArrayList();
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
        model.addAttribute("searchResults", results);
        mav.setViewName("main");
        mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
        mav.addObject("statusList", (Object)org.nhindirect.config.store.EntityStatus.getEntityStatusList());
        mav.addObject("searchResults", results);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/new"}, method={RequestMethod.GET})
    public ModelAndView newDomain(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, Model model) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName("domain");
        model.addAttribute((Object)new DomainForm());
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
        mav.addObject("statusList", (Object)org.nhindirect.config.store.EntityStatus.getEntityStatusList());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit");
        }
        return mav;
    }

    public void refreshModelFromService(Model model) {
        Collection arecords = null;
        arecords = this.getDnsRecords(DNSType.A.getValue());
        ArrayList<DNSEntryForm> aform = new ArrayList<DNSEntryForm>();
        if (arecords != null) {
            for (DNSRecord t : arecords) {
                try {
                    ARecord newrec = (ARecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getAddress());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    aform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsARecordResults", aform);
        Collection a4records = null;
        a4records = this.getDnsRecords(DNSType.AAAA.getValue());
        ArrayList<DNSEntryForm> a4form = new ArrayList<DNSEntryForm>();
        if (a4records != null) {
            for (DNSRecord t : a4records) {
                try {
                    AAAARecord newrec = (AAAARecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getAddress());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    a4form.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsA4RecordResults", a4form);
        Collection crecords = null;
        crecords = this.getDnsRecords(DNSType.CNAME.getValue());
        ArrayList<DNSEntryForm> cform = new ArrayList<DNSEntryForm>();
        if (crecords != null) {
            for (DNSRecord t : crecords) {
                try {
                    CNAMERecord newrec = (CNAMERecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getTarget());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    cform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsCnameRecordResults", cform);
        Collection mxrecords = null;
        mxrecords = this.getDnsRecords(DNSType.MX.getValue());
        ArrayList<DNSEntryForm> mxform = new ArrayList<DNSEntryForm>();
        if (mxrecords != null) {
            for (DNSRecord t : mxrecords) {
                try {
                    MXRecord newrec = (MXRecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setPriority(newrec.getPriority());
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getTarget());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    mxform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsMxRecordResults", mxform);
        Collection certrecords = null;
        certrecords = this.getDnsRecords(DNSType.CERT.getValue());
        ArrayList<SrvRecord> form = new ArrayList<SrvRecord>();
        if (certrecords != null) {
            for (DNSRecord t : certrecords) {
                SrvRecord srv = new SrvRecord();
                srv.setCreateTime(t.getCreateTime());
                srv.setData(t.getData());
                srv.setDclass(t.getDclass());
                srv.setId(t.getId());
                srv.setName(t.getName());
                srv.setTtl(t.getTtl());
                srv.setType(t.getType());
                srv.setThumb("");
                try {
                    CertUtils.CertContainer cont;
                    CERTRecord newrec = (CERTRecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    String thumb = "";
                    byte[] certData = newrec.getCert();
                    if (certData != null && (cont = CertUtils.toCertContainer((byte[])certData)) != null && cont.getCert() != null) {
                        Certificate cert2 = new Certificate();
                        cert2.setData(certData);
                        thumb = MainController.getThumbPrint((X509Certificate)cont.getCert());
                        srv.setThumb(thumb);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                form.add(srv);
            }
        }
        model.addAttribute("dnsCertRecordResults", form);
        Collection srvrecords = null;
        srvrecords = this.getDnsRecords(DNSType.SRV.getValue());
        ArrayList<SrvRecord> form2 = new ArrayList<SrvRecord>();
        if (srvrecords != null) {
            for (DNSRecord t : srvrecords) {
                SrvRecord srv = new SrvRecord();
                try {
                    SRVRecord srv4 = (SRVRecord)SRVRecord.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    srv.setCreateTime(t.getCreateTime());
                    srv.setData(t.getData());
                    srv.setDclass(t.getDclass());
                    srv.setId(t.getId());
                    srv.setName(t.getName());
                    String name = t.getName();
                    int firstpos = name.indexOf("_");
                    if (firstpos == 0) {
                        int secondpos = name.indexOf("._");
                        int thirdpos = name.indexOf(".", secondpos + 2);
                        String service_ = name.substring(firstpos + 1, secondpos);
                        srv.setService(service_);
                        String protocol_ = name.substring(secondpos + 2, thirdpos);
                        srv.setProtocol(protocol_);
                        int last2pos = name.indexOf(".", thirdpos);
                        String name_ = name.substring(last2pos + 1, name.length());
                        srv.setName(name_);
                    }
                    srv.setTtl(t.getTtl());
                    srv.setType(t.getType());
                    srv.setPort(srv4.getPort());
                    srv.setWeight(srv4.getWeight());
                    srv.setPriority("" + srv4.getPriority());
                    srv.setTarget("" + srv4.getTarget().toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                form2.add(srv);
            }
        }
        model.addAttribute("dnsSrvRecordResults", form2);
        Collection soarecords = null;
        soarecords = this.getDnsRecords(DNSType.SOA.getValue());
        ArrayList<DNSEntryForm> soaform = new ArrayList<DNSEntryForm>();
        if (soarecords != null) {
            for (DNSRecord t : soarecords) {
                try {
                    SOARecord newrec = (SOARecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setAdmin("" + newrec.getAdmin());
                    tmp.setExpire(newrec.getExpire());
                    tmp.setMinimum(newrec.getMinimum());
                    tmp.setRefresh(newrec.getRefresh());
                    tmp.setRetry(newrec.getRetry());
                    tmp.setSerial(newrec.getSerial());
                    tmp.setDest("" + newrec.getHost());
                    tmp.setDomain("" + newrec.getHost());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    soaform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsSOARecordResults", soaform);
        Collection nsrecords = null;
        nsrecords = this.getDnsRecords(DNSType.NS.getValue());
        ArrayList<DNSEntryForm> nsform = new ArrayList<DNSEntryForm>();
        if (nsrecords != null) {
            for (DNSRecord t : nsrecords) {
                try {
                    NSRecord newrec = (NSRecord)Record.newRecord((Name)Name.fromString((String)t.getName()), (int)t.getType(), (int)t.getDclass(), (long)t.getTtl(), (byte[])t.getData());
                    DNSEntryForm tmp = new DNSEntryForm();
                    tmp.setId(Long.valueOf(t.getId()));
                    tmp.setDest("" + newrec.getTarget());
                    tmp.setTtl(newrec.getTTL());
                    tmp.setName("" + newrec.getName());
                    nsform.add(tmp);
                }
                catch (TextParseException e) {
                    e.printStackTrace();
                }
            }
        }
        model.addAttribute("dnsNSRecordResults", nsform);
        model.addAttribute("NSdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SoadnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("AAdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("MXdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("CertdnsForm", (Object)new DNSEntryForm());
        model.addAttribute("SrvdnsForm", (Object)new DNSEntryForm());
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }

    public static String getThumbPrint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = null;
        byte[] digest = null;
        try {
            der = cert.getEncoded();
            md.update(der);
            digest = md.digest();
        }
        catch (java.security.cert.CertificateEncodingException e) {
            e.printStackTrace();
        }
        return MainController.hexify(digest);
    }

    public static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }
}

