/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.nhind.config.PolicyLexicon;
import org.nhind.config.rest.CertPolicyService;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.config.ui.UploadedFile;
import org.nhindirect.config.ui.form.PolicyForm;
import org.nhindirect.policy.PolicyLexiconParser;
import org.nhindirect.policy.PolicyLexiconParserFactory;
import org.nhindirect.policy.PolicyParseException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/policies"})
public class PoliciesController {
    private final Log log = LogFactory.getLog(this.getClass());
    private CertPolicyService policyService;

    @Inject
    public void setCertPolicyService(CertPolicyService policyService) {
        this.policyService = policyService;
    }

    public PoliciesController() {
        if (this.log.isDebugEnabled()) {
            this.log.error((Object)"PoliciesController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addPolicy"}, method={RequestMethod.POST})
    @ResponseBody
    public String addPolicy(@RequestParam(value="id") String id, @RequestParam(value="policyName") String policyName, @RequestParam(value="policyContent") String policyContent, @RequestParam(value="policyLexicon") String policyLexicon) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Adding New Policy");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Beginning to add new policy");
        }
        try {
            URL configURL = new URL("http://localhost:8081/config-service/ConfigurationService");
        }
        catch (MalformedURLException ue) {
            // empty catch block
        }
        CertPolicy newPolicy = new CertPolicy();
        newPolicy.setPolicyName(policyName);
        String lexiconName = policyLexicon;
        if (lexiconName.equalsIgnoreCase("XML")) {
            newPolicy.setLexicon(org.nhindirect.policy.PolicyLexicon.XML);
        } else if (lexiconName.equalsIgnoreCase("JAVA_SER")) {
            newPolicy.setLexicon(org.nhindirect.policy.PolicyLexicon.JAVA_SER);
        } else if (lexiconName.equalsIgnoreCase("SIMPLE_TEXT_V1")) {
            newPolicy.setLexicon(org.nhindirect.policy.PolicyLexicon.SIMPLE_TEXT_V1);
        }
        newPolicy.setPolicyData(policyContent.getBytes());
        this.log.error((Object)newPolicy);
        try {
            this.policyService.addPolicy(newPolicy);
        }
        catch (ServiceException cse) {
            cse.printStackTrace();
        }
        return "test";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removePolicies"}, method={RequestMethod.POST})
    public ModelAndView removePolicies(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute PolicyForm policyForm, Model model) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter remove policies method");
        }
        if (policyForm.getPoliciesSelected() != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Policies marked for removal: " + policyForm.getPoliciesSelected().toString()));
        }
        if (this.policyService != null && policyForm != null && policyForm.getPoliciesSelected() != null) {
            int policyCount = policyForm.getPoliciesSelected().size();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Removing Policies");
            }
            for (int i = 0; i < policyCount; ++i) {
                String policyName = (String)policyForm.getPoliciesSelected().get(i);
                try {
                    this.policyService.deletePolicy(policyName);
                    continue;
                }
                catch (ServiceException cse) {
                    this.log.error((Object)"Problem removing policies");
                }
            }
        }
        return new ModelAndView("redirect:/config/main/search?domainName=&submitType=ManagePolicies");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/updatePolicyForm"}, method={RequestMethod.GET})
    public ModelAndView updatePolicyForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, @RequestParam(value="policyName") String policyName, HttpSession session, @ModelAttribute PolicyForm policyForm, Model model) {
        CertPolicy policy = null;
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Enter policies update form for policy #" + policyName));
        }
        try {
            policy = this.policyService.getPolicyByName(policyName);
        }
        catch (ServiceException cse) {
            cse.printStackTrace();
            return new ModelAndView("redirect:/");
        }
        PolicyForm pform = new PolicyForm();
        pform.setPolicyName(policy.getPolicyName());
        pform.setPolicyLexicon(policy.getLexicon());
        try {
            pform.setPolicyContent(new String(policy.getPolicyData(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ie) {
            ie.printStackTrace();
        }
        model.addAttribute("sessionId", (Object)session.getId());
        model.addAttribute("policyForm", (Object)pform);
        mav.setViewName("updatePolicyForm");
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/updatePolicy"}, method={RequestMethod.POST})
    @ResponseBody
    public String updatePolicy(@RequestParam(value="id") String id, @RequestParam(value="policyContent") String policyContent, @RequestParam(value="policyLexicon") String policyLexicon, @RequestParam(value="policyName") String policyName) {
        String jsonResponse = "";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Enter update policy #" + id));
        }
        this.log.error((Object)policyName);
        PolicyLexicon lex = null;
        if (policyLexicon.isEmpty()) {
            lex = PolicyLexicon.SIMPLE_TEXT_V1;
        } else {
            try {
                lex = PolicyLexicon.fromString((String)policyLexicon);
            }
            catch (Exception e) {
                this.log.error((Object)"Invalid lexicon name.");
            }
        }
        if (lex.equals((Object)PolicyLexicon.JAVA_SER)) {
            org.nhindirect.policy.PolicyLexicon parseLexicon = org.nhindirect.policy.PolicyLexicon.JAVA_SER;
        } else if (lex.equals((Object)PolicyLexicon.SIMPLE_TEXT_V1)) {
            org.nhindirect.policy.PolicyLexicon parseLexicon = org.nhindirect.policy.PolicyLexicon.SIMPLE_TEXT_V1;
        } else {
            org.nhindirect.policy.PolicyLexicon parseLexicon = org.nhindirect.policy.PolicyLexicon.XML;
        }
        byte[] policyContentByteArray = policyContent.getBytes();
        return jsonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/checkLexiconFile"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String checkLexiconFile(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpServletResponse response, Object command, @RequestHeader(value="lexicon", required=false) String lexicon, MultipartHttpServletRequest request) throws FileUploadException, IOException, Exception {
        String jsonResponse = "";
        String uploadToString = "";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Checking uploaded lexicon file for format and validation");
        }
        UploadedFile ufile = new UploadedFile();
        Iterator itr = request.getFileNames();
        MultipartFile mpf = request.getFile((String)itr.next());
        try {
            ufile.length = mpf.getBytes().length;
            ufile.bytes = mpf.getBytes();
            ufile.type = mpf.getContentType();
            ufile.name = mpf.getOriginalFilename();
        }
        catch (IOException e) {
            // empty catch block
        }
        uploadToString = new String(ufile.bytes);
        uploadToString = JSONObject.escape((String)uploadToString);
        lexicon = request.getParameter("lexicon");
        PolicyLexicon lex = null;
        if (lexicon.isEmpty()) {
            lex = PolicyLexicon.SIMPLE_TEXT_V1;
        } else {
            try {
                lex = PolicyLexicon.fromString((String)lexicon);
            }
            catch (Exception e) {
                this.log.error((Object)"Invalid lexicon name.");
            }
        }
        org.nhindirect.policy.PolicyLexicon parseLexicon = lex.equals((Object)PolicyLexicon.JAVA_SER) ? org.nhindirect.policy.PolicyLexicon.JAVA_SER : (lex.equals((Object)PolicyLexicon.SIMPLE_TEXT_V1) ? org.nhindirect.policy.PolicyLexicon.SIMPLE_TEXT_V1 : org.nhindirect.policy.PolicyLexicon.XML);
        ByteArrayInputStream inStr = null;
        try {
            inStr = new ByteArrayInputStream(ufile.bytes);
            PolicyLexiconParser parser = PolicyLexiconParserFactory.getInstance((org.nhindirect.policy.PolicyLexicon)parseLexicon);
            parser.parse((InputStream)inStr);
        }
        catch (PolicyParseException e) {
            try {
                this.log.error((Object)("Syntax error in policy file  : " + e.getMessage()));
                jsonResponse = "{\"Status\":\"File was not a valid file.\",\"Content\":\"" + uploadToString + "\"}";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStr);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inStr);
        }
        IOUtils.closeQuietly((InputStream)inStr);
        if (jsonResponse.isEmpty()) {
            jsonResponse = "{\"Status\":\"Success\",\"Content\":\"" + uploadToString + "\"}";
        }
        return jsonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/checkPolicyContent"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String checkPolicyContent(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpServletResponse response, HttpServletRequest request, Object command) throws Exception {
        String jsonResponse = "";
        String content = request.getParameter("content");
        String lexicon = "";
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Checking policy content for format and validation");
        }
        lexicon = request.getParameter("lexicon");
        PolicyLexicon lex = null;
        if (lexicon.isEmpty()) {
            lex = PolicyLexicon.SIMPLE_TEXT_V1;
        } else {
            try {
                lex = PolicyLexicon.fromString((String)lexicon);
            }
            catch (Exception e) {
                this.log.error((Object)"Invalid lexicon name.");
            }
        }
        org.nhindirect.policy.PolicyLexicon parseLexicon = lex.equals((Object)PolicyLexicon.JAVA_SER) ? org.nhindirect.policy.PolicyLexicon.JAVA_SER : (lex.equals((Object)PolicyLexicon.SIMPLE_TEXT_V1) ? org.nhindirect.policy.PolicyLexicon.SIMPLE_TEXT_V1 : org.nhindirect.policy.PolicyLexicon.XML);
        ByteArrayInputStream inStr = null;
        try {
            inStr = new ByteArrayInputStream(content.getBytes());
            PolicyLexiconParser parser = PolicyLexiconParserFactory.getInstance((org.nhindirect.policy.PolicyLexicon)parseLexicon);
            parser.parse((InputStream)inStr);
        }
        catch (PolicyParseException e) {
            try {
                this.log.error((Object)("Syntax error in policy content  : " + e.getMessage()));
                jsonResponse = "{\"Status\":\"Policy content was not valid.\",\"Error\":\"" + e.getMessage() + "\"}";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStr);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inStr);
        }
        IOUtils.closeQuietly((InputStream)inStr);
        if (jsonResponse.isEmpty()) {
            jsonResponse = "{\"Status\":\"Success\"}";
        }
        return jsonResponse;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/newPolicyForm"}, method={RequestMethod.GET})
    public ModelAndView newPolicyForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute PolicyForm policyForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter policies");
        }
        PolicyForm pform = new PolicyForm();
        pform.setId(0L);
        model.addAttribute("policyForm", (Object)pform);
        model.addAttribute("lexiconNames", (Object)pform.getLexiconNames());
        mav.setViewName("newPolicyForm");
        return mav;
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }
}

