/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.spring.config;

import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.PKCS11Credential;
import org.nhindirect.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.nhindirect.common.crypto.impl.BootstrappedPKCS11Credential;
import org.nhindirect.common.crypto.impl.StaticCachedPKCS11TokenKeyStoreProtectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KeyStoreConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreConfig.class);
    @Value(value="${direct.config.keystore.keyStorePin:som3randomp!n}")
    private String keyStorePin;
    @Value(value="${direct.config.keystore.keyStoreType:Luna}")
    private String keyStoreType;
    @Value(value="${direct.config.keystore.keyStoreSourceAsString:slot:0}")
    private String keyStoreSourceAsString;
    @Value(value="${direct.config.keystore.keyStoreProviderName:com.safenetinc.luna.provider.LunaProvider}")
    private String keyStoreProviderName;
    @Value(value="${direct.config.keystore.keyStorePassPhraseAlias:keyStorePassPhrase}")
    private String keyStorePassPhraseAlias;
    @Value(value="${direct.config.keystore.privateKeyPassPhraseAlias:privateKeyPassPhrase}")
    private String privateKeyPassPhraseAlias;
    @Value(value="${direct.config.keystore.initOnStart:true}")
    private String initOnStart;
    @Value(value="${direct.config.keystore.keyStorePassPhrase:H1TBr0s!}")
    private String keyStorePassPhrase;
    @Value(value="${direct.config.keystore.privateKeyPassPhrase:H1TCh1ckS!}")
    private String privateKeyPassPhrase;

    @Bean
    @ConditionalOnProperty(name={"direct.config.keystore.hsmpresent"}, havingValue="true")
    public KeyStoreProtectionManager hsmKeyStoreProtectionManager() {
        LOGGER.info("HSM configured.  Attempting to connect to device.");
        try {
            BootstrappedPKCS11Credential cred = new BootstrappedPKCS11Credential(this.keyStorePin);
            StaticCachedPKCS11TokenKeyStoreProtectionManager mgr = new StaticCachedPKCS11TokenKeyStoreProtectionManager();
            mgr.setCredential((PKCS11Credential)cred);
            mgr.setKeyStoreType(this.keyStoreType);
            mgr.setKeyStoreSourceAsString(this.keyStoreSourceAsString);
            mgr.setKeyStoreProviderName(this.keyStoreProviderName);
            mgr.setKeyStorePassPhraseAlias(this.keyStorePassPhraseAlias);
            mgr.setPrivateKeyPassPhraseAlias(this.privateKeyPassPhraseAlias);
            if (Boolean.parseBoolean(this.initOnStart)) {
                mgr.initTokenStore();
            }
            return mgr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    @ConditionalOnProperty(name={"direct.config.keystore.hsmpresent"}, havingValue="false", matchIfMissing=true)
    public KeyStoreProtectionManager nonHSMKeyStoreProtectionManager() {
        LOGGER.info("No HSM configured.");
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager(this.keyStorePassPhrase, this.privateKeyPassPhrase);
        return mgr;
    }
}

