/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.spring.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@EnableWebSecurity
@Configuration
public class WebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final String BCRYPT_PREFIX = "{bcrypt}";
    @Value(value="${direct.configui.security.user.name}")
    protected String username;
    @Value(value="${direct.configui.security.user.password}")
    protected String password;

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        this.password = this.password.startsWith(BCRYPT_PREFIX) ? this.password.substring(BCRYPT_PREFIX.length()) : this.passwordEncoder().encode((CharSequence)this.password);
        ((InMemoryUserDetailsManagerConfigurer)auth.inMemoryAuthentication().passwordEncoder(this.passwordEncoder())).withUser(this.username).password(this.password).roles(new String[]{"ADMIN"});
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/actuator/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/resources/**"})).permitAll().anyRequest()).authenticated().and()).formLogin().loginPage("/login").defaultSuccessUrl("/main", true)).failureUrl("/login?login_error=1")).permitAll()).and()).logout().logoutUrl("/logout").deleteCookies(new String[]{"JSESSIONID"}).logoutSuccessHandler((req, res, auth) -> {
            req.getSession().setAttribute("message", (Object)"You are logged out successfully.");
            res.sendRedirect("login");
        });
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

