/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhind.config.rest.TrustBundleService;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.TrustBundle;
import org.nhindirect.config.model.TrustBundleDomainReltn;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.ui.form.BundleForm;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.nhindirect.config.ui.util.PrivateKeyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/bundles"})
public class BundlesController {
    private final Log log = LogFactory.getLog(this.getClass());
    private TrustBundleService bundleService;

    @Autowired
    public void setTrustBundleService(TrustBundleService bundleService) {
        this.bundleService = bundleService;
    }

    public BundlesController() {
        if (this.log.isDebugEnabled()) {
            this.log.error((Object)"BundlesController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addbundle"}, method={RequestMethod.POST})
    public ModelAndView addBundle(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm bundleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter Add Trust Bundle");
        }
        if (actionPath.equalsIgnoreCase("cancel")) {
            SearchDomainForm form2;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to cancel from saveupdate");
            }
            model.addAttribute((Object)((form2 = (SearchDomainForm)session.getAttribute("searchDomainForm")) != null ? form2 : new SearchDomainForm()));
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("main");
            mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
            return mav;
        }
        if (actionPath.equalsIgnoreCase("newbundle") || actionPath.equalsIgnoreCase("add bundle")) {
            Boolean formValidated = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Beginning to process signing certificate file");
            }
            model.addAttribute("signingCertError", (Object)false);
            model.addAttribute("URLError", (Object)false);
            TrustBundle trustBundle = new TrustBundle();
            String bundleName = bundleForm.getBundleName();
            trustBundle.setBundleName(bundleName);
            trustBundle.setRefreshInterval(bundleForm.getRefreshInterval() * 3600);
            if (!bundleForm.getFileData().isEmpty()) {
                byte[] bytes = bundleForm.getFileData().getBytes();
                String fileType = bundleForm.getFileData().getContentType();
                if (!(fileType.matches("application/x-x509-ca-cert") || fileType.matches("application/x-x509-user-cert") || fileType.matches("application/pkix-cert"))) {
                    model.addAttribute("signingCertError", (Object)true);
                    formValidated = false;
                } else {
                    try {
                        trustBundle.setSigningCertificateData(bytes);
                    }
                    catch (Exception exception) {}
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"DO NOT store the bundle into database BECAUSE THERE IS NO FILE");
            }
            if (bundleName.isEmpty()) {
                model.addAttribute("EmptyBundleError", (Object)true);
                formValidated = false;
            } else {
                TrustBundle dupeBundle = null;
                try {
                    dupeBundle = this.bundleService.getTrustBundle(bundleName);
                }
                catch (ServiceException cse) {
                    this.log.error((Object)"Could not get bundle information from config service");
                }
                if (dupeBundle != null) {
                    model.addAttribute("DupeBundleError", (Object)true);
                    formValidated = false;
                }
            }
            String trustURL = bundleForm.getTrustURL();
            try {
                new URL(trustURL);
            }
            catch (MalformedURLException mu) {
                model.addAttribute("URLError", (Object)true);
                formValidated = false;
            }
            if (formValidated.booleanValue()) {
                trustBundle.setBundleURL(trustURL);
                try {
                    trustBundle.setCheckSum("");
                    this.bundleService.addTrustBundle(trustBundle);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Add Trust Bundle to Database");
                    }
                }
                catch (Exception e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error((Object)e);
                    }
                    e.printStackTrace();
                }
                BundleForm bform = new BundleForm();
                model.addAttribute("bundleForm", (Object)bform);
            }
            try {
                Collection trustBundles = this.bundleService.getTrustBundles(false);
                if (trustBundles != null) {
                    model.addAttribute("trustBundles", (Object)trustBundles);
                }
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            model.addAttribute((Object)"bundlesSelected");
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("bundles");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removebundle"}, method={RequestMethod.POST})
    public ModelAndView removeCertificates(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter bundles/removebundle");
        }
        if (simpleForm.getBundlesSelected() != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Bundles marked for removal: " + simpleForm.getBundlesSelected().toString()));
        }
        if (this.bundleService != null && simpleForm != null && simpleForm.getBundlesSelected() != null) {
            int bundleCount = simpleForm.getBundlesSelected().size();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Removing Bundles");
            }
            for (int i = 0; i < bundleCount; ++i) {
                String bundleName = (String)simpleForm.getBundlesSelected().get(i);
                this.log.error((Object)bundleName);
                try {
                    this.bundleService.deleteTrustBundle(bundleName);
                    continue;
                }
                catch (ServiceException cse) {
                    this.log.error((Object)"Problem removing bundles");
                }
            }
        }
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("bundles");
        try {
            Collection trustBundles = this.bundleService.getTrustBundles(false);
            if (trustBundles != null) {
                model.addAttribute("trustBundles", (Object)trustBundles);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/refreshBundles"}, method={RequestMethod.POST})
    public ModelAndView refreshBundles(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter bundles/refreshbundles");
        }
        if (simpleForm.getBundlesSelected() != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Bundles marked for refresh: " + simpleForm.getBundlesSelected().toString()));
        }
        if (this.bundleService != null && simpleForm != null && simpleForm.getBundlesSelected() != null) {
            int bundleCount = simpleForm.getBundlesSelected().size();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Refreshing Bundles");
            }
            for (int i = 0; i < bundleCount; ++i) {
                String bundleName = (String)simpleForm.getBundlesSelected().get(i);
                this.log.debug((Object)("Refreshing Bundle #" + bundleName));
                try {
                    this.bundleService.refreshTrustBundle(bundleName);
                    continue;
                }
                catch (ServiceException cse) {
                    this.log.error((Object)("Could not refresh bundle: #" + bundleName));
                }
            }
        }
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("bundles");
        try {
            Collection trustBundles = this.bundleService.getTrustBundles(false);
            if (trustBundles != null) {
                model.addAttribute("trustBundles", (Object)trustBundles);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return new ModelAndView("redirect:/main/search?domainName=&submitType=ManageTrustBundles");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/assignBundlesForm"}, method={RequestMethod.GET})
    public ModelAndView assignBundlesForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter bundles/assignBundles");
        }
        try {
            Collection trustBundles = this.bundleService.getTrustBundles(false);
            if (trustBundles != null) {
                model.addAttribute("trustBundles", (Object)trustBundles);
            }
        }
        catch (ServiceException trustBundles) {
            // empty catch block
        }
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        bform.setDomainName((String)session.getAttribute("currentDomainName"));
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("assignBundlesForm");
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addMoreBundlesForm"}, method={RequestMethod.GET})
    public ModelAndView addMoreBundlesForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, @RequestParam(value="domainName") String domainName, Model model) {
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter bundles/addMoreBundlesForm");
        }
        try {
            ArrayList<TrustBundle> trustBundles = new ArrayList<TrustBundle>();
            Collection<TrustBundle> newBundles = new ArrayList();
            Collection bundleRelationships = this.bundleService.getTrustBundlesByDomain(domainName, false);
            Collection allBundles = this.bundleService.getTrustBundles(false);
            boolean bundleMatch = false;
            if (bundleRelationships != null && !bundleRelationships.isEmpty()) {
                for (TrustBundleDomainReltn relationship : bundleRelationships) {
                    trustBundles.add(relationship.getTrustBundle());
                }
                for (TrustBundle bundle : allBundles) {
                    bundleMatch = false;
                    for (TrustBundle subBundle : trustBundles) {
                        if (subBundle.getId() != bundle.getId()) continue;
                        bundleMatch = true;
                    }
                    if (bundleMatch) continue;
                    newBundles.add(bundle);
                }
            } else {
                newBundles = this.bundleService.getTrustBundles(false);
            }
            model.addAttribute("trustBundles", newBundles);
        }
        catch (ServiceException trustBundles) {
            // empty catch block
        }
        model.addAttribute("domainName", (Object)domainName);
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        bform.setDomainName((String)session.getAttribute("currentDomainName"));
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("addMoreBundlesForm");
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/newBundleForm"}, method={RequestMethod.GET})
    public ModelAndView newBundleForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter bundles/newBundles");
        }
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("newBundleForm");
        return mav;
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }
}

