/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhind.config.rest.CertificateService;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.MutableKeyStoreProtectionManager;
import org.nhindirect.common.crypto.WrappableKeyProtectionManager;
import org.nhindirect.common.crypto.exceptions.CryptoException;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.EntityStatus;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.ui.form.CertificateForm;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.nhindirect.config.ui.util.PrivateKeyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/certificates"})
public class CertificatesController {
    private final Log log = LogFactory.getLog(this.getClass());
    private CertificateService certService;
    @Autowired(required=false)
    private WrappableKeyProtectionManager keyManager;

    @Autowired
    public void setCertificateService(CertificateService certService) {
        this.certService = certService;
    }

    public CertificatesController() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ConfigurationController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addcertificate"}, method={RequestMethod.POST})
    public ModelAndView addCertificate(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute CertificateForm certificateForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav = new ModelAndView();
        String strid = "";
        this.log.error((Object)"Enter domain/addcertificate");
        if (actionPath.equalsIgnoreCase("cancel")) {
            SearchDomainForm form2;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"trying to cancel from saveupdate");
            }
            model.addAttribute((Object)((form2 = (SearchDomainForm)session.getAttribute("searchDomainForm")) != null ? form2 : new SearchDomainForm()));
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("main");
            mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
            return mav;
        }
        if (actionPath.equalsIgnoreCase("newcertificate") || actionPath.equalsIgnoreCase("add certificate")) {
            block26: {
                this.log.debug((Object)"Attempting to add certificate");
                if (this.keyManager == null) {
                    this.log.debug((Object)"Key manager is null");
                } else {
                    this.log.debug((Object)"Key manager is non-null");
                }
                strid = "" + certificateForm.getId();
                EntityStatus estatus = certificateForm.getStatus();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"beginning to evaluate filedata");
                }
                try {
                    model.addAttribute("certerror", (Object)false);
                    model.addAttribute("passphraseError", (Object)false);
                    if (!certificateForm.getFileData().isEmpty()) {
                        String passphrase = certificateForm.getKeyPassphrase() == null ? "" : certificateForm.getKeyPassphrase();
                        PrivateKeyType privKeyType = PrivateKeyType.fromString((String)certificateForm.getPrivKeyType());
                        if ((privKeyType == PrivateKeyType.PKCS8_PASSPHRASE || privKeyType == PrivateKeyType.PKCS_12_PASSPHRASE) && StringUtils.isEmpty((CharSequence)passphrase)) {
                            model.addAttribute("passphraseError", (Object)true);
                            break block26;
                        }
                        byte[] certOrP12Bytes = certificateForm.getFileData().getBytes();
                        byte[] privateKeyBytes = null;
                        if (privKeyType == PrivateKeyType.PKCS_12_PASSPHRASE || privKeyType == PrivateKeyType.PKCS_12_UNPROTECTED) {
                            this.log.debug((Object)"Converting byte stream to cert container");
                            this.log.debug((Object)"Private key exists; normalizing to non-protected p12 format.");
                            certOrP12Bytes = CertUtils.changePkcs12Protection((byte[])certOrP12Bytes, (char[])passphrase.toCharArray(), (char[])passphrase.toCharArray(), (char[])"".toCharArray(), (char[])"".toCharArray());
                        } else if (privKeyType != PrivateKeyType.NONE) {
                            privateKeyBytes = certificateForm.getPrivKeyData().getBytes();
                            if (privKeyType == PrivateKeyType.PKCS8_PASSPHRASE) {
                                try {
                                    EncryptedPrivateKeyInfo encryptPKInfo = new EncryptedPrivateKeyInfo(privateKeyBytes);
                                    Cipher cipher = Cipher.getInstance(encryptPKInfo.getAlgName());
                                    PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toCharArray());
                                    SecretKeyFactory secFac = SecretKeyFactory.getInstance(encryptPKInfo.getAlgName());
                                    SecretKey pbeKey = secFac.generateSecret(pbeKeySpec);
                                    AlgorithmParameters algParams = encryptPKInfo.getAlgParameters();
                                    cipher.init(2, (Key)pbeKey, algParams);
                                    PKCS8EncodedKeySpec pkcs8KeySpec = encryptPKInfo.getKeySpec(cipher);
                                    KeyFactory kf = KeyFactory.getInstance("RSA");
                                    privateKeyBytes = kf.generatePrivate(pkcs8KeySpec).getEncoded();
                                }
                                catch (Exception e) {
                                    return mav;
                                }
                            }
                        }
                        String owner = "";
                        String fileType = certificateForm.getFileData().getContentType();
                        if (!(fileType.matches("application/x-x509-ca-cert") || fileType.matches("application/octet-stream") || fileType.matches("application/x-pkcs12"))) {
                            model.addAttribute("certerror", (Object)true);
                        } else {
                            org.nhindirect.config.model.Certificate cert = new org.nhindirect.config.model.Certificate();
                            cert.setData(this.toCertDataFormat(certOrP12Bytes, privateKeyBytes, privKeyType));
                            cert.setOwner(owner);
                            cert.setStatus(EntityStatus.valueOf((String)estatus.toString()));
                            ArrayList<org.nhindirect.config.model.Certificate> certlist = new ArrayList<org.nhindirect.config.model.Certificate>();
                            certlist.add(cert);
                            this.log.debug((Object)"Adding certificate to config store.");
                            this.certService.addCertificate(cert);
                            this.log.debug((Object)"Certificate add SUCCESSFUL");
                        }
                        break block26;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"DO NOT store the certificate into database BECAUSE THERE IS NO FILE");
                    }
                }
                catch (ServiceException ed) {
                    this.log.error((Object)ed);
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    e.printStackTrace();
                }
            }
            try {
                Collection certs = this.certService.getAllCertificates();
                if (this.keyManager != null && this.keyManager instanceof MutableKeyStoreProtectionManager) {
                    KeyStore keyStore = ((MutableKeyStoreProtectionManager)this.keyManager).getKS();
                    for (org.nhindirect.config.model.Certificate cert : certs) {
                        if (cert.isPrivateKey()) continue;
                        try {
                            PrivateKey privKey;
                            X509Certificate checkCert = CertUtils.toX509Certificate((byte[])cert.getData());
                            String alias = keyStore.getCertificateAlias(checkCert);
                            if (StringUtils.isEmpty((CharSequence)alias) || (privKey = (PrivateKey)keyStore.getKey(alias, "".toCharArray())) == null) continue;
                            cert.setPrivateKey(true);
                        }
                        catch (Exception exception) {}
                    }
                }
                model.addAttribute("certificatesResults", (Object)certs);
                CertificateForm cform = new CertificateForm();
                cform.setId(0L);
                model.addAttribute("certificateForm", (Object)cform);
            }
            catch (ServiceException e1) {
                e1.printStackTrace();
            }
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            SimpleForm simple = new SimpleForm();
            simple.setId(Long.parseLong(strid));
            model.addAttribute("simpleForm", (Object)simple);
            mav.setViewName("certificates");
            String action = "Update";
            model.addAttribute("action", (Object)"Update");
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        }
        return mav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] toCertDataFormat(byte[] certOrP12Bytes, byte[] privateKeyBytes, PrivateKeyType privKeyType) throws CryptoException {
        try {
            if (privKeyType == PrivateKeyType.NONE) {
                return certOrP12Bytes;
            }
            CertUtils.CertContainer cont = CertUtils.toCertContainer((byte[])certOrP12Bytes);
            if (privKeyType == PrivateKeyType.PKCS_12_PASSPHRASE | privKeyType == PrivateKeyType.PKCS_12_UNPROTECTED) {
                if (this.keyManager == null) {
                    this.log.info((Object)"Storing PKCS12 file in PKCS12 unprotected format");
                    return certOrP12Bytes;
                }
                this.log.info((Object)"Storing PKCS12 file in wrapped format");
                byte[] wrappedKey = this.keyManager.wrapWithSecretKey((SecretKey)((KeyStoreProtectionManager)this.keyManager).getPrivateKeyProtectionKey(), cont.getKey());
                return CertUtils.certAndWrappedKeyToRawByteFormat((byte[])wrappedKey, (X509Certificate)cont.getCert());
            }
            if (privKeyType == PrivateKeyType.PKCS8_WRAPPED) {
                this.log.info((Object)"Storing already wrapped PKCS8 file");
                return CertUtils.certAndWrappedKeyToRawByteFormat((byte[])privateKeyBytes, (X509Certificate)cont.getCert());
            }
            KeyFactory kf = KeyFactory.getInstance("RSA", CertUtils.getJCEProviderName());
            PKCS8EncodedKeySpec keysp = new PKCS8EncodedKeySpec(privateKeyBytes);
            PrivateKey privKey = kf.generatePrivate(keysp);
            if (this.keyManager != null) {
                this.log.info((Object)"Storing PKCS8 private key in wrapped format");
                byte[] wrappedKey = this.keyManager.wrapWithSecretKey((SecretKey)((KeyStoreProtectionManager)this.keyManager).getPrivateKeyProtectionKey(), (Key)privKey);
                return CertUtils.certAndWrappedKeyToRawByteFormat((byte[])wrappedKey, (X509Certificate)cont.getCert());
            }
            this.log.info((Object)"Storing PKCS8 private key in PKCS12 unprotected format");
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CertUtils.getJCEProviderName());
            localKeyStore.load(null, null);
            localKeyStore.setKeyEntry("privCert", privKey, "".toCharArray(), new Certificate[]{cont.getCert()});
            ByteArrayOutputStream outStr = new ByteArrayOutputStream();
            localKeyStore.store(outStr, "".toCharArray());
            try {
                byte[] byArray = outStr.toByteArray();
                return byArray;
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outStr);
            }
        }
        catch (Exception e) {
            throw new CryptoException("Failed to conver certificate and key to cert data format: " + e.getMessage(), (Throwable)e);
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removecertifcates"}, method={RequestMethod.POST})
    public ModelAndView removeCertificates(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute CertificateForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav;
        block18: {
            mav = new ModelAndView();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Enter domain/removecertificates");
            }
            if (simpleForm.getRemove() != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)("the list of checkboxes checked or not is: " + simpleForm.getRemove().toString()));
            }
            if (this.certService != null && simpleForm != null && actionPath != null && (actionPath.equalsIgnoreCase("deletecertificate") || actionPath.equalsIgnoreCase("Remove Selected")) && simpleForm.getRemove() != null) {
                int cnt = simpleForm.getRemove().size();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"removing certificates");
                }
                try {
                    Collection certs = this.certService.getAllCertificates();
                    ArrayList<Long> certtoberemovedlist = new ArrayList<Long>();
                    block6: for (int x = 0; x < cnt; ++x) {
                        String removeid = (String)simpleForm.getRemove().get(x);
                        for (org.nhindirect.config.model.Certificate t : certs) {
                            if (t.getId() != Long.parseLong(removeid)) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)" ");
                                this.log.debug((Object)("domain address id: " + t.getId()));
                                this.log.debug((Object)" ");
                            }
                            certtoberemovedlist.add(t.getId());
                            continue block6;
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" Trying to remove certificates from database");
                    }
                    this.certService.deleteCertificatesByIds(certtoberemovedlist);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)" SUCCESS Trying to update certificates");
                    }
                }
                catch (ServiceException e) {
                    if (!this.log.isDebugEnabled()) break block18;
                    this.log.error((Object)e);
                }
            }
        }
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        CertificateForm cform = new CertificateForm();
        cform.setId(0L);
        model.addAttribute("certificateForm", (Object)cform);
        mav.setViewName("certificates");
        String action = "Update";
        model.addAttribute("action", (Object)"Update");
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        mav.addObject("action", (Object)"Update");
        Collection certlist = null;
        try {
            certlist = this.certService.getAllCertificates();
            if (this.keyManager != null && this.keyManager instanceof MutableKeyStoreProtectionManager) {
                KeyStore keyStore = ((MutableKeyStoreProtectionManager)this.keyManager).getKS();
                for (org.nhindirect.config.model.Certificate cert : certlist) {
                    if (cert.isPrivateKey()) continue;
                    try {
                        PrivateKey privKey;
                        X509Certificate checkCert = CertUtils.toX509Certificate((byte[])cert.getData());
                        String alias = keyStore.getCertificateAlias(checkCert);
                        if (StringUtils.isEmpty((CharSequence)alias) || (privKey = (PrivateKey)keyStore.getKey(alias, "".toCharArray())) == null) continue;
                        cert.setPrivateKey(true);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        model.addAttribute("certificatesResults", (Object)certlist);
        mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
        mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
        model.addAttribute("simpleForm", (Object)simpleForm);
        String strid = "" + simpleForm.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" the value of id of simpleform is: " + strid));
        }
        return mav;
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }
}

