/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.nhind.config.rest.TrustBundleService;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.TrustBundle;
import org.nhindirect.config.model.TrustBundleDomainReltn;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.ui.form.BundleForm;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.nhindirect.config.ui.util.PrivateKeyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/bundles"})
public class BundlesController {
    private static final Logger log = LoggerFactory.getLogger(BundlesController.class);
    private TrustBundleService bundleService;

    @Autowired
    public void setTrustBundleService(TrustBundleService bundleService) {
        this.bundleService = bundleService;
    }

    public BundlesController() {
        if (log.isDebugEnabled()) {
            log.error("BundlesController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addbundle"}, method={RequestMethod.POST})
    public ModelAndView addBundle(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm bundleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav = new ModelAndView();
        if (log.isDebugEnabled()) {
            log.debug("Enter Add Trust Bundle");
        }
        if (actionPath.equalsIgnoreCase("cancel")) {
            SearchDomainForm form2;
            if (log.isDebugEnabled()) {
                log.debug("trying to cancel from saveupdate");
            }
            model.addAttribute((Object)((form2 = (SearchDomainForm)session.getAttribute("searchDomainForm")) != null ? form2 : new SearchDomainForm()));
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("main");
            mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
            return mav;
        }
        if (actionPath.equalsIgnoreCase("newbundle") || actionPath.equalsIgnoreCase("add bundle")) {
            Boolean formValidated = true;
            if (log.isDebugEnabled()) {
                log.debug("Beginning to process signing certificate file");
            }
            model.addAttribute("signingCertError", (Object)false);
            model.addAttribute("URLError", (Object)false);
            TrustBundle trustBundle = new TrustBundle();
            String bundleName = bundleForm.getBundleName();
            trustBundle.setBundleName(bundleName);
            trustBundle.setRefreshInterval(bundleForm.getRefreshInterval() * 3600);
            if (!bundleForm.getFileData().isEmpty()) {
                byte[] bytes = bundleForm.getFileData().getBytes();
                String fileType = bundleForm.getFileData().getContentType();
                if (!(fileType.matches("application/x-x509-ca-cert") || fileType.matches("application/x-x509-user-cert") || fileType.matches("application/pkix-cert"))) {
                    model.addAttribute("signingCertError", (Object)true);
                    formValidated = false;
                } else {
                    try {
                        trustBundle.setSigningCertificateData(bytes);
                    }
                    catch (Exception exception) {}
                }
            } else if (log.isDebugEnabled()) {
                log.debug("DO NOT store the bundle into database BECAUSE THERE IS NO FILE");
            }
            if (bundleName.isEmpty()) {
                model.addAttribute("EmptyBundleError", (Object)true);
                formValidated = false;
            } else {
                TrustBundle dupeBundle = null;
                try {
                    dupeBundle = this.bundleService.getTrustBundle(bundleName);
                }
                catch (ServiceException cse) {
                    log.error("Could not get bundle information from config service");
                }
                if (dupeBundle != null) {
                    model.addAttribute("DupeBundleError", (Object)true);
                    formValidated = false;
                }
            }
            String trustURL = bundleForm.getTrustURL();
            try {
                new URL(trustURL);
            }
            catch (MalformedURLException mu) {
                model.addAttribute("URLError", (Object)true);
                formValidated = false;
            }
            if (formValidated.booleanValue()) {
                block26: {
                    trustBundle.setBundleURL(trustURL);
                    try {
                        trustBundle.setCheckSum("");
                        this.bundleService.addTrustBundle(trustBundle);
                        if (log.isDebugEnabled()) {
                            log.debug("Add Trust Bundle to Database");
                        }
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block26;
                        log.error("Error adding trust bundle.", (Throwable)e);
                    }
                }
                BundleForm bform = new BundleForm();
                model.addAttribute("bundleForm", (Object)bform);
            }
            try {
                Collection trustBundles = this.bundleService.getTrustBundles(false);
                if (trustBundles != null) {
                    model.addAttribute("trustBundles", (Object)trustBundles);
                }
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            model.addAttribute((Object)"bundlesSelected");
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("bundles");
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removebundle"}, method={RequestMethod.POST})
    public ModelAndView removeCertificates(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (log.isDebugEnabled()) {
            log.debug("Enter bundles/removebundle");
        }
        if (simpleForm.getBundlesSelected() != null && log.isDebugEnabled()) {
            log.debug("Bundles marked for removal: {}", (Object)simpleForm.getBundlesSelected().toString());
        }
        if (this.bundleService != null && simpleForm != null && simpleForm.getBundlesSelected() != null) {
            int bundleCount = simpleForm.getBundlesSelected().size();
            if (log.isDebugEnabled()) {
                log.debug("Removing Bundles");
            }
            for (int i = 0; i < bundleCount; ++i) {
                String bundleName = (String)simpleForm.getBundlesSelected().get(i);
                log.error(bundleName);
                try {
                    this.bundleService.deleteTrustBundle(bundleName);
                    continue;
                }
                catch (ServiceException cse) {
                    log.error("Problem removing bundles");
                }
            }
        }
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("bundles");
        try {
            Collection trustBundles = this.bundleService.getTrustBundles(false);
            if (trustBundles != null) {
                model.addAttribute("trustBundles", (Object)trustBundles);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/refreshBundles"}, method={RequestMethod.POST})
    public ModelAndView refreshBundles(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (log.isDebugEnabled()) {
            log.debug("Enter bundles/refreshbundles");
        }
        if (simpleForm.getBundlesSelected() != null && log.isDebugEnabled()) {
            log.debug("Bundles marked for refresh: {}", (Object)simpleForm.getBundlesSelected().toString());
        }
        if (this.bundleService != null && simpleForm != null && simpleForm.getBundlesSelected() != null) {
            int bundleCount = simpleForm.getBundlesSelected().size();
            if (log.isDebugEnabled()) {
                log.debug("Refreshing Bundles");
            }
            for (int i = 0; i < bundleCount; ++i) {
                String bundleName = (String)simpleForm.getBundlesSelected().get(i);
                log.debug("Refreshing Bundle #{}", (Object)bundleName);
                try {
                    this.bundleService.refreshTrustBundle(bundleName);
                    continue;
                }
                catch (ServiceException cse) {
                    log.error("Could not refresh bundle: #{}", (Object)bundleName);
                }
            }
        }
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("bundles");
        try {
            Collection trustBundles = this.bundleService.getTrustBundles(false);
            if (trustBundles != null) {
                model.addAttribute("trustBundles", (Object)trustBundles);
            }
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return new ModelAndView("redirect:/main/search?domainName=&submitType=ManageTrustBundles");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/assignBundlesForm"}, method={RequestMethod.GET})
    public ModelAndView assignBundlesForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (log.isDebugEnabled()) {
            log.debug("Enter bundles/assignBundles");
        }
        try {
            Collection trustBundles = this.bundleService.getTrustBundles(false);
            if (trustBundles != null) {
                model.addAttribute("trustBundles", (Object)trustBundles);
            }
        }
        catch (ServiceException trustBundles) {
            // empty catch block
        }
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        bform.setDomainName((String)session.getAttribute("currentDomainName"));
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("assignBundlesForm");
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addMoreBundlesForm"}, method={RequestMethod.GET})
    public ModelAndView addMoreBundlesForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, @RequestParam(value="domainName") String domainName, Model model) {
        ModelAndView mav = new ModelAndView();
        if (log.isDebugEnabled()) {
            log.debug("Enter bundles/addMoreBundlesForm");
        }
        try {
            ArrayList<TrustBundle> trustBundles = new ArrayList<TrustBundle>();
            Collection<TrustBundle> newBundles = new ArrayList();
            Collection bundleRelationships = this.bundleService.getTrustBundlesByDomain(domainName, false);
            Collection allBundles = this.bundleService.getTrustBundles(false);
            boolean bundleMatch = false;
            if (bundleRelationships != null && !bundleRelationships.isEmpty()) {
                for (TrustBundleDomainReltn relationship : bundleRelationships) {
                    trustBundles.add(relationship.getTrustBundle());
                }
                for (TrustBundle bundle : allBundles) {
                    bundleMatch = false;
                    for (TrustBundle subBundle : trustBundles) {
                        if (subBundle.getId() != bundle.getId()) continue;
                        bundleMatch = true;
                    }
                    if (bundleMatch) continue;
                    newBundles.add(bundle);
                }
            } else {
                newBundles = this.bundleService.getTrustBundles(false);
            }
            model.addAttribute("trustBundles", newBundles);
        }
        catch (ServiceException trustBundles) {
            // empty catch block
        }
        model.addAttribute("domainName", (Object)domainName);
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        bform.setDomainName((String)session.getAttribute("currentDomainName"));
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("addMoreBundlesForm");
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/newBundleForm"}, method={RequestMethod.GET})
    public ModelAndView newBundleForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute BundleForm simpleForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (log.isDebugEnabled()) {
            log.debug("Enter bundles/newBundles");
        }
        BundleForm bform = new BundleForm();
        bform.setId(0L);
        model.addAttribute("bundleForm", (Object)bform);
        mav.setViewName("newBundleForm");
        return mav;
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }
}

