/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.IOUtils;
import org.nhind.config.rest.CertPolicyService;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.config.ui.UploadedFile;
import org.nhindirect.config.ui.form.PolicyForm;
import org.nhindirect.policy.PolicyLexicon;
import org.nhindirect.policy.PolicyLexiconParser;
import org.nhindirect.policy.PolicyLexiconParserFactory;
import org.nhindirect.policy.PolicyParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/policies"})
public class PoliciesController {
    private static final Logger log = LoggerFactory.getLogger(PoliciesController.class);
    private CertPolicyService policyService;

    @Autowired
    public void setCertPolicyService(CertPolicyService policyService) {
        this.policyService = policyService;
    }

    public PoliciesController() {
        if (log.isDebugEnabled()) {
            log.error("PoliciesController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addPolicy"}, method={RequestMethod.POST})
    @ResponseBody
    public String addPolicy(@RequestParam(value="id") String id, @RequestParam(value="policyName") String policyName, @RequestParam(value="policyContent") String policyContent, @RequestParam(value="policyLexicon") String policyLexicon) {
        if (log.isDebugEnabled()) {
            log.debug("Adding New Policy");
        }
        if (log.isDebugEnabled()) {
            log.debug("Beginning to add new policy");
        }
        try {
            URL uRL = new URL("http://localhost:8081/config-service/ConfigurationService");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        CertPolicy newPolicy = new CertPolicy();
        newPolicy.setPolicyName(policyName);
        String lexiconName = policyLexicon;
        if (lexiconName.equalsIgnoreCase("XML")) {
            newPolicy.setLexicon(PolicyLexicon.XML);
        } else if (lexiconName.equalsIgnoreCase("JAVA_SER")) {
            newPolicy.setLexicon(PolicyLexicon.JAVA_SER);
        } else if (lexiconName.equalsIgnoreCase("SIMPLE_TEXT_V1")) {
            newPolicy.setLexicon(PolicyLexicon.SIMPLE_TEXT_V1);
        }
        newPolicy.setPolicyData(policyContent.getBytes());
        try {
            this.policyService.addPolicy(newPolicy);
        }
        catch (ServiceException cse) {
            cse.printStackTrace();
        }
        return "test";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removePolicies"}, method={RequestMethod.POST})
    public ModelAndView removePolicies(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute PolicyForm policyForm, Model model) {
        if (log.isDebugEnabled()) {
            log.debug("Enter remove policies method");
        }
        if (policyForm.getPoliciesSelected() != null && log.isDebugEnabled()) {
            log.debug("Policies marked for removal: {}", (Object)policyForm.getPoliciesSelected().toString());
        }
        if (this.policyService != null && policyForm != null && policyForm.getPoliciesSelected() != null) {
            int policyCount = policyForm.getPoliciesSelected().size();
            if (log.isDebugEnabled()) {
                log.debug("Removing Policies");
            }
            for (int i = 0; i < policyCount; ++i) {
                String policyName = (String)policyForm.getPoliciesSelected().get(i);
                try {
                    this.policyService.deletePolicy(policyName);
                    continue;
                }
                catch (ServiceException cse) {
                    log.error("Problem removing policies");
                }
            }
        }
        return new ModelAndView("redirect:/main/search?domainName=&submitType=ManagePolicies");
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/updatePolicyForm"}, method={RequestMethod.GET})
    public ModelAndView updatePolicyForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, @RequestParam(value="policyName") String policyName, HttpSession session, @ModelAttribute PolicyForm policyForm, Model model) {
        CertPolicy policy = null;
        ModelAndView mav = new ModelAndView();
        if (log.isDebugEnabled()) {
            log.debug("Enter policies update form for policy #{}", (Object)policyName);
        }
        try {
            policy = this.policyService.getPolicyByName(policyName);
        }
        catch (ServiceException cse) {
            cse.printStackTrace();
            return new ModelAndView("redirect:/");
        }
        PolicyForm pform = new PolicyForm();
        pform.setPolicyName(policy.getPolicyName());
        pform.setPolicyLexicon(policy.getLexicon());
        try {
            pform.setPolicyContent(new String(policy.getPolicyData(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ie) {
            ie.printStackTrace();
        }
        model.addAttribute("sessionId", (Object)session.getId());
        model.addAttribute("policyForm", (Object)pform);
        mav.setViewName("updatePolicyForm");
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/updatePolicy"}, method={RequestMethod.POST})
    @ResponseBody
    public String updatePolicy(@RequestParam(value="id") String id, @RequestParam(value="policyContent") String policyContent, @RequestParam(value="policyLexicon") String policyLexicon, @RequestParam(value="policyName") String policyName) {
        String jsonResponse = "";
        if (log.isDebugEnabled()) {
            log.debug("Enter update policy #{}", (Object)id);
        }
        log.error(policyName);
        PolicyLexicon lex = null;
        if (policyLexicon.isEmpty()) {
            lex = PolicyLexicon.SIMPLE_TEXT_V1;
        } else {
            try {
                lex = PolicyLexicon.valueOf((String)policyLexicon);
            }
            catch (Exception e) {
                log.error("Invalid lexicon name.");
            }
        }
        PolicyLexicon parseLexicon = lex;
        byte[] policyContentByteArray = policyContent.getBytes();
        return jsonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/checkLexiconFile"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String checkLexiconFile(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpServletResponse response, Object command, @RequestHeader(value="lexicon", required=false) String lexicon, MultipartHttpServletRequest request) throws FileUploadException, IOException, Exception {
        String jsonResponse = "";
        String uploadToString = "";
        if (log.isDebugEnabled()) {
            log.debug("Checking uploaded lexicon file for format and validation");
        }
        UploadedFile ufile = new UploadedFile();
        Iterator itr = request.getFileNames();
        MultipartFile mpf = request.getFile((String)itr.next());
        try {
            ufile.length = mpf.getBytes().length;
            ufile.bytes = mpf.getBytes();
            ufile.type = mpf.getContentType();
            ufile.name = mpf.getOriginalFilename();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        uploadToString = new String(ufile.bytes);
        lexicon = request.getParameter("lexicon");
        PolicyLexicon lex = null;
        if (lexicon.isEmpty()) {
            lex = PolicyLexicon.SIMPLE_TEXT_V1;
        } else {
            try {
                lex = PolicyLexicon.valueOf((String)lexicon);
            }
            catch (Exception e) {
                log.error("Invalid lexicon name.");
            }
        }
        PolicyLexicon parseLexicon = lex;
        ByteArrayInputStream inStr = null;
        try {
            inStr = new ByteArrayInputStream(ufile.bytes);
            PolicyLexiconParser parser = PolicyLexiconParserFactory.getInstance((PolicyLexicon)parseLexicon);
            parser.parse((InputStream)inStr);
        }
        catch (PolicyParseException e) {
            try {
                log.error("Syntax error in policy file  : " + e.getMessage());
                jsonResponse = "{\"Status\":\"File was not a valid file.\",\"Content\":\"" + uploadToString + "\"}";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStr);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inStr);
        }
        IOUtils.closeQuietly((InputStream)inStr);
        if (jsonResponse.isEmpty()) {
            jsonResponse = "{\"Status\":\"Success\",\"Content\":\"" + uploadToString + "\"}";
        }
        return jsonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/checkPolicyContent"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public String checkPolicyContent(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpServletResponse response, HttpServletRequest request, Object command) throws Exception {
        String jsonResponse = "";
        String content = request.getParameter("content");
        String lexicon = "";
        if (log.isDebugEnabled()) {
            log.debug("Checking policy content for format and validation");
        }
        lexicon = request.getParameter("lexicon");
        PolicyLexicon lex = null;
        if (lexicon.isEmpty()) {
            lex = PolicyLexicon.SIMPLE_TEXT_V1;
        } else {
            try {
                lex = PolicyLexicon.valueOf((String)lexicon);
            }
            catch (Exception e) {
                log.error("Invalid lexicon name.");
            }
        }
        PolicyLexicon parseLexicon = lex;
        ByteArrayInputStream inStr = null;
        try {
            inStr = new ByteArrayInputStream(content.getBytes());
            PolicyLexiconParser parser = PolicyLexiconParserFactory.getInstance((PolicyLexicon)parseLexicon);
            parser.parse((InputStream)inStr);
        }
        catch (PolicyParseException e) {
            try {
                log.error("Syntax error in policy content  : " + e.getMessage());
                jsonResponse = "{\"Status\":\"Policy content was not valid.\",\"Error\":\"" + e.getMessage() + "\"}";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStr);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inStr);
        }
        IOUtils.closeQuietly((InputStream)inStr);
        if (jsonResponse.isEmpty()) {
            jsonResponse = "{\"Status\":\"Success\"}";
        }
        return jsonResponse;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/newPolicyForm"}, method={RequestMethod.GET})
    public ModelAndView newPolicyForm(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute PolicyForm policyForm, Model model) {
        ModelAndView mav = new ModelAndView();
        if (log.isDebugEnabled()) {
            log.debug("Enter policies");
        }
        PolicyForm pform = new PolicyForm();
        pform.setId(0L);
        model.addAttribute("policyForm", (Object)pform);
        model.addAttribute("lexiconNames", (Object)pform.getLexiconNames());
        mav.setViewName("newPolicyForm");
        return mav;
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }
}

