/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.ui;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.nhind.config.rest.SettingService;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.EntityStatus;
import org.nhindirect.config.ui.form.SearchDomainForm;
import org.nhindirect.config.ui.form.SettingsForm;
import org.nhindirect.config.ui.form.SimpleForm;
import org.nhindirect.config.ui.util.AjaxUtils;
import org.nhindirect.config.ui.util.PrivateKeyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/settings"})
public class SettingsController {
    private static final Logger log = LoggerFactory.getLogger(SettingsController.class);
    private SettingService settingsService;

    @Autowired
    public void setSettingsService(SettingService settingsService) {
        this.settingsService = settingsService;
    }

    public SettingsController() {
        if (log.isDebugEnabled()) {
            log.debug("SettingsController initialized");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/addsetting"}, method={RequestMethod.POST})
    public ModelAndView addSetting(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute SettingsForm settingsForm, Model model, @RequestParam(value="submitType") String actionPath) {
        ModelAndView mav = new ModelAndView();
        String strid = "";
        String key = "";
        String value = "";
        if (log.isDebugEnabled()) {
            log.debug("Enter domain/addsetting");
        }
        if (actionPath.equalsIgnoreCase("cancel")) {
            SearchDomainForm form2;
            if (log.isDebugEnabled()) {
                log.debug("trying to cancel from saveupdate");
            }
            model.addAttribute((Object)((form2 = (SearchDomainForm)session.getAttribute("searchDomainForm")) != null ? form2 : new SearchDomainForm()));
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            mav.setViewName("main");
            mav.addObject("privKeyTypeList", (Object)PrivateKeyType.getPrivKeyTypeList());
            mav.addObject("statusList", (Object)EntityStatus.getEntityStatusList());
            return mav;
        }
        if (actionPath.equalsIgnoreCase("newsetting") || actionPath.equalsIgnoreCase("add setting")) {
            if (log.isDebugEnabled()) {
                log.debug("trying to get/set settings");
            }
            strid = "" + settingsForm.getId();
            key = "" + settingsForm.getKey();
            value = "" + settingsForm.getValue();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("trying set settings services");
                }
                this.settingsService.addSetting(key, value);
                if (log.isDebugEnabled()) {
                    log.debug("PAST trying set settings services");
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
            SimpleForm simple = new SimpleForm();
            simple.setId(Long.parseLong(strid));
            model.addAttribute("simpleForm", (Object)simple);
            try {
                model.addAttribute("settingsResults", (Object)this.settingsService.getSettings());
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
            mav.setViewName("settings");
            String action = "Update";
            model.addAttribute("settingsForm", (Object)settingsForm);
            model.addAttribute("action", (Object)action);
            model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        }
        return mav;
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/removesettings"}, method={RequestMethod.POST})
    public ModelAndView removeAnchors(@RequestHeader(value="X-Requested-With", required=false) String requestedWith, HttpSession session, @ModelAttribute SimpleForm simpleForm, Model model, @RequestParam(value="submitType") String actionPath) {
        String strid;
        ModelAndView mav;
        block10: {
            mav = new ModelAndView();
            if (log.isDebugEnabled()) {
                log.debug("Enter domain/removesettings");
            }
            if (simpleForm.getRemove() != null && log.isDebugEnabled()) {
                log.debug("the list of checkboxes checked or not is: {}", (Object)simpleForm.getRemove().toString());
            }
            strid = "" + simpleForm.getId();
            if (this.settingsService != null && simpleForm != null && actionPath != null && (actionPath.equalsIgnoreCase("delete") || actionPath.equalsIgnoreCase("remove selected")) && simpleForm.getRemove() != null) {
                int cnt = simpleForm.getRemove().size();
                try {
                    List settingstoberemovedlist = simpleForm.getRemove();
                    if (log.isDebugEnabled()) {
                        log.debug(" Trying to remove settings from database");
                    }
                    for (String toRemove : settingstoberemovedlist) {
                        this.settingsService.deleteSetting(toRemove);
                    }
                    this.settingsService.getSettings();
                    if (log.isDebugEnabled()) {
                        log.debug(" SUCCESS Trying to remove settings");
                    }
                }
                catch (ServiceException e) {
                    if (!log.isDebugEnabled()) break block10;
                    log.error("Error removing settings.", (Throwable)e);
                }
            }
        }
        try {
            model.addAttribute("settingsResults", (Object)this.settingsService.getSettings());
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        mav.setViewName("settings");
        String action = "Update";
        model.addAttribute("settingsForm", (Object)new SettingsForm());
        model.addAttribute("action", (Object)action);
        model.addAttribute("ajaxRequest", (Object)AjaxUtils.isAjaxRequest((String)requestedWith));
        model.addAttribute("simpleForm", (Object)simpleForm);
        strid = "" + simpleForm.getId();
        return mav;
    }

    @ExceptionHandler(value={IOException.class})
    public String handleIOException(IOException ex, HttpServletRequest request) {
        return ClassUtils.getShortName((String)(ex.getClass() + ":" + ex.getMessage()));
    }
}

