/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit;

import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.common.audit.AuditEvent;

public class AuditEventTest {
    @Test
    public void testConstructAuditEvent() throws Exception {
        AuditEvent event = new AuditEvent("category", "type");
        Assert.assertNotNull((Object)event);
    }

    @Test
    public void testGetName() throws Exception {
        AuditEvent event = new AuditEvent("category", "type");
        Assert.assertEquals((Object)"category", (Object)event.getName());
    }

    @Test
    public void testGetType() throws Exception {
        AuditEvent event = new AuditEvent("category", "type");
        Assert.assertEquals((Object)"type", (Object)event.getType());
    }

    @Test
    public void testConstructAuditEvent_EmptyName_AssertIllgalArgumentException() throws Exception {
        boolean exceptionOccured = false;
        try {
            new AuditEvent("", "value");
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstructAuditEvent_NullName_AssertIllgalArgumentException() throws Exception {
        boolean exceptionOccured = false;
        try {
            new AuditEvent(null, "value");
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstructAuditEvent_NullType_AssertIllgalArgumentException() throws Exception {
        boolean exceptionOccured = false;
        try {
            new AuditEvent("category", null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstructAuditEvent_EmptyType_AssertIllgalArgumentException() throws Exception {
        boolean exceptionOccured = false;
        try {
            new AuditEvent("category", "");
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testEquals() throws Exception {
        AuditEvent event1 = new AuditEvent("category", "type");
        AuditEvent event2 = new AuditEvent("category", "type");
        Assert.assertTrue((boolean)event1.equals((Object)event2));
    }

    @Test
    public void testEquals_DifferentName_AssertNotEqual() throws Exception {
        AuditEvent event1 = new AuditEvent("category1", "type");
        AuditEvent event2 = new AuditEvent("category2", "type");
        Assert.assertFalse((boolean)event1.equals((Object)event2));
    }

    @Test
    public void testEquals_DifferentType_AssertNotEqual() throws Exception {
        AuditEvent event1 = new AuditEvent("category", "type1");
        AuditEvent event2 = new AuditEvent("category", "type2");
        Assert.assertFalse((boolean)event1.equals((Object)event2));
    }

    @Test
    public void testEquals_DifferentObject_AssertNotEqual() throws Exception {
        AuditEvent event = new AuditEvent("category", "type1");
        Assert.assertFalse((boolean)event.equals((Object)event.toString()));
    }
}

