/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit;

import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.common.audit.DefaultAuditContext;

public class DefaultAuditContextTest {
    @Test
    public void testConstructAuditContext() throws Exception {
        DefaultAuditContext context = new DefaultAuditContext("test", "");
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testGetName() throws Exception {
        DefaultAuditContext context = new DefaultAuditContext("name", "value");
        Assert.assertEquals((Object)"name", (Object)context.getContextName());
    }

    @Test
    public void testGetValue() throws Exception {
        DefaultAuditContext context = new DefaultAuditContext("name", "value");
        Assert.assertEquals((Object)"value", (Object)context.getContextValue());
    }

    @Test
    public void testGetEmptyValue() throws Exception {
        DefaultAuditContext context = new DefaultAuditContext("name", "");
        Assert.assertEquals((Object)"", (Object)context.getContextValue());
    }

    @Test
    public void testConstructAuditContext_EmptyName_AssertIllgalArgumentException() throws Exception {
        boolean exceptionOccured = false;
        try {
            new DefaultAuditContext("", "value");
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstructAuditContext_NullName_AssertIllgalArgumentException() throws Exception {
        boolean exceptionOccured = false;
        try {
            new DefaultAuditContext(null, "value");
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstructAuditContext_NullValue_AssertIllgalArgumentException() throws Exception {
        boolean exceptionOccured = false;
        try {
            new DefaultAuditContext("name", null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAuditContextToString() throws Exception {
        DefaultAuditContext context = new DefaultAuditContext("name", "value");
        Assert.assertEquals((Object)"name:value", (Object)context.toString());
    }
}

