/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.management.openmbean.CompositeData;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.DefaultAuditContext;
import org.nhindirect.common.audit.impl.FileAuditor;

public class FileAuditorTest {
    private static final String PRINCIPAL = "JUNITTEST";
    private static final AuditEvent UNIT_TEST_EVENT = new AuditEvent("name", "value");
    private static final char fileSep = File.separatorChar;
    private static File auditFile;

    @Before
    public void setup() {
        auditFile = new File("target" + fileSep + "testAuditFile.txt");
        if (auditFile.exists()) {
            auditFile.delete();
        }
    }

    @Test
    public void testCreateAuditor_NullFile_AssertException() {
        boolean exceptionOccured = false;
        try {
            new FileAuditor(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testCreateAuditor_IllegalFileName_AssertException() {
        boolean exceptionOccured = false;
        try {
            new FileAuditor(new File(".."));
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testCreateAuditor_IllegalFileName2_AssertException() {
        boolean exceptionOccured = false;
        try {
            new FileAuditor(new File("!-@$*?\n\r/\u0000"));
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAudit() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
    }

    @Test
    public void testAudit_EmptyPrincipal_AssertExeption() {
        FileAuditor auditor = new FileAuditor(auditFile);
        boolean exceptionOccured = false;
        try {
            auditor.audit("", UNIT_TEST_EVENT);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAudit_NullPrincipal_AssertExeption() {
        FileAuditor auditor = new FileAuditor(auditFile);
        boolean exceptionOccured = false;
        try {
            auditor.audit(null, UNIT_TEST_EVENT);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAudit_NullEvent_AssertExeption() {
        FileAuditor auditor = new FileAuditor(auditFile);
        boolean exceptionOccured = false;
        try {
            auditor.audit(PRINCIPAL, null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAuditCategoryWithContext() {
        FileAuditor auditor = new FileAuditor(auditFile);
        List<DefaultAuditContext> ctx = Arrays.asList(new DefaultAuditContext("name", "value"));
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT, ctx);
    }

    @Test
    public void testAuditCategoryWithContextContext_EmptyContext() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT, new ArrayList());
    }

    @Test
    public void testAuditCategoryAndContext_NullContext() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT, null);
    }

    @Test
    public void testMalformedAuditFile_AssertFileReset() throws Exception {
        FileUtils.deleteQuietly((File)auditFile);
        FileOutputStream stream = FileUtils.openOutputStream((File)auditFile);
        for (int i = 0; i < 2048; ++i) {
            stream.write(65);
        }
        stream.close();
        FileAuditor auditor = new FileAuditor(auditFile);
        Assert.assertEquals((long)0L, (long)auditor.getEventCount().intValue());
        Assert.assertNull((Object)auditor.getLastEvent());
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
        Assert.assertEquals((long)2L, (long)auditor.getEventCount().intValue());
        Assert.assertNotNull((Object)auditor.getLastEvent());
    }

    @Test
    public void testClear() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
        auditor.clear();
        Assert.assertEquals((long)0L, (long)auditor.getEventCount().intValue());
        Assert.assertNull((Object)auditor.getLastEvent());
    }

    @Test
    public void testGetEventCount_AssertNoRecords() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.clear();
        Assert.assertEquals((long)0L, (long)auditor.getEventCount().intValue());
        Assert.assertNull((Object)auditor.getLastEvent());
    }

    @Test
    public void testGetEventCount_AssertRecordsExist() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
        Assert.assertEquals((long)2L, (long)auditor.getEventCount().intValue());
        Assert.assertNotNull((Object)auditor.getLastEvent());
    }

    @Test
    public void testGetLastEvent_AssertNoRecords() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.clear();
        Assert.assertNull((Object)auditor.getLastEvent());
    }

    @Test
    public void testGetLastEvent_AssertRecordContent() {
        FileAuditor auditor = new FileAuditor(auditFile);
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        auditor.audit(PRINCIPAL, event1);
        auditor.audit(PRINCIPAL, event2);
        Assert.assertNotNull((Object)auditor.getLastEvent());
        CompositeData lastMessage = auditor.getLastEvent();
        Assert.assertEquals((Object)event2.getName(), (Object)lastMessage.get("Event Name"));
        Assert.assertEquals((Object)event2.getType(), (Object)lastMessage.get("Event Type"));
        Assert.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)lastMessage.get("Contexts"));
    }

    @Test
    public void testGetLastEvent_AssertRecordContentAndContext() {
        FileAuditor auditor = new FileAuditor(auditFile);
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        auditor.audit(PRINCIPAL, event1);
        auditor.audit(PRINCIPAL, event2, Arrays.asList(context1, context2));
        Assert.assertNotNull((Object)auditor.getLastEvent());
        CompositeData lastMessage = auditor.getLastEvent();
        Assert.assertEquals((Object)event2.getName(), (Object)lastMessage.get("Event Name"));
        Assert.assertEquals((Object)event2.getType(), (Object)lastMessage.get("Event Type"));
        Assert.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)lastMessage.get("Contexts"));
        String[] contexts = (String[])lastMessage.get("Contexts");
        Assert.assertEquals((long)2L, (long)contexts.length);
        Assert.assertEquals((Object)"name1:value1", (Object)contexts[0]);
        Assert.assertEquals((Object)"name2:value2", (Object)contexts[1]);
    }

    @Test
    public void testGetEvents_AssertGotAllRecordsRequested() {
        FileAuditor auditor = new FileAuditor(auditFile);
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        auditor.audit(PRINCIPAL, event1);
        auditor.audit(PRINCIPAL, event2, Arrays.asList(context1, context2));
        CompositeData[] events = auditor.getEvents(Integer.valueOf(2));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.length);
        CompositeData lastMessage = events[0];
        Assert.assertEquals((Object)event2.getName(), (Object)lastMessage.get("Event Name"));
        Assert.assertEquals((Object)event2.getType(), (Object)lastMessage.get("Event Type"));
        Assert.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)lastMessage.get("Contexts"));
        String[] contexts = (String[])lastMessage.get("Contexts");
        Assert.assertEquals((long)2L, (long)contexts.length);
        Assert.assertEquals((Object)"name1:value1", (Object)contexts[0]);
        Assert.assertEquals((Object)"name2:value2", (Object)contexts[1]);
    }

    @Test
    public void testGetEvents_RequestMoreThanAvailable_AssertGotAllAvailableRecords() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.clear();
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        auditor.audit(PRINCIPAL, event1);
        auditor.audit(PRINCIPAL, event2, Arrays.asList(context1, context2));
        CompositeData[] events = auditor.getEvents(Integer.valueOf(5));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.length);
        CompositeData lastMessage = events[0];
        Assert.assertEquals((Object)event2.getName(), (Object)lastMessage.get("Event Name"));
        Assert.assertEquals((Object)event2.getType(), (Object)lastMessage.get("Event Type"));
        Assert.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)lastMessage.get("Contexts"));
        String[] contexts = (String[])lastMessage.get("Contexts");
        Assert.assertEquals((long)2L, (long)contexts.length);
        Assert.assertEquals((Object)"name1:value1", (Object)contexts[0]);
        Assert.assertEquals((Object)"name2:value2", (Object)contexts[1]);
    }

    @Test
    public void testGetEvents_RequestLessThanAvailable_AssertGotOnlyRecords() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.clear();
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        auditor.audit(PRINCIPAL, event1);
        auditor.audit(PRINCIPAL, event2, Arrays.asList(context1, context2));
        CompositeData[] events = auditor.getEvents(Integer.valueOf(1));
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)1L, (long)events.length);
        CompositeData lastMessage = events[0];
        Assert.assertEquals((Object)event2.getName(), (Object)lastMessage.get("Event Name"));
        Assert.assertEquals((Object)event2.getType(), (Object)lastMessage.get("Event Type"));
        Assert.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)lastMessage.get("Contexts"));
        String[] contexts = (String[])lastMessage.get("Contexts");
        Assert.assertEquals((long)2L, (long)contexts.length);
        Assert.assertEquals((Object)"name1:value1", (Object)contexts[0]);
        Assert.assertEquals((Object)"name2:value2", (Object)contexts[1]);
    }

    @Test
    public void testGetEvents_NoRecordsAvailable_NoRecordsFound() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.clear();
        CompositeData[] events = auditor.getEvents(Integer.valueOf(1));
        Assert.assertNull((Object)events);
    }

    @Test
    public void testGetEvents_NoRecordsRequested_ReturnedRecords() {
        FileAuditor auditor = new FileAuditor(auditFile);
        auditor.clear();
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        auditor.audit(PRINCIPAL, event1);
        auditor.audit(PRINCIPAL, event2, Arrays.asList(context1, context2));
        CompositeData[] events = auditor.getEvents(Integer.valueOf(0));
        Assert.assertNull((Object)events);
    }
}

