/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.DefaultAuditContext;
import org.nhindirect.common.audit.impl.LoggingAuditor;

public class LoggingAuditorTest {
    private static final String PRINCIPAL = "JUNITTEST";
    private static final AuditEvent UNIT_TEST_EVENT = new AuditEvent("name", "value");

    @Test
    public void testAuditEvent() {
        LoggingAuditor auditor = new LoggingAuditor();
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
    }

    @Test
    public void testAudit_NullPrincipal_AssertExeption() {
        LoggingAuditor auditor = new LoggingAuditor();
        boolean exceptionOccured = false;
        try {
            auditor.audit(null, UNIT_TEST_EVENT);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAuditCategoryAndMessage_EmptyPrincipal_AssertExeption() {
        LoggingAuditor auditor = new LoggingAuditor();
        boolean exceptionOccured = false;
        try {
            auditor.audit("", UNIT_TEST_EVENT);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAudit_NullEvent_AssertExeption() {
        LoggingAuditor auditor = new LoggingAuditor();
        boolean exceptionOccured = false;
        try {
            auditor.audit(PRINCIPAL, null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAuditWithContext() {
        LoggingAuditor auditor = new LoggingAuditor();
        List<DefaultAuditContext> ctx = Arrays.asList(new DefaultAuditContext("name", "value"));
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT, ctx);
    }
}

