/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.DefaultAuditContext;
import org.nhindirect.common.audit.impl.ExceptionAuditor;
import org.nhindirect.common.audit.impl.LoggingAuditor;
import org.nhindirect.common.audit.impl.MultiProviderAuditor;
import org.nhindirect.common.audit.impl.NoOpAuditor;

public class MultiProviderAuditorTest {
    private static final String PRINCIPAL = "JUNITTEST";
    private static final AuditEvent UNIT_TEST_EVENT = new AuditEvent("name", "value");

    @Test
    public void testCreateAuditor_NullAuditors_AssertException() {
        boolean exceptionOccured = false;
        try {
            new MultiProviderAuditor(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testCreateAuditor_EmptyAuditors_AssertException() {
        boolean exceptionOccured = false;
        try {
            new MultiProviderAuditor(new ArrayList());
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAuditEvent() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
    }

    @Test
    public void testAudit_NullPrincipal_AssertExeption() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        boolean exceptionOccured = false;
        try {
            auditor.audit(null, UNIT_TEST_EVENT);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAuditCategoryAndMessage_EmptyPrincipal_AssertExeption() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        boolean exceptionOccured = false;
        try {
            auditor.audit("", UNIT_TEST_EVENT);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAudit_NullEvent_AssertExeption() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        boolean exceptionOccured = false;
        try {
            auditor.audit(PRINCIPAL, null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testAuditWithContext() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        List<DefaultAuditContext> ctx = Arrays.asList(new DefaultAuditContext("name", "value"));
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT, ctx);
    }

    @Test
    public void testAuditCategoryAndMessage_OneAuditorFails() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new ExceptionAuditor()));
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
    }
}

