/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.util.Arrays;
import javax.management.openmbean.CompositeData;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.DefaultAuditContext;
import org.nhindirect.common.audit.impl.RDBMSAuditorBaseTest;

public class RDBMSAuditor_getLastEventTest
extends RDBMSAuditorBaseTest {
    @Test
    public void testGetLastEventTest_noContexts_lastEventRetrieved() throws Exception {
        AuditEvent auditEvent = new AuditEvent("name1", "value1");
        this.auditorImpl.audit("testPin", auditEvent, null);
        CompositeData lastMessage = this.auditorImpl.getLastEvent();
        Assert.assertNotNull((Object)lastMessage);
        Assert.assertEquals((Object)auditEvent.getName(), (Object)lastMessage.get("Event Name"));
        Assert.assertEquals((Object)auditEvent.getType(), (Object)lastMessage.get("Event Type"));
        Assert.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)lastMessage.get("Contexts"));
        String[] contexts = (String[])lastMessage.get("Contexts");
        Assert.assertEquals((long)1L, (long)contexts.length);
    }

    @Test
    public void testGetLastEventTest_withContexts_lastEventRetrieved() throws Exception {
        AuditEvent auditEvent = new AuditEvent("name1", "value1");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        this.auditorImpl.audit("testPin", auditEvent, Arrays.asList(context1, context2));
        CompositeData lastMessage = this.auditorImpl.getLastEvent();
        Assert.assertNotNull((Object)lastMessage);
        Assert.assertEquals((Object)auditEvent.getName(), (Object)lastMessage.get("Event Name"));
        Assert.assertEquals((Object)auditEvent.getType(), (Object)lastMessage.get("Event Type"));
        Assert.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)lastMessage.get("Contexts"));
        String[] contexts = (String[])lastMessage.get("Contexts");
        Assert.assertEquals((long)2L, (long)contexts.length);
        Assert.assertEquals((Object)"name1:value1", (Object)contexts[0]);
        Assert.assertEquals((Object)"name2:value2", (Object)contexts[1]);
    }

    @Test
    public void testGetLastEventTest_noEntries_assertNull() throws Exception {
        CompositeData lastMessage = this.auditorImpl.getLastEvent();
        Assert.assertNull((Object)lastMessage);
    }
}

