/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.audit.AuditEvent;

public class AuditEventTest {
    @Test
    public void testConstructAuditEvent() throws Exception {
        AuditEvent event = new AuditEvent("category", "type");
        Assertions.assertNotNull((Object)event);
    }

    @Test
    public void testGetName() throws Exception {
        AuditEvent event = new AuditEvent("category", "type");
        Assertions.assertEquals((Object)"category", (Object)event.getName());
    }

    @Test
    public void testGetType() throws Exception {
        AuditEvent event = new AuditEvent("category", "type");
        Assertions.assertEquals((Object)"type", (Object)event.getType());
    }

    @Test
    public void testConstructAuditEvent_EmptyName_AssertIllgalArgumentException() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AuditEvent("", "value"));
    }

    @Test
    public void testConstructAuditEvent_NullName_AssertIllgalArgumentException() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AuditEvent(null, "value"));
    }

    @Test
    public void testConstructAuditEvent_NullType_AssertIllgalArgumentException() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AuditEvent("category", null));
    }

    @Test
    public void testConstructAuditEvent_EmptyType_AssertIllgalArgumentException() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AuditEvent("category", ""));
    }

    @Test
    public void testEquals() throws Exception {
        AuditEvent event1 = new AuditEvent("category", "type");
        AuditEvent event2 = new AuditEvent("category", "type");
        Assertions.assertTrue((boolean)event1.equals((Object)event2));
    }

    @Test
    public void testEquals_DifferentName_AssertNotEqual() throws Exception {
        AuditEvent event1 = new AuditEvent("category1", "type");
        AuditEvent event2 = new AuditEvent("category2", "type");
        Assertions.assertFalse((boolean)event1.equals((Object)event2));
    }

    @Test
    public void testEquals_DifferentType_AssertNotEqual() throws Exception {
        AuditEvent event1 = new AuditEvent("category", "type1");
        AuditEvent event2 = new AuditEvent("category", "type2");
        Assertions.assertFalse((boolean)event1.equals((Object)event2));
    }

    @Test
    public void testEquals_DifferentObject_AssertNotEqual() throws Exception {
        AuditEvent event = new AuditEvent("category", "type1");
        Assertions.assertFalse((boolean)event.equals((Object)event.toString()));
    }
}

