/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.Auditor;
import org.nhindirect.common.audit.DefaultAuditContext;
import org.nhindirect.common.audit.impl.ExceptionAuditor;
import org.nhindirect.common.audit.impl.LoggingAuditor;
import org.nhindirect.common.audit.impl.MultiProviderAuditor;
import org.nhindirect.common.audit.impl.NoOpAuditor;

class MultiProviderAuditorTest {
    private static final String PRINCIPAL = "JUNITTEST";
    private static final AuditEvent UNIT_TEST_EVENT = new AuditEvent("name", "value");

    MultiProviderAuditorTest() {
    }

    @Test
    public void testCreateAuditor_NullAuditors_AssertException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MultiProviderAuditor(null));
    }

    @Test
    public void testCreateAuditor_EmptyAuditors_AssertException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MultiProviderAuditor(new ArrayList()));
    }

    @Test
    public void testAuditEvent() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
    }

    @Test
    public void testAudit_NullPrincipal_AssertExeption() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MultiProviderAuditorTest.lambda$testAudit_NullPrincipal_AssertExeption$2((Auditor)auditor));
    }

    @Test
    public void testAuditCategoryAndMessage_EmptyPrincipal_AssertExeption() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MultiProviderAuditorTest.lambda$testAuditCategoryAndMessage_EmptyPrincipal_AssertExeption$3((Auditor)auditor));
    }

    @Test
    public void testAudit_NullEvent_AssertExeption() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MultiProviderAuditorTest.lambda$testAudit_NullEvent_AssertExeption$4((Auditor)auditor));
    }

    @Test
    public void testAuditWithContext() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new NoOpAuditor()));
        List<DefaultAuditContext> ctx = Arrays.asList(new DefaultAuditContext("name", "value"));
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT, ctx);
    }

    @Test
    public void testAuditCategoryAndMessage_OneAuditorFails() {
        MultiProviderAuditor auditor = new MultiProviderAuditor(Arrays.asList(new LoggingAuditor(), new ExceptionAuditor()));
        auditor.audit(PRINCIPAL, UNIT_TEST_EVENT);
    }

    private static /* synthetic */ void lambda$testAudit_NullEvent_AssertExeption$4(Auditor auditor) throws Throwable {
        auditor.audit(PRINCIPAL, null);
    }

    private static /* synthetic */ void lambda$testAuditCategoryAndMessage_EmptyPrincipal_AssertExeption$3(Auditor auditor) throws Throwable {
        auditor.audit("", UNIT_TEST_EVENT);
    }

    private static /* synthetic */ void lambda$testAudit_NullPrincipal_AssertExeption$2(Auditor auditor) throws Throwable {
        auditor.audit(null, UNIT_TEST_EVENT);
    }
}

