/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.util.Arrays;
import java.util.UUID;
import javax.management.openmbean.CompositeData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.DefaultAuditContext;
import org.nhindirect.common.audit.impl.RDBMSAuditorBaseTest;

public class RDBMSAuditor_getEventsTest
extends RDBMSAuditorBaseTest {
    private static final String PRINCIPAL = "JUNITTEST";

    @Test
    public void testGetEvents_AssertGotAllRecordsRequested() {
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        this.auditorImpl.audit(PRINCIPAL, event1);
        this.auditorImpl.audit(PRINCIPAL, event2, Arrays.asList(context1, context2));
        CompositeData[] events = this.auditorImpl.getEvents(Integer.valueOf(2));
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)2, (int)events.length);
        CompositeData lastMessage = events[0];
        Assertions.assertEquals((Object)event2.getName(), (Object)lastMessage.get("Event Name"));
        Assertions.assertEquals((Object)event2.getType(), (Object)lastMessage.get("Event Type"));
        Assertions.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)lastMessage.get("Contexts"));
        String[] contexts = (String[])lastMessage.get("Contexts");
        Assertions.assertEquals((int)2, (int)contexts.length);
        Assertions.assertEquals((Object)"name1:value1", (Object)contexts[0]);
        Assertions.assertEquals((Object)"name2:value2", (Object)contexts[1]);
    }

    @Test
    public void testGetEvents_RequestMoreThanAvailable_AssertGotAllAvailableRecords() {
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        this.auditorImpl.audit(PRINCIPAL, event1);
        this.auditorImpl.audit(PRINCIPAL, event2, Arrays.asList(context1, context2));
        CompositeData[] events = this.auditorImpl.getEvents(Integer.valueOf(5));
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)2, (int)events.length);
        CompositeData lastMessage = events[0];
        Assertions.assertEquals((Object)event2.getName(), (Object)lastMessage.get("Event Name"));
        Assertions.assertEquals((Object)event2.getType(), (Object)lastMessage.get("Event Type"));
        Assertions.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)lastMessage.get("Contexts"));
        String[] contexts = (String[])lastMessage.get("Contexts");
        Assertions.assertEquals((int)2, (int)contexts.length);
        Assertions.assertEquals((Object)"name1:value1", (Object)contexts[0]);
        Assertions.assertEquals((Object)"name2:value2", (Object)contexts[1]);
    }

    @Test
    public void testGetEvents_RequestLessThanAvailable_AssertGotOnlyRecords() {
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        this.auditorImpl.audit(PRINCIPAL, event1);
        this.auditorImpl.audit(PRINCIPAL, event2, Arrays.asList(context1, context2));
        CompositeData[] events = this.auditorImpl.getEvents(Integer.valueOf(1));
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)1, (int)events.length);
        CompositeData lastMessage = events[0];
        Assertions.assertEquals((Object)event2.getName(), (Object)lastMessage.get("Event Name"));
        Assertions.assertEquals((Object)event2.getType(), (Object)lastMessage.get("Event Type"));
        Assertions.assertTrue((lastMessage.get("Event Id").toString().length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((lastMessage.get("Event Time").toString().length() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)lastMessage.get("Contexts"));
        String[] contexts = (String[])lastMessage.get("Contexts");
        Assertions.assertEquals((int)2, (int)contexts.length);
        Assertions.assertEquals((Object)"name1:value1", (Object)contexts[0]);
        Assertions.assertEquals((Object)"name2:value2", (Object)contexts[1]);
    }

    @Test
    public void testGetEvents_NoRecordsAvailable_NoRecordsFound() {
        CompositeData[] events = this.auditorImpl.getEvents(Integer.valueOf(1));
        Assertions.assertNull((Object)events);
    }

    @Test
    public void testGetEvents_NoRecordsRequested_ReturnedRecords() {
        AuditEvent event1 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        AuditEvent event2 = new AuditEvent("Category" + UUID.randomUUID(), "type");
        DefaultAuditContext context1 = new DefaultAuditContext("name1", "value1");
        DefaultAuditContext context2 = new DefaultAuditContext("name2", "value2");
        this.auditorImpl.audit(PRINCIPAL, event1);
        this.auditorImpl.audit(PRINCIPAL, event2, Arrays.asList(context1, context2));
        CompositeData[] events = this.auditorImpl.getEvents(Integer.valueOf(0));
        Assertions.assertNull((Object)events);
    }
}

