/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.util.Calendar;
import java.util.Collection;
import java.util.UUID;
import org.nhindirect.common.audit.AuditContext;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.impl.AbstractAuditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAuditor
extends AbstractAuditor {
    private static final Logger log = LoggerFactory.getLogger(LoggingAuditor.class);
    private static final String EVENT_TAG = "[DIRECT AUDIT EVENT]";
    private static final String EVENT_ID = "EVENT ID";
    private static final String EVENT_PRINCIPAL = "EVENT PRINCIPAL";
    private static final String EVENT_NAME = "EVENT CATEGORY";
    private static final String EVENT_TYPE = "EVENT MESSAGE";
    private static final String EVENT_CTX = "EVENT CONTEXTS";

    @Override
    public void writeEvent(UUID eventId, Calendar eventTimeStamp, String principal, AuditEvent event, Collection<? extends AuditContext> contexts) {
        log.info(this.buildEventString(eventId, principal, event, contexts));
    }

    private String buildEventString(UUID eventId, String principal, AuditEvent event, Collection<? extends AuditContext> contexts) {
        StringBuilder builder = new StringBuilder(EVENT_TAG);
        builder.append("\r\n\tEVENT ID: " + eventId);
        builder.append("\r\n\tEVENT PRINCIPAL: " + principal);
        builder.append("\r\n\tEVENT CATEGORY: " + event.getName());
        builder.append("\r\n\tEVENT MESSAGE: " + event.getType());
        if (contexts != null && contexts.size() > 0) {
            builder.append("\r\n\tEVENT CONTEXTS");
            for (AuditContext auditContext : contexts) {
                builder.append("\r\n\t\t" + auditContext.getContextName() + ":" + auditContext.getContextValue());
            }
        }
        return builder.toString();
    }
}

