/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.util.Collection;
import java.util.Collections;
import org.nhindirect.common.audit.AuditContext;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.Auditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProviderAuditor
implements Auditor {
    private static final Logger log = LoggerFactory.getLogger(MultiProviderAuditor.class);
    private final Collection<? extends Auditor> auditors;

    public MultiProviderAuditor(Collection<? extends Auditor> auditors) {
        if (auditors == null || auditors.size() == 0) {
            throw new IllegalArgumentException("Auditors collection cannot be null or empty");
        }
        this.auditors = Collections.unmodifiableCollection(auditors);
    }

    @Override
    public void audit(String principal, AuditEvent event) {
        this.audit(principal, event, null);
    }

    @Override
    public void audit(String principal, AuditEvent event, Collection<? extends AuditContext> contexts) {
        if (principal == null || principal.isEmpty()) {
            throw new IllegalArgumentException("Principal cannot be null or empty");
        }
        if (event == null) {
            throw new IllegalArgumentException("Event cannot be null");
        }
        for (Auditor auditor : this.auditors) {
            try {
                auditor.audit(principal, event, contexts);
            }
            catch (Exception e) {
                log.error("Failed to audit event using auditor " + auditor.getClass().getName(), (Throwable)e);
            }
        }
    }
}

