/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.nhindirect.common.audit.AbstractAuditor;
import org.nhindirect.common.audit.AuditorMBean;
import org.nhindirect.common.audit.impl.RDBMSAuditContextRepository;
import org.nhindirect.common.audit.impl.RDBMSAuditEventRepository;
import org.nhindirect.common.audit.impl.entity.AuditContext;
import org.nhindirect.common.audit.impl.entity.AuditEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import reactor.core.publisher.Mono;

public class RDBMSAuditor
extends AbstractAuditor
implements AuditorMBean {
    private static final Logger log = LoggerFactory.getLogger(RDBMSAuditor.class);
    private String[] itemNames;
    private CompositeType eventType;
    @Autowired
    protected RDBMSAuditEventRepository eventRepo;
    @Autowired
    protected RDBMSAuditContextRepository contextRepo;

    public RDBMSAuditor() {
        this.registerMBean();
    }

    public RDBMSAuditor(RDBMSAuditEventRepository eventRepo, RDBMSAuditContextRepository contextRepo) {
        this();
        this.setEventRepo(eventRepo);
        this.setContextRepo(contextRepo);
    }

    public void setEventRepo(RDBMSAuditEventRepository eventRepo) {
        this.eventRepo = eventRepo;
    }

    public void setContextRepo(RDBMSAuditContextRepository contextRepo) {
        this.contextRepo = contextRepo;
    }

    private void registerMBean() {
        log.info("Registering RDBMSAuditor MBean");
        try {
            this.itemNames = new String[]{"Event Id", "Event Time", "Event Principal", "Event Name", "Event Type", "Contexts"};
            OpenType[] types = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, ArrayType.getArrayType(SimpleType.STRING)};
            this.eventType = new CompositeType("AuditEvent", "Direct Auditable Event", this.itemNames, this.itemNames, types);
        }
        catch (OpenDataException e) {
            log.error("Failed to create settings composite type: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return;
        }
        Class<?> clazz = this.getClass();
        StringBuilder objectNameBuilder = new StringBuilder(clazz.getPackage().getName());
        objectNameBuilder.append(":type=").append(clazz.getSimpleName());
        objectNameBuilder.append(",name=").append(UUID.randomUUID());
        try {
            StandardMBean mbean = new StandardMBean(this, AuditorMBean.class);
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            mbeanServer.registerMBean(mbean, new ObjectName(objectNameBuilder.toString()));
        }
        catch (JMException e) {
            log.error("Unable to register the RDBMSAuditors MBean", (Throwable)e);
        }
    }

    @Override
    public void writeEvent(UUID eventId, Calendar eventTimeStamp, String principal, org.nhindirect.common.audit.AuditEvent event, Collection<? extends org.nhindirect.common.audit.AuditContext> contexts) {
        AuditEvent newEvent = new AuditEvent();
        newEvent.setEventName(event.getName());
        newEvent.setEventType(event.getType());
        newEvent.setEventTime(LocalDateTime.now());
        newEvent.setPrincipal(principal);
        newEvent.setUUID(eventId.toString());
        newEvent = (AuditEvent)this.eventRepo.save(newEvent).block();
        if (contexts != null && !contexts.isEmpty()) {
            ArrayList<AuditContext> entityContexts = new ArrayList<AuditContext>();
            for (org.nhindirect.common.audit.AuditContext auditContext : contexts) {
                AuditContext newContext = new AuditContext();
                newContext.setContextName(auditContext.getContextName());
                newContext.setContextValue(auditContext.getContextValue());
                newContext.setAuditEventId(newEvent.getId());
                entityContexts.add(newContext);
            }
            this.contextRepo.saveAll(entityContexts).collectList().block();
        }
    }

    @Override
    public Integer getEventCount() {
        return ((Long)this.eventRepo.count().block()).intValue();
    }

    @Override
    public CompositeData[] getEvents(Integer eventCount) {
        if (this.eventType == null || eventCount == 0) {
            return null;
        }
        Vector retVal = new Vector();
        List dataSupports = (List)this.eventRepo.findAllOrderByEventTimeDesc().take((long)eventCount.intValue()).flatMap(evt -> this.contextRepo.findByAuditEventId(evt.getId()).collectList().flatMap(ctxs -> {
            String[] contexts = null;
            if (!ctxs.isEmpty()) {
                contexts = new String[ctxs.size()];
                int idx = 0;
                for (AuditContext ctx : ctxs) {
                    contexts[idx++] = ctx.getContextName() + ":" + ctx.getContextValue();
                }
            } else {
                contexts = new String[]{" "};
            }
            Object[] eventValues = new Object[]{evt.getUUID(), evt.getEventTime().toString(), evt.getPrincipal(), evt.getEventName(), evt.getEventType(), contexts};
            try {
                return Mono.just((Object)new CompositeDataSupport(this.eventType, this.itemNames, eventValues));
            }
            catch (Exception e) {
                log.error("Error create composit data for audit event.", (Throwable)e);
                return Mono.empty();
            }
        })).collectList().block();
        if (dataSupports.isEmpty()) {
            return null;
        }
        retVal.addAll(dataSupports);
        return retVal.toArray(new CompositeData[retVal.size()]);
    }

    @Override
    public CompositeData getLastEvent() {
        CompositeData[] events = this.getEvents(1);
        if (events == null || events.length == 0) {
            return null;
        }
        return events[0];
    }

    @Override
    public void clear() {
        this.contextRepo.deleteAll().then(this.eventRepo.deleteAll()).block();
    }
}

