/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Vector;
import org.nhindirect.common.audit.Auditor;
import org.nhindirect.common.audit.impl.MultiProviderAuditor;

public class SPIAuditorFactory {
    private static Map<ClassLoader, SPIAuditorFactory> INSTANCE_MAP = new HashMap<ClassLoader, SPIAuditorFactory>();
    private final Auditor implementation;

    public static synchronized SPIAuditorFactory getInstance(ClassLoader cl) {
        ClassLoader lookupLoader = cl != null ? cl : SPIAuditorFactory.class.getClassLoader();
        SPIAuditorFactory INSTANCE = INSTANCE_MAP.get(lookupLoader);
        if (INSTANCE == null) {
            INSTANCE = new SPIAuditorFactory(lookupLoader);
            INSTANCE_MAP.put(lookupLoader, INSTANCE);
        }
        return INSTANCE;
    }

    private SPIAuditorFactory(ClassLoader cLoader) {
        ServiceLoader<Auditor> loader = ServiceLoader.load(Auditor.class, cLoader);
        Iterator<Auditor> iter = null;
        if (loader != null && (iter = loader.iterator()) != null) {
            Vector<Auditor> implementations = new Vector<Auditor>();
            while (iter.hasNext()) {
                implementations.add(iter.next());
            }
            this.implementation = implementations.size() == 0 ? null : (implementations.size() == 1 ? (Auditor)implementations.firstElement() : new MultiProviderAuditor(implementations));
        } else {
            this.implementation = null;
        }
    }

    public boolean isImplementationAvailable() {
        return this.implementation != null;
    }

    public Auditor getAuditorImplementation() {
        if (!this.isImplementationAvailable()) {
            return null;
        }
        return this.implementation;
    }
}

