/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.james.server.authfilter;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.james.webadmin.authentication.AuthenticationFilter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class WebAdminBasicAuthFilter
implements AuthenticationFilter {
    public static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    public static final String AUTHORIZATION_HEADER_PREFIX = "Basic ";
    public static final String OPTIONS = "OPTIONS";
    protected final String user;
    protected final byte[] passHash;
    protected final MessageDigest digest;

    public WebAdminBasicAuthFilter(String user, String pass) {
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
            this.user = user;
            this.passHash = this.digest.digest(pass.getBytes(Charset.defaultCharset()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error creating webadmin password hash: " + e.getMessage());
        }
    }

    public void handle(Request request, Response response) throws Exception {
        if (request.requestMethod() != OPTIONS) {
            Optional<String> basicAuth = Optional.ofNullable(request.headers(AUTHORIZATION_HEADER_NAME)).filter(value -> value.startsWith(AUTHORIZATION_HEADER_PREFIX)).map(value -> value.substring(AUTHORIZATION_HEADER_PREFIX.length()));
            this.checkHeaderPresent(basicAuth);
            String[] subjectAndSecret = new String(Base64.decodeBase64((String)basicAuth.get()), Charset.defaultCharset()).split(":");
            String user = subjectAndSecret[0];
            String pass = subjectAndSecret[1];
            this.checkValidPass(pass);
            this.checkIsAdmin(user);
        }
    }

    private void checkHeaderPresent(Optional<String> basicAuth) {
        if (!basicAuth.isPresent()) {
            Spark.halt((int)401, (String)"No Basic Auth header.");
        }
    }

    private void checkIsAdmin(String user) {
        if (user.compareToIgnoreCase(this.user) != 0) {
            Spark.halt((int)401, (String)"Non authorized user.");
        }
    }

    private void checkValidPass(String pass) {
        byte[] passDigest = this.digest.digest(pass.getBytes(Charset.defaultCharset()));
        if (!Objects.deepEquals(passDigest, this.passHash)) {
            Spark.halt((int)401, (String)"Invalid login.");
        }
    }
}

