/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.james.server.data;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.nhind.config.rest.DomainService;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.Address;
import org.nhindirect.config.model.Domain;
import org.nhindirect.config.model.EntityStatus;

public class ConfigServiceDomainList
extends AbstractDomainList {
    protected final DomainService domService;

    @Inject
    public ConfigServiceDomainList(DNSService dns, DomainService domService) {
        super(dns);
        this.domService = domService;
    }

    public org.apache.james.core.Domain getDefaultDomain() throws DomainListException {
        return org.apache.james.core.Domain.of((String)"domain.com");
    }

    protected boolean containsDomainInternal(org.apache.james.core.Domain domain) throws DomainListException {
        try {
            return !this.domService.searchDomains(domain.name(), null).isEmpty();
        }
        catch (ServiceException e) {
            throw new DomainListException("Failed to determine if domain exists.", (Throwable)e);
        }
    }

    public void addDomain(org.apache.james.core.Domain domain) throws DomainListException {
        try {
            if (this.containsDomainInternal(domain)) {
                throw new DomainListException(domain.name() + " already exists.");
            }
            Address addr = new Address();
            addr.setStatus(EntityStatus.ENABLED);
            addr.setDisplayName("Postmaster");
            addr.setEmailAddress("postmaster@" + domain.name());
            addr.setEndpoint("postmaster@" + domain.name());
            addr.setDomainName(domain.name());
            Domain newDom = new Domain();
            newDom.setDomainName(domain.name());
            newDom.setStatus(EntityStatus.ENABLED);
            newDom.setPostmasterAddress(null);
            newDom.setAddresses(Collections.singleton(addr));
            this.domService.addDomain(newDom);
        }
        catch (ServiceException e) {
            throw new DomainListException("Unable to add domain " + domain.name(), (Throwable)e);
        }
    }

    public void removeDomain(org.apache.james.core.Domain domain) throws DomainListException {
        try {
            if (this.containsDomainInternal(domain)) {
                throw new DomainListException(domain.name() + " was not found.");
            }
            this.domService.deleteDomain(domain.name());
        }
        catch (ServiceException e) {
            throw new DomainListException("Unable to remove domain " + domain.name(), (Throwable)e);
        }
    }

    protected List<org.apache.james.core.Domain> getDomainListInternal() throws DomainListException {
        try {
            List domains = (List)this.domService.searchDomains("", null).stream().map(dom -> org.apache.james.core.Domain.of((String)dom.getDomainName())).collect(Guavate.toImmutableList());
            return ImmutableList.copyOf((Collection)domains);
        }
        catch (ServiceException e) {
            throw new DomainListException("Unable to retrieve domains", (Throwable)e);
        }
    }

    public ImmutableList<org.apache.james.core.Domain> getDomains() throws DomainListException {
        return ImmutableList.copyOf((Collection)this.getDomainListInternal());
    }
}

